/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Credentials {
    public final String login;
    public final String password;

    public Credentials(String login, String password) {
        this.login = login;
        this.password = password;
    }

    @CheckReturnValue
    @Nonnull
    public String encode() {
        byte[] credentialsBytes = this.combine().getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(credentialsBytes);
    }

    private String combine() {
        return String.format("%s:%s", this.login, this.password);
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return this.combine();
    }
}

