/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.ex.ConditionMetException;
import com.codeborne.selenide.ex.ConditionNotMetException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.time.Duration;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class Waiter {
    private static final Logger logger = LoggerFactory.getLogger(Waiter.class);

    @CheckReturnValue
    public <T> void wait(T subject, Predicate<T> condition, long timeout, long pollingInterval) {
        this.sleep(pollingInterval);
        long start = System.currentTimeMillis();
        while (!this.isTimeoutExceeded(timeout, start) && !condition.test(subject)) {
            this.sleep(pollingInterval);
        }
    }

    public <T> void wait(Driver driver, T subject, ObjectCondition<T> condition) {
        this.wait(driver, subject, condition, driver.config().timeout(), driver.config().pollingInterval());
    }

    public <T> void wait(Driver driver, T subject, ObjectCondition<T> condition, Duration timeout) {
        this.wait(driver, subject, condition, timeout.toMillis(), driver.config().pollingInterval());
    }

    private <T> void wait(Driver driver, T subject, ObjectCondition<T> condition, long timeout, long pollingInterval) {
        SelenideLog log = SelenideLogger.beginStep(condition.describe(subject), condition.description());
        long start = System.currentTimeMillis();
        while (!this.isTimeoutExceeded(timeout, start)) {
            if (this.checkUnThrowable(subject, condition)) {
                SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
                return;
            }
            this.sleep(pollingInterval);
        }
        Error failure = UIAssertionError.wrap(driver, (Error)((Object)new ConditionNotMetException(driver, condition, subject)), timeout);
        SelenideLogger.commitStep(log, failure);
        throw failure;
    }

    public <T> void waitWhile(Driver driver, T subject, ObjectCondition<T> condition) {
        this.waitWhile(driver, subject, condition, driver.config().timeout(), driver.config().pollingInterval());
    }

    public <T> void waitWhile(Driver driver, T subject, ObjectCondition<T> condition, Duration timeout) {
        this.waitWhile(driver, subject, condition, timeout.toMillis(), driver.config().pollingInterval());
    }

    private <T> void waitWhile(Driver driver, T subject, ObjectCondition<T> condition, long timeout, long pollingInterval) {
        SelenideLog log = SelenideLogger.beginStep(subject.toString(), condition.negativeDescription());
        long start = System.currentTimeMillis();
        while (!this.isTimeoutExceeded(timeout, start)) {
            if (!this.checkUnThrowable(subject, condition)) {
                SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
                return;
            }
            this.sleep(pollingInterval);
        }
        Error failure = UIAssertionError.wrap(driver, (Error)((Object)new ConditionMetException(driver, condition, subject)), timeout);
        SelenideLogger.commitStep(log, failure);
        throw failure;
    }

    private boolean isTimeoutExceeded(long timeout, long start) {
        return System.currentTimeMillis() - start > timeout;
    }

    private void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private <T> boolean checkUnThrowable(T subject, ObjectCondition<T> predicate) {
        try {
            return predicate.test(subject);
        }
        catch (Exception e) {
            logger.info("Fail to check condition", (Throwable)e);
            return false;
        }
    }
}

