/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.ErrorMessages;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import com.codeborne.selenide.impl.Screenshot;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class UIAssertionError
extends AssertionError {
    private static final Logger log = LoggerFactory.getLogger(UIAssertionError.class);
    private final Driver driver;
    private Screenshot screenshot = Screenshot.none();
    public long timeoutMs;

    protected UIAssertionError(Driver driver, String message) {
        super((Object)message);
        this.driver = driver;
    }

    protected UIAssertionError(Driver driver, String message, @Nullable Throwable cause) {
        super(message, cause);
        this.driver = driver;
    }

    @CheckReturnValue
    public final String getMessage() {
        return super.getMessage() + this.uiDetails();
    }

    @CheckReturnValue
    public final String toString() {
        return this.getMessage();
    }

    @CheckReturnValue
    protected String uiDetails() {
        return this.screenshot.summary() + ErrorMessages.timeout(this.timeoutMs) + ErrorMessages.causedBy(this.getCause());
    }

    @CheckReturnValue
    public Screenshot getScreenshot() {
        return this.screenshot;
    }

    @CheckReturnValue
    public static Error wrap(Driver driver, Error error, long timeoutMs) {
        return Cleanup.of.isInvalidSelectorError(error) ? error : UIAssertionError.wrapThrowable(driver, error, timeoutMs);
    }

    @CheckReturnValue
    public static Throwable wrap(Driver driver, WebDriverException error, long timeoutMs) {
        return Cleanup.of.isInvalidSelectorError(error) ? error : UIAssertionError.wrapThrowable(driver, error, timeoutMs);
    }

    @CheckReturnValue
    private static UIAssertionError wrapThrowable(Driver driver, Throwable error, long timeoutMs) {
        UIAssertionError uiError = error instanceof UIAssertionError ? (UIAssertionError)((Object)error) : UIAssertionError.wrapToUIAssertionError(driver, error);
        uiError.timeoutMs = timeoutMs;
        if (uiError.screenshot.isPresent()) {
            log.warn("UIAssertionError already has screenshot: {} {} -> {}", new Object[]{((Object)((Object)uiError)).getClass().getName(), uiError.getMessage(), uiError.screenshot});
        } else {
            Config config = driver.config();
            uiError.screenshot = ScreenShotLaboratory.getInstance().takeScreenshot(driver, config.screenshots(), config.savePageSource());
        }
        return uiError;
    }

    @CheckReturnValue
    private static UIAssertionError wrapToUIAssertionError(Driver driver, Throwable error) {
        String message = error.getClass().getSimpleName() + ": " + Cleanup.of.webdriverExceptionMessage(error.getMessage());
        return new UIAssertionError(driver, message, error);
    }
}

