/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.clipboard;

import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Content
implements ObjectCondition<Clipboard> {
    private final String expectedContent;

    public Content(String expectedContent) {
        this.expectedContent = expectedContent;
    }

    @Override
    @Nonnull
    public String description() {
        return String.format("should have content '%s'", this.expectedContent);
    }

    @Override
    @Nonnull
    public String negativeDescription() {
        return String.format("should not have content '%s'", this.expectedContent);
    }

    @Override
    public boolean test(Clipboard clipboard) {
        return clipboard.getText().equals(this.expectedContent);
    }

    @Override
    @Nullable
    public String actualValue(Clipboard clipboard) {
        return clipboard.getText();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(Clipboard clipboard) {
        return "clipboard";
    }
}

