/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.CollectionElementByCondition;
import com.codeborne.selenide.impl.CollectionSnapshot;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.FilteringCollection;
import com.codeborne.selenide.impl.HeadOfCollection;
import com.codeborne.selenide.impl.LastCollectionElement;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.SelenideElementIterator;
import com.codeborne.selenide.impl.SelenideElementListIterator;
import com.codeborne.selenide.impl.TailOfCollection;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.time.Duration;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ElementsCollection
extends AbstractList<SelenideElement> {
    private static final ElementDescriber describe = Plugins.inject(ElementDescriber.class);
    private final CollectionSource collection;

    public ElementsCollection(CollectionSource collection) {
        this.collection = collection;
    }

    public ElementsCollection(Driver driver, Collection<? extends WebElement> elements) {
        this(new WebElementsCollectionWrapper(driver, elements));
    }

    public ElementsCollection(Driver driver, String cssSelector) {
        this(driver, By.cssSelector((String)cssSelector));
    }

    public ElementsCollection(Driver driver, By seleniumSelector) {
        this(new BySelectorCollection(driver, seleniumSelector));
    }

    @Nonnull
    @Deprecated
    public ElementsCollection shouldHaveSize(int expectedSize) {
        return this.shouldHave(CollectionCondition.size(expectedSize));
    }

    @Nonnull
    public ElementsCollection should(CollectionCondition ... conditions) {
        return this.should("", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public ElementsCollection should(CollectionCondition condition, Duration timeout) {
        return this.should("", timeout, this.toArray(condition));
    }

    @Nonnull
    public ElementsCollection shouldBe(CollectionCondition ... conditions) {
        return this.should("be", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public ElementsCollection shouldBe(CollectionCondition condition, Duration timeout) {
        return this.should("be", timeout, this.toArray(condition));
    }

    @Nonnull
    @Deprecated
    public ElementsCollection shouldBe(CollectionCondition condition, long timeoutMs) {
        return this.should("be", Duration.ofMillis(timeoutMs), this.toArray(condition));
    }

    @Nonnull
    public ElementsCollection shouldHave(CollectionCondition ... conditions) {
        return this.should("have", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public ElementsCollection shouldHave(CollectionCondition condition, Duration timeout) {
        return this.should("have", timeout, this.toArray(condition));
    }

    @Nonnull
    @Deprecated
    public ElementsCollection shouldHave(CollectionCondition condition, long timeoutMs) {
        return this.should("have", Duration.ofMillis(timeoutMs), this.toArray(condition));
    }

    private CollectionCondition[] toArray(CollectionCondition condition) {
        return new CollectionCondition[]{condition};
    }

    protected ElementsCollection should(String prefix, Duration timeout, CollectionCondition ... conditions) {
        ErrorsCollector.validateAssertionMode(this.driver().config());
        SelenideLog log = SelenideLogger.beginStep(this.collection.description(), "should " + prefix, conditions);
        try {
            for (CollectionCondition condition : conditions) {
                this.waitUntil(condition, timeout);
            }
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return this;
        }
        catch (Error error) {
            Error wrappedError = UIAssertionError.wrap(this.driver(), error, timeout.toMillis());
            SelenideLogger.commitStep(log, wrappedError);
            switch (this.driver().config().assertionMode()) {
                case SOFT: {
                    return this;
                }
            }
            throw wrappedError;
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    protected void waitUntil(CollectionCondition condition, Duration timeout) {
        Object lastError = null;
        List<WebElement> actualElements = null;
        Stopwatch stopwatch = new Stopwatch(timeout.toMillis());
        do {
            try {
                actualElements = this.collection.getElements();
                if (condition.test(actualElements)) {
                    return;
                }
            }
            catch (JavascriptException e) {
                throw e;
            }
            catch (UIAssertionError | IndexOutOfBoundsException | WebDriverException elementNotFound) {
                if (Cleanup.of.isInvalidSelectorError((Throwable)elementNotFound)) {
                    throw Cleanup.of.wrap((Throwable)elementNotFound);
                }
                if (condition.missingElementSatisfiesCondition()) {
                    return;
                }
                lastError = elementNotFound;
            }
            this.sleep(this.driver().config().pollingInterval());
        } while (!stopwatch.isTimeoutReached());
        if (lastError instanceof IndexOutOfBoundsException) {
            throw new ElementNotFound(this.collection.driver(), this.collection.description(), Condition.exist, (Throwable)lastError);
        }
        if (lastError instanceof UIAssertionError) {
            throw (UIAssertionError)((Object)lastError);
        }
        condition.fail(this.collection, actualElements, (Exception)lastError, timeout.toMillis());
    }

    void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection filter(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, condition));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection filterBy(Condition condition) {
        return this.filter(condition);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection exclude(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, Condition.not(condition)));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection excludeWith(Condition condition) {
        return this.exclude(condition);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(Condition condition) {
        return CollectionElementByCondition.wrap(this.collection, condition);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement findBy(Condition condition) {
        return this.find(condition);
    }

    @CheckReturnValue
    @Nonnull
    private List<WebElement> getElements() {
        return this.collection.getElements();
    }

    @CheckReturnValue
    @Nonnull
    public List<String> texts() {
        return ElementsCollection.texts(this.getElements());
    }

    @CheckReturnValue
    @Nonnull
    public static List<String> texts(@Nullable Collection<WebElement> elements) {
        return elements == null ? Collections.emptyList() : elements.stream().map(ElementsCollection::getText).collect(Collectors.toList());
    }

    private static String getText(WebElement element) {
        try {
            return element.getText();
        }
        catch (WebDriverException elementDisappeared) {
            return elementDisappeared.toString();
        }
    }

    @CheckReturnValue
    @Nonnull
    public static String elementsToString(Driver driver, @Nullable Collection<WebElement> elements) {
        if (elements == null) {
            return "[not loaded yet...]";
        }
        if (elements.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("[").append(System.lineSeparator()).append("\t");
        for (WebElement element : elements) {
            if (sb.length() > 4) {
                sb.append(",").append(System.lineSeparator()).append("\t");
            }
            sb.append(describe.fully(driver, element));
        }
        sb.append(System.lineSeparator()).append("]");
        return sb.toString();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public SelenideElement get(int index) {
        return CollectionElement.wrap(this.collection, index);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement first() {
        return this.get(0);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement last() {
        return LastCollectionElement.wrap(this.collection);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection first(int elements) {
        return new ElementsCollection(new HeadOfCollection(this.collection, elements));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection last(int elements) {
        return new ElementsCollection(new TailOfCollection(this.collection, elements));
    }

    @Override
    @CheckReturnValue
    public int size() {
        try {
            return this.getElements().size();
        }
        catch (IndexOutOfBoundsException outOfCollection) {
            return 0;
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Iterator<SelenideElement> iterator() {
        return new SelenideElementIterator(this.fetch());
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ListIterator<SelenideElement> listIterator(int index) {
        return new SelenideElementListIterator(this.fetch(), index);
    }

    private WebElementsCollectionWrapper fetch() {
        List<WebElement> fetchedElements = this.collection.getElements();
        return new WebElementsCollectionWrapper(this.driver(), fetchedElements);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Object[] toArray() {
        List<WebElement> fetchedElements = this.collection.getElements();
        Object[] result = new Object[fetchedElements.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CollectionElement.wrap(this.collection, i);
        }
        return result;
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection snapshot() {
        return new ElementsCollection(new CollectionSnapshot(this.collection));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection as(String alias) {
        this.collection.setAlias(alias);
        return this;
    }

    @Override
    @CheckReturnValue
    public String toString() {
        try {
            return String.format("%s %s", this.collection.description(), ElementsCollection.elementsToString(this.driver(), this.getElements()));
        }
        catch (RuntimeException e) {
            return String.format("%s [%s]", this.collection.description(), Cleanup.of.webdriverExceptionMessage(e));
        }
    }

    @CheckReturnValue
    @Nonnull
    private Driver driver() {
        return this.collection.driver();
    }
}

