/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class CiReportUrl {
    private static final Logger log = LoggerFactory.getLogger(CiReportUrl.class);

    @CheckReturnValue
    @Nullable
    public String getReportsUrl(@Nullable String reportsUrl) {
        if (!this.isEmpty(reportsUrl)) {
            log.debug("Using variable selenide.reportsUrl={}", (Object)reportsUrl);
            return this.resolveUrlSource(reportsUrl, new Object[0]);
        }
        reportsUrl = this.getJenkinsReportsUrl();
        if (!this.isEmpty(reportsUrl)) {
            log.debug("Using Jenkins BUILD_URL: {}", (Object)reportsUrl);
            return reportsUrl;
        }
        reportsUrl = this.getTeamCityUrl();
        if (!this.isEmpty(reportsUrl)) {
            log.debug("Using Teamcity artifacts url: {}", (Object)reportsUrl);
            return reportsUrl;
        }
        log.debug("Variable selenide.reportsUrl not found");
        return reportsUrl;
    }

    @Nullable
    private String getTeamCityUrl() {
        String url = System.getProperty("teamcity.serverUrl");
        String build_type = System.getProperty("teamcity.buildType.id");
        String build_number = System.getProperty("build.number");
        if (this.isEmpty(build_type) || this.isEmpty(build_number) || this.isEmpty(url)) {
            return null;
        }
        return this.resolveUrlSource("%s/repository/download/%s/%s:id/", url, build_type, build_number);
    }

    @Nullable
    private String getJenkinsReportsUrl() {
        String build_url = System.getProperty("BUILD_URL");
        if (!this.isEmpty(build_url)) {
            String workspace = System.getProperty("WORKSPACE", System.getenv("WORKSPACE"));
            String reportRelativePath = "";
            if (!this.isEmpty(workspace)) {
                Path pathAbsoluteReportsFolder = Paths.get("", new String[0]).normalize().toAbsolutePath();
                Path pathAbsoluteWorkSpace = Paths.get(workspace, new String[0]).normalize().toAbsolutePath();
                Path pathRelative = pathAbsoluteWorkSpace.relativize(pathAbsoluteReportsFolder);
                reportRelativePath = pathRelative.toString().replace('\\', '/') + '/';
            }
            return this.resolveUrlSource("%s/artifact/%s", build_url, reportRelativePath);
        }
        return null;
    }

    @Nullable
    private String resolveUrlSource(String base, Object ... format) {
        if (format.length != 0) {
            base = String.format(base, format);
        }
        try {
            return new URI(base).normalize().toURL().toString();
        }
        catch (Exception e) {
            log.error("Variable selenide.reportsUrl is incorrect: {}", (Object)base, (Object)e);
            return null;
        }
    }

    private boolean isEmpty(@Nullable String s) {
        return s == null || s.trim().isEmpty();
    }
}

