/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl.windows;

import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.ExpectedCondition;

@ParametersAreNonnullByDefault
public class FrameByIdOrName
implements ExpectedCondition<WebDriver> {
    private final By locator;

    public FrameByIdOrName(String frame) {
        this.locator = By.cssSelector((String)String.format("frame#%1$s,frame[name=%1$s],iframe#%1$s,iframe[name=%1$s]", frame));
    }

    @Nullable
    public WebDriver apply(WebDriver driver) {
        try {
            return Objects.requireNonNull(driver).switchTo().frame(driver.findElement(this.locator));
        }
        catch (WebDriverException e) {
            return null;
        }
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return "frame to be available: " + this.locator;
    }
}

