/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
abstract class JSStorage {
    private final Driver driver;
    private final String storage;

    JSStorage(Driver driver, String storage) {
        this.driver = driver;
        this.storage = storage;
    }

    @CheckReturnValue
    public boolean containsItem(String key) {
        return Optional.ofNullable(this.getItem(key)).isPresent();
    }

    @CheckReturnValue
    @Nullable
    public String getItem(String key) {
        return (String)this.driver.executeJavaScript(this.js("return %s.getItem(arguments[0])"), key);
    }

    public void setItem(String key, String value) {
        this.driver.executeJavaScript(this.js("%s.setItem(arguments[0], arguments[1])"), key, value);
    }

    public void removeItem(String key) {
        this.driver.executeJavaScript(this.js("%s.removeItem(arguments[0])"), key);
    }

    public void clear() {
        this.driver.executeJavaScript(this.js("%s.clear()"), new Object[0]);
    }

    @CheckReturnValue
    public int size() {
        return Integer.parseInt(this.driver.executeJavaScript(this.js("return %s.length"), new Object[0]).toString());
    }

    @CheckReturnValue
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private String js(String jsCodeTemplate) {
        return String.format(jsCodeTemplate, this.storage);
    }
}

