/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Condition;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class Util {
    Util() {
    }

    @CheckReturnValue
    @Nonnull
    static <T> T firstOf(@Nullable Object[] args) {
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Missing arguments");
        }
        return (T)args[0];
    }

    @CheckReturnValue
    @Nonnull
    static List<Condition> argsToConditions(@Nullable Object[] args) {
        if (args == null) {
            return Collections.emptyList();
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>(args.length);
        for (Object arg : args) {
            if (arg instanceof Condition) {
                conditions.add((Condition)arg);
                continue;
            }
            if (arg instanceof Condition[]) {
                conditions.addAll(Arrays.asList((Condition[])arg));
                continue;
            }
            if (arg instanceof String || arg instanceof Long || arg instanceof Duration) continue;
            throw new IllegalArgumentException("Unknown parameter: " + arg);
        }
        return conditions;
    }
}

