/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import com.codeborne.selenide.impl.Screenshot;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Screenshots {
    public static ScreenShotLaboratory screenshots = ScreenShotLaboratory.getInstance();

    @CheckReturnValue
    public static String saveScreenshotAndPageSource() {
        return screenshots.takeScreenshot(WebDriverRunner.driver()).summary();
    }

    @CheckReturnValue
    @Nonnull
    public static Screenshot takeScreenShot(String className, String methodName) {
        return screenshots.takeScreenShot(WebDriverRunner.driver(), className, methodName);
    }

    @CheckReturnValue
    @Nullable
    @Deprecated
    public static String takeScreenShot(String fileName) {
        return screenshots.takeScreenShot(WebDriverRunner.driver(), fileName);
    }

    @CheckReturnValue
    @Nullable
    public static File takeScreenShotAsFile() {
        return screenshots.takeScreenShotAsFile(WebDriverRunner.driver());
    }

    @CheckReturnValue
    @Nullable
    public static File takeScreenShot(WebElement element) {
        return screenshots.takeScreenshot(WebDriverRunner.driver(), element);
    }

    @CheckReturnValue
    @Nullable
    public static File takeScreenShot(WebElement iframe, WebElement element) {
        return screenshots.takeScreenshot(WebDriverRunner.driver(), iframe, element);
    }

    @CheckReturnValue
    @Nullable
    public static BufferedImage takeScreenShotAsImage(WebElement iframe, WebElement element) {
        return screenshots.takeScreenshotAsImage(WebDriverRunner.driver(), iframe, element);
    }

    @CheckReturnValue
    @Nullable
    public static BufferedImage takeScreenShotAsImage(WebElement element) {
        return screenshots.takeScreenshotAsImage(WebDriverRunner.driver(), element);
    }

    public static void startContext(String className, String methodName) {
        screenshots.startContext(className, methodName);
    }

    @Nonnull
    public static List<File> finishContext() {
        return screenshots.finishContext();
    }

    @CheckReturnValue
    @Nullable
    public static File getLastScreenshot() {
        return screenshots.getLastScreenshot();
    }

    @CheckReturnValue
    @Nonnull
    public static Optional<File> getLastThreadScreenshot() {
        return screenshots.getLastThreadScreenshot();
    }

    @CheckReturnValue
    @Nonnull
    public static Optional<File> getLastContextScreenshot() {
        return screenshots.getLastContextScreenshot();
    }
}

