/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SelenideElementIterator
implements Iterator<SelenideElement> {
    protected final CollectionSource collection;
    protected int index;

    public SelenideElementIterator(CollectionSource collection) {
        this.collection = collection;
    }

    @Override
    @CheckReturnValue
    public boolean hasNext() {
        return this.collection.getElements().size() > this.index;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public SelenideElement next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return CollectionElement.wrap(this.collection, this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from web page");
    }
}

