/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.WebElementSource;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriverException;

@ParametersAreNonnullByDefault
public class Exists
implements Command<Boolean> {
    @Override
    @CheckReturnValue
    @Nonnull
    public Boolean execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        try {
            locator.getWebElement();
            return true;
        }
        catch (ElementNotFound | WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError((Throwable)elementNotFound)) {
                throw Cleanup.of.wrap((Throwable)elementNotFound);
            }
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }
}

