/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public abstract class DownloadsFolder {
    protected final File folder;

    protected DownloadsFolder(File folder) {
        this.folder = folder;
    }

    public File toFile() {
        return this.folder;
    }

    @CheckReturnValue
    @Nonnull
    public List<File> files() {
        File[] files = this.folder.listFiles();
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public abstract void cleanupBeforeDownload();

    public File file(String fileName) {
        return new File(this.folder, fileName).getAbsoluteFile();
    }

    public String toString() {
        return this.folder.getAbsolutePath();
    }
}

