/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsContainer;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.PageObjectException;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.SelenideFieldDecorator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;

@ParametersAreNonnullByDefault
public class SelenidePageFactory {
    @CheckReturnValue
    @Nonnull
    public <PageObjectClass> PageObjectClass page(Driver driver, Class<PageObjectClass> pageObjectClass) {
        try {
            Constructor<PageObjectClass> constructor = pageObjectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return this.page(driver, constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to create new instance of " + pageObjectClass, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public <PageObjectClass, T extends PageObjectClass> PageObjectClass page(Driver driver, T pageObject) {
        Type[] types = pageObject.getClass().getGenericInterfaces();
        this.initElements(new SelenideFieldDecorator(this, driver, (SearchContext)driver.getWebDriver()), pageObject, types);
        return pageObject;
    }

    public void initElements(SelenideFieldDecorator decorator, Object page, Type[] genericTypes) {
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            this.proxyFields(decorator, page, proxyIn, genericTypes);
        }
    }

    private void proxyFields(SelenideFieldDecorator decorator, Object page, Class<?> proxyIn, Type[] genericTypes) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            Object value;
            if (this.isInitialized(page, field) || (value = decorator.decorate(page.getClass().getClassLoader(), field, genericTypes)) == null) continue;
            this.setFieldValue(page, field, value);
        }
    }

    private void setFieldValue(Object page, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(page, value);
        }
        catch (IllegalAccessException e) {
            throw new PageObjectException("Failed to assign field " + field + " to value " + value, e);
        }
    }

    @CheckReturnValue
    private boolean isInitialized(Object page, Field field) {
        try {
            field.setAccessible(true);
            return field.get(page) != null;
        }
        catch (IllegalAccessException e) {
            throw new PageObjectException("Failed to access field " + field + " in " + page, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    ElementsContainer createElementsContainer(Driver driver, SearchContext searchContext, Field field, By selector) {
        try {
            SelenideElement self = ElementFinder.wrap(driver, searchContext, selector, 0);
            return this.initElementsContainer(driver, field, self);
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to create elements container for field " + field.getName(), e);
        }
    }

    @CheckReturnValue
    @Nonnull
    ElementsContainer initElementsContainer(Driver driver, Field field, SelenideElement self) throws ReflectiveOperationException {
        Type[] genericTypes = field.getGenericType() instanceof ParameterizedType ? ((ParameterizedType)field.getGenericType()).getActualTypeArguments() : new Type[]{};
        return this.initElementsContainer(driver, field, self, field.getType(), genericTypes);
    }

    @CheckReturnValue
    @Nonnull
    ElementsContainer initElementsContainer(Driver driver, Field field, SelenideElement self, Class<?> type, Type[] genericTypes) throws ReflectiveOperationException {
        if (Modifier.isInterface(type.getModifiers())) {
            throw new IllegalArgumentException("Cannot initialize field " + field + ": " + type + " is interface");
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("Cannot initialize field " + field + ": " + type + " is abstract");
        }
        Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        ElementsContainer result = (ElementsContainer)constructor.newInstance(new Object[0]);
        this.initElements(new SelenideFieldDecorator(this, driver, (SearchContext)self), result, genericTypes);
        return result;
    }
}

