/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugins {
    private static final Logger logger = LoggerFactory.getLogger(Plugins.class);
    private static final Map<Class<?>, Object> cache = new ConcurrentHashMap();

    public static <T> T inject(Class<T> klass) {
        return (T)cache.computeIfAbsent(klass, Plugins::loadPlugin);
    }

    private static <T> T loadPlugin(Class<T> klass) {
        Iterator<T> loader = ServiceLoader.load(klass).iterator();
        if (!loader.hasNext()) {
            T defaultPlugin = Plugins.getDefaultPlugin(klass);
            logger.debug("Using default implementation of {}: {}", (Object)klass.getName(), (Object)defaultPlugin.getClass().getName());
            return defaultPlugin;
        }
        T implementation = loader.next();
        logger.info("Using implementation of {}: {}", (Object)klass.getName(), (Object)implementation.getClass().getName());
        return implementation;
    }

    private static <T> T getDefaultPlugin(Class<T> klass) {
        String resource = "/META-INF/defaultservices/" + klass.getName();
        URL file = Plugins.class.getResource(resource);
        if (file == null) {
            throw new IllegalStateException("Resource not found in classpath: " + resource);
        }
        String className = Plugins.readFile(file).trim();
        try {
            return (T)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize default plugin " + className + " from " + file, e);
        }
    }

    private static String readFile(URL file) {
        try {
            return IOUtils.toString((URL)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + file, e);
        }
    }
}

