/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.files;

import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.files.FileFilter;
import java.util.regex.Pattern;

class FilenameRegexFilter
implements FileFilter {
    private final Pattern fileNameRegex;

    FilenameRegexFilter(String fileNameRegex) {
        this.fileNameRegex = Pattern.compile(fileNameRegex);
    }

    @Override
    public boolean match(DownloadedFile file) {
        return this.fileNameRegex.matcher(file.getFile().getName()).matches();
    }

    @Override
    public String description() {
        return " with file name matching \"" + this.fileNameRegex + "\"";
    }
}

