/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class HttpHelper {
    private static final Pattern FILENAME_IN_CONTENT_DISPOSITION_HEADER = Pattern.compile(".*filename\\*?=\"?((.+)'')?([^\";?]*)\"?(;charset=(.*))?.*", 2);
    private static final Pattern FILENAME_FORBIDDEN_CHARACTERS = Pattern.compile("[#%&{}\\\\<>*?$!'\":@+`|=]");

    @CheckReturnValue
    @Nonnull
    public Optional<String> getFileNameFromContentDisposition(Map<String, String> headers) {
        return this.getFileNameFromContentDisposition(headers.entrySet());
    }

    @CheckReturnValue
    @Nonnull
    public Optional<String> getFileNameFromContentDisposition(Collection<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> header : headers) {
            Optional<String> fileName = this.getFileNameFromContentDisposition(header.getKey(), header.getValue());
            if (!fileName.isPresent()) continue;
            return fileName;
        }
        return Optional.empty();
    }

    @CheckReturnValue
    @Nonnull
    public Optional<String> getFileNameFromContentDisposition(String headerName, @Nullable String headerValue) {
        if (!"Content-Disposition".equalsIgnoreCase(headerName) || headerValue == null) {
            return Optional.empty();
        }
        Matcher regex = FILENAME_IN_CONTENT_DISPOSITION_HEADER.matcher(headerValue);
        if (!regex.matches()) {
            return Optional.empty();
        }
        String fileName = regex.replaceFirst("$3");
        String encoding = (String)StringUtils.defaultIfEmpty((CharSequence)regex.replaceFirst("$2"), (CharSequence)regex.replaceFirst("$5"));
        return Optional.of(this.decodeHttpHeader(fileName, encoding));
    }

    @CheckReturnValue
    @Nonnull
    private String decodeHttpHeader(String encoded, String encoding) {
        try {
            return URLDecoder.decode(encoded, (String)StringUtils.defaultIfEmpty((CharSequence)encoding, (CharSequence)"UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public String getFileName(String url) {
        return this.normalize(this.trimQuery(FilenameUtils.getName((String)url)));
    }

    @CheckReturnValue
    @Nonnull
    private String trimQuery(String filenameWithQuery) {
        return filenameWithQuery.contains("?") ? StringUtils.left((String)filenameWithQuery, (int)filenameWithQuery.indexOf(63)) : filenameWithQuery;
    }

    @CheckReturnValue
    @Nonnull
    public String normalize(String fileName) {
        if (fileName.contains("/")) {
            throw new IllegalArgumentException("File name cannot contain slash: " + fileName);
        }
        return FILENAME_FORBIDDEN_CHARACTERS.matcher(fileName).replaceAll("_").replace(' ', '+');
    }
}

