/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ex.ListSizeMismatch;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class SizeGreaterThan
extends CollectionCondition {
    protected final int expectedSize;

    public SizeGreaterThan(int expectedSize) {
        this.expectedSize = expectedSize;
    }

    @Override
    public boolean test(List<WebElement> elements) {
        return this.apply(elements.size());
    }

    @Override
    public void fail(WebElementsCollection collection, @Nullable List<WebElement> elements, @Nullable Exception lastError, long timeoutMs) {
        throw new ListSizeMismatch(collection.driver(), ">", this.expectedSize, this.explanation, collection, elements, lastError, timeoutMs);
    }

    @Override
    public boolean applyNull() {
        return this.apply(0);
    }

    public String toString() {
        return String.format("size > %s", this.expectedSize);
    }

    private boolean apply(int size) {
        return size > this.expectedSize;
    }
}

