/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.impl.SelenideLogger;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class PrettyReportCreator
extends TestWatcher {
    private static final Logger log = Logger.getLogger(PrettyReportCreator.class.getName());
    private final List<LogEvent> logEvents = new ArrayList<LogEvent>();
    private final LogEventListener logEventListener = new LogEventListener(){

        @Override
        public void onEvent(LogEvent currentLog) {
            PrettyReportCreator.this.logEvents.add(currentLog);
        }
    };

    protected void starting(Description description) {
        SelenideLogger.addListener(this.logEventListener);
    }

    protected void finished(Description description) {
        StringBuilder sb = new StringBuilder();
        sb.append("Report for ").append(description.getDisplayName()).append('\n');
        String delimiter = '+' + Joiner.on((char)'+').join((Object)this.line(20), (Object)this.line(70), new Object[]{this.line(10), this.line(10)}) + "+\n";
        sb.append(delimiter);
        sb.append(String.format("|%-20s|%-70s|%-10s|%-10s|%n", "Element", "Subject", "Status", "ms."));
        sb.append(delimiter);
        for (LogEvent e : this.logEvents) {
            sb.append(String.format("|%-20s|%-70s|%-10s|%-10s|%n", new Object[]{e.getElement(), e.getSubject(), e.getStatus(), e.getDuration()}));
        }
        sb.append(delimiter);
        log.info(sb.toString());
    }

    private String line(int count) {
        return Joiner.on((String)"").join(Collections.nCopies(count, "-"));
    }
}

