/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverProvider;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.WebDriverContainer;
import java.awt.Toolkit;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionNotFoundException;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverThreadLocalContainerWithTimeouts
implements WebDriverContainer {
    private static final Logger log = Logger.getLogger(WebDriverThreadLocalContainerWithTimeouts.class.getName());
    protected final List<WebDriverEventListener> listeners = new ArrayList<WebDriverEventListener>();
    protected final List<WebDriver> CREATED_WEB_DRIVERS = new CopyOnWriteArrayList<WebDriver>();
    protected final List<ThreadWebdriver> THREAD_WEB_DRIVERS = new CopyOnWriteArrayList<ThreadWebdriver>();
    protected final Map<Long, WebDriver> THREAD_WEB_DRIVER = new ConcurrentHashMap<Long, WebDriver>();
    protected Proxy webProxySettings;
    protected final AtomicBoolean systemShutdownStarted = new AtomicBoolean(false);
    protected final AtomicBoolean cleanupThreadStarted = new AtomicBoolean(false);
    protected Thread unusedWebdriversCleanupThread = new UnusedWebdriversCleanupThread();
    protected WebdriversFinalCleanupThread finalCleanupThread = new WebdriversFinalCleanupThread();

    protected void closeWebdriversCreatedByDeadThreads() {
        for (ThreadWebdriver tw : this.THREAD_WEB_DRIVERS) {
            if (tw.thread.isAlive()) continue;
            log.info("Thread " + tw.thread.getId() + " is dead. Let's close webdriver " + tw.webdriver);
            this.THREAD_WEB_DRIVERS.remove(tw);
            this.closeWebDriver(tw.webdriver);
        }
    }

    protected void closeWebdriversNotBoundToAnyThread() {
        for (WebDriver webdriver : this.CREATED_WEB_DRIVERS) {
            if (this.THREAD_WEB_DRIVER.containsValue(webdriver)) continue;
            log.info("Webdriver is not used by any thread. Let's close it: " + webdriver);
            this.CREATED_WEB_DRIVERS.remove(webdriver);
            this.closeWebDriver(webdriver);
        }
    }

    @Override
    public void addListener(WebDriverEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public WebDriver setWebDriver(WebDriver webDriver) {
        this.THREAD_WEB_DRIVER.put(Thread.currentThread().getId(), webDriver);
        return webDriver;
    }

    @Override
    public void setProxy(Proxy webProxy) {
        this.webProxySettings = webProxy;
    }

    protected boolean isBrowserStillOpen(WebDriver webDriver) {
        try {
            webDriver.getTitle();
            return true;
        }
        catch (UnreachableBrowserException e) {
            log.log(Level.FINE, "Browser is unreachable", e);
            return false;
        }
        catch (NoSuchWindowException e) {
            log.log(Level.FINE, "Browser window is now found", e);
            return false;
        }
        catch (SessionNotFoundException e) {
            log.log(Level.FINE, "Browser session is not found", e);
            return false;
        }
    }

    @Override
    public boolean hasWebDriverStarted() {
        return this.THREAD_WEB_DRIVER.containsKey(Thread.currentThread().getId());
    }

    @Override
    public WebDriver getWebDriver() {
        WebDriver webDriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webDriver != null) {
            return webDriver;
        }
        log.info("No webdriver is bound to current thread: " + Thread.currentThread().getId() + " - let's create new webdriver");
        return this.setWebDriver(this.createDriver());
    }

    @Override
    public WebDriver getAndCheckWebDriver() {
        WebDriver webDriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webDriver != null) {
            if (this.isBrowserStillOpen(webDriver)) {
                return webDriver;
            }
            log.info("Webdriver has been closed meanwhile. Let's re-create it.");
            this.closeWebDriver();
        }
        return this.setWebDriver(this.createDriver());
    }

    @Override
    public void closeWebDriver() {
        this.closeAllWebDriversOf(Thread.currentThread());
    }

    protected void closeAllWebDriversOf(Thread thread) {
        for (ThreadWebdriver tw : this.THREAD_WEB_DRIVERS) {
            if (!tw.thread.equals(thread)) continue;
            log.info("Let's close webdriver created by thread " + tw.thread.getId() + ": " + tw.webdriver);
            this.THREAD_WEB_DRIVERS.remove(tw);
            this.closeWebDriver(tw.webdriver);
        }
    }

    protected void closeWebDriver(WebDriver webdriver) {
        if (webdriver != null && !Configuration.holdBrowserOpen) {
            this.CREATED_WEB_DRIVERS.remove(webdriver);
            for (Map.Entry<Long, WebDriver> entry : this.THREAD_WEB_DRIVER.entrySet()) {
                if (entry.getValue().equals(webdriver)) {
                    this.THREAD_WEB_DRIVER.remove(entry.getKey());
                }
                log.info("Close webdriver: " + entry.getKey() + " -> " + webdriver);
            }
            long start = System.currentTimeMillis();
            Thread t = new Thread(new CloseBrowser(webdriver));
            t.setDaemon(true);
            t.start();
            try {
                t.join(Configuration.closeBrowserTimeoutMs);
            }
            catch (InterruptedException e) {
                log.log(Level.FINE, "Failed to close webdriver in " + Configuration.closeBrowserTimeoutMs + " milliseconds", e);
            }
            long duration = System.currentTimeMillis() - start;
            if (duration >= Configuration.closeBrowserTimeoutMs) {
                log.severe("Failed to close webdriver in " + Configuration.closeBrowserTimeoutMs + " milliseconds");
            } else if (duration > 200L) {
                log.info("Closed webdriver in " + duration + " ms");
            } else {
                log.fine("Closed webdriver in " + duration + " ms");
            }
        }
    }

    @Override
    public void clearBrowserCache() {
        WebDriver webdriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webdriver != null) {
            webdriver.manage().deleteAllCookies();
        }
    }

    @Override
    public String getPageSource() {
        return this.getWebDriver().getPageSource();
    }

    @Override
    public String getCurrentUrl() {
        return this.getWebDriver().getCurrentUrl();
    }

    protected WebDriver createDriver() {
        WebDriver webdriver = this.createWebDriverWithTimeout();
        webdriver = this.maximize(webdriver);
        log.info("Create webdriver in current thread " + Thread.currentThread().getId() + ": " + Configuration.browser + " -> " + webdriver);
        this.markForAutoClose(Thread.currentThread(), this.addListeners(webdriver));
        return webdriver;
    }

    protected WebDriver createWebDriverWithTimeout() {
        for (int i = 0; i < 3; ++i) {
            CreateWebdriver create = new CreateWebdriver();
            Thread t = new Thread(create);
            t.setName(t.getName() + ": create webdriver for " + Thread.currentThread());
            t.setDaemon(true);
            t.start();
            try {
                long start = System.currentTimeMillis();
                while (create.webdriver == null && System.currentTimeMillis() - start <= Configuration.openBrowserTimeoutMs) {
                    Thread.sleep(100L);
                }
                if (create.webdriver == null) continue;
                return create.webdriver;
            }
            catch (InterruptedException e) {
                throw this.runtime(e);
            }
        }
        throw new RuntimeException("Could not create webdriver in " + Configuration.openBrowserTimeoutMs + " ms");
    }

    protected void addShutdownHook(Thread hook) {
        Runtime.getRuntime().addShutdownHook(hook);
    }

    protected WebDriver addListeners(WebDriver webdriver) {
        if (this.listeners.isEmpty()) {
            return webdriver;
        }
        EventFiringWebDriver wrapper = new EventFiringWebDriver(webdriver);
        for (WebDriverEventListener listener : this.listeners) {
            log.info("Add listener to webdriver: " + listener);
            wrapper.register(listener);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markForAutoClose(Thread thread, WebDriver webDriver) {
        this.THREAD_WEB_DRIVERS.add(new ThreadWebdriver(thread, webDriver));
        if (!this.cleanupThreadStarted.get()) {
            WebDriverThreadLocalContainerWithTimeouts webDriverThreadLocalContainerWithTimeouts = this;
            synchronized (webDriverThreadLocalContainerWithTimeouts) {
                if (!this.cleanupThreadStarted.get()) {
                    this.unusedWebdriversCleanupThread.start();
                    this.addShutdownHook(this.finalCleanupThread);
                    this.cleanupThreadStarted.set(true);
                }
            }
        }
    }

    protected WebDriver createChromeDriver() {
        DesiredCapabilities capabilities = this.createCommonCapabilities();
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"test-type"});
        capabilities.setCapability("chromeOptions", (Object)options);
        return new ChromeDriver((Capabilities)capabilities);
    }

    protected WebDriver createFirefoxDriver() {
        DesiredCapabilities capabilities = this.createCommonCapabilities();
        return new FirefoxDriver((Capabilities)capabilities);
    }

    protected WebDriver createHtmlUnitDriver() {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnitWithJs();
        capabilities.merge((Capabilities)this.createCommonCapabilities());
        capabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
        capabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
        if (Configuration.browser.indexOf(58) > -1) {
            String emulatedBrowser = Configuration.browser.replaceFirst("htmlunit:(.*)", "$1");
            capabilities.setVersion(emulatedBrowser);
        }
        return new HtmlUnitDriver((Capabilities)capabilities);
    }

    protected WebDriver createInternetExplorerDriver() {
        DesiredCapabilities capabilities = this.createCommonCapabilities();
        return new InternetExplorerDriver((Capabilities)capabilities);
    }

    protected WebDriver createPhantomJsDriver() {
        return this.createInstanceOf("org.openqa.selenium.phantomjs.PhantomJSDriver");
    }

    protected WebDriver createOperaDriver() {
        return this.createInstanceOf("com.opera.core.systems.OperaDriver");
    }

    protected WebDriver createSafariDriver() {
        return this.createInstanceOf("org.openqa.selenium.safari.SafariDriver");
    }

    protected WebDriver maximize(WebDriver driver) {
        if (Configuration.startMaximized) {
            try {
                if (WebDriverRunner.isChrome()) {
                    this.maximizeChromeBrowser(driver.manage().window());
                } else {
                    driver.manage().window().maximize();
                }
            }
            catch (Exception cannotMaximize) {
                log.warning("Cannot maximize " + Configuration.browser + ": " + cannotMaximize);
            }
        }
        return driver;
    }

    protected void maximizeChromeBrowser(WebDriver.Window window) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenResolution = new Dimension((int)toolkit.getScreenSize().getWidth(), (int)toolkit.getScreenSize().getHeight());
        window.setSize(screenResolution);
        window.setPosition(new Point(0, 0));
    }

    protected WebDriver createInstanceOf(String className) {
        try {
            Class<?> clazz;
            DesiredCapabilities capabilities = this.createCommonCapabilities();
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            capabilities.setCapability("acceptSslCerts", true);
            capabilities.setCapability("handlesAlerts", true);
            if (WebDriverRunner.isPhantomjs()) {
                capabilities.setCapability("phantomjs.cli.args", (Object)new String[]{"--web-security=no", "--ignore-ssl-errors=yes"});
            }
            if (WebDriverProvider.class.isAssignableFrom(clazz = Class.forName(className))) {
                return ((WebDriverProvider)clazz.newInstance()).createDriver(capabilities);
            }
            Constructor<?> constructor = Class.forName(className).getConstructor(Capabilities.class);
            return (WebDriver)constructor.newInstance(capabilities);
        }
        catch (InvocationTargetException e) {
            throw this.runtime(e.getTargetException());
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    protected RuntimeException runtime(Throwable exception) {
        return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
    }

    protected WebDriver createRemoteDriver(String remote, String browser) {
        try {
            DesiredCapabilities capabilities = this.createCommonCapabilities();
            capabilities.setBrowserName(browser);
            return new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }

    protected DesiredCapabilities createCommonCapabilities() {
        DesiredCapabilities browserCapabilities = new DesiredCapabilities();
        if (this.webProxySettings != null) {
            browserCapabilities.setCapability("proxy", (Object)this.webProxySettings);
        }
        return browserCapabilities;
    }

    private static class ThreadWebdriver {
        final Thread thread;
        final WebDriver webdriver;

        private ThreadWebdriver(Thread thread, WebDriver webdriver) {
            this.thread = thread;
            this.webdriver = webdriver;
        }
    }

    protected class UnusedWebdriversCleanupThread
    extends Thread {
        public UnusedWebdriversCleanupThread() {
            this.setDaemon(true);
            this.setName("Webdrivers killer thread");
        }

        @Override
        public void run() {
            while (!WebDriverThreadLocalContainerWithTimeouts.this.systemShutdownStarted.get()) {
                WebDriverThreadLocalContainerWithTimeouts.this.closeWebdriversCreatedByDeadThreads();
                WebDriverThreadLocalContainerWithTimeouts.this.closeWebdriversNotBoundToAnyThread();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    protected class WebdriversFinalCleanupThread
    extends Thread {
        protected WebdriversFinalCleanupThread() {
        }

        @Override
        public void run() {
            WebDriverThreadLocalContainerWithTimeouts.this.systemShutdownStarted.set(true);
            log.info("System shutdown. Let's close " + WebDriverThreadLocalContainerWithTimeouts.this.CREATED_WEB_DRIVERS.size() + " webdrivers.");
            WebDriverThreadLocalContainerWithTimeouts.this.unusedWebdriversCleanupThread.interrupt();
            while (!WebDriverThreadLocalContainerWithTimeouts.this.CREATED_WEB_DRIVERS.isEmpty()) {
                try {
                    log.info("System shutdown. Waiting for " + WebDriverThreadLocalContainerWithTimeouts.this.CREATED_WEB_DRIVERS.size() + " webdrivers still open.");
                    WebdriversFinalCleanupThread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            log.info("System shutdown. Closed all webdrivers.");
        }
    }

    private class CreateWebdriver
    implements Runnable {
        WebDriver webdriver = null;

        private CreateWebdriver() {
        }

        @Override
        public void run() {
            try {
                if (WebDriverThreadLocalContainerWithTimeouts.this.systemShutdownStarted.get()) {
                    log.warning("System shutdown started. Cancel webdriver creation.");
                    return;
                }
                log.config("Configuration.browser=" + Configuration.browser);
                log.config("Configuration.remote=" + Configuration.remote);
                log.config("Configuration.startMaximized=" + Configuration.startMaximized);
                this.webdriver = Configuration.remote != null ? WebDriverThreadLocalContainerWithTimeouts.this.createRemoteDriver(Configuration.remote, Configuration.browser) : ("chrome".equalsIgnoreCase(Configuration.browser) ? WebDriverThreadLocalContainerWithTimeouts.this.createChromeDriver() : (WebDriverRunner.isFirefox() ? WebDriverThreadLocalContainerWithTimeouts.this.createFirefoxDriver() : (WebDriverRunner.isHtmlUnit() ? WebDriverThreadLocalContainerWithTimeouts.this.createHtmlUnitDriver() : (WebDriverRunner.isIE() ? WebDriverThreadLocalContainerWithTimeouts.this.createInternetExplorerDriver() : (WebDriverRunner.isPhantomjs() ? WebDriverThreadLocalContainerWithTimeouts.this.createPhantomJsDriver() : (WebDriverRunner.isOpera() ? WebDriverThreadLocalContainerWithTimeouts.this.createOperaDriver() : (WebDriverRunner.isSafari() ? WebDriverThreadLocalContainerWithTimeouts.this.createSafariDriver() : WebDriverThreadLocalContainerWithTimeouts.this.createInstanceOf(Configuration.browser))))))));
                Thread.sleep(200L);
                WebDriverThreadLocalContainerWithTimeouts.this.addShutdownHook(new Thread(new CloseBrowser(this.webdriver)));
                WebDriverThreadLocalContainerWithTimeouts.this.CREATED_WEB_DRIVERS.add(this.webdriver);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to create webdriver", e);
            }
        }
    }

    private class CloseBrowser
    implements Runnable {
        private final WebDriver webdriver;

        private CloseBrowser(WebDriver webdriver) {
            this.webdriver = webdriver;
        }

        @Override
        public void run() {
            log.info("Trying to close the browser " + this.webdriver + " ...");
            try {
                this.webdriver.close();
            }
            catch (UnreachableBrowserException e) {
                log.log(Level.FINE, "Cannot close, browser is unreachable", e);
            }
            try {
                this.webdriver.quit();
            }
            catch (UnreachableBrowserException e) {
                log.log(Level.FINE, "Cannot quit, browser is unreachable", e);
            }
            catch (WebDriverException cannotCloseBrowser) {
                log.severe("Cannot close browser normally: " + Cleanup.of.webdriverExceptionMessage(cannotCloseBrowser));
            }
            finally {
                this.killBrowser(this.webdriver);
                WebDriverThreadLocalContainerWithTimeouts.this.CREATED_WEB_DRIVERS.remove(this.webdriver);
            }
        }

        protected void killBrowser(WebDriver webdriver) {
            if (webdriver instanceof Killable) {
                try {
                    ((Killable)webdriver).kill();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to kill browser " + webdriver + ':', e);
                }
            }
        }
    }
}

