/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.SelenideLog;
import com.codeborne.selenide.impl.SelenideLogger;
import com.codeborne.selenide.logevents.LogEvent;
import java.net.URL;
import java.util.logging.Logger;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class Navigator {
    private static final Logger log = Logger.getLogger(Navigator.class.getName());

    public void open(String relativeOrAbsoluteUrl) {
        if (relativeOrAbsoluteUrl.startsWith("http:") || relativeOrAbsoluteUrl.startsWith("https:") || this.isLocalFile(relativeOrAbsoluteUrl)) {
            this.navigateToAbsoluteUrl(relativeOrAbsoluteUrl);
        } else {
            this.navigateToAbsoluteUrl(this.absoluteUrl(relativeOrAbsoluteUrl));
        }
    }

    public void open(URL url) {
        this.navigateToAbsoluteUrl(url.toExternalForm());
    }

    protected String absoluteUrl(String relativeUrl) {
        return Configuration.baseUrl + relativeUrl;
    }

    protected void navigateToAbsoluteUrl(String url) {
        if (WebDriverRunner.isIE() && !this.isLocalFile(url)) {
            url = this.makeUniqueUrlToAvoidIECaching(url, System.nanoTime());
        }
        SelenideLog log = SelenideLogger.beginStep("open", url);
        try {
            WebDriver webdriver = WebDriverRunner.getAndCheckWebDriver();
            webdriver.navigate().to(url);
            this.collectJavascriptErrors((JavascriptExecutor)webdriver);
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASSED);
        }
        catch (WebDriverException e) {
            SelenideLogger.commitStep(log, e);
            e.addInfo("selenide.url", url);
            e.addInfo("selenide.baseUrl", Configuration.baseUrl);
            throw e;
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
        catch (Error e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    protected void collectJavascriptErrors(JavascriptExecutor webdriver) {
        try {
            webdriver.executeScript("window._selenide_jsErrors = [];\nif (!window.onerror) {\n  window.onerror = function (errorMessage, url, lineNumber) {\n    var message = errorMessage + ' at ' + url + ':' + lineNumber;\n    window._selenide_jsErrors.push(message);\n    return false;\n  };\n}\n", new Object[0]);
        }
        catch (UnsupportedOperationException cannotExecuteJsAgainstPlainTextPage) {
            log.warning(cannotExecuteJsAgainstPlainTextPage.toString());
        }
        catch (WebDriverException cannotExecuteJs) {
            log.severe(cannotExecuteJs.toString());
        }
    }

    protected String makeUniqueUrlToAvoidIECaching(String url, long unique) {
        if (url.contains("timestamp=")) {
            return url.replaceFirst("(.*)(timestamp=)(.*)([&#].*)", "$1$2" + unique + "$4").replaceFirst("(.*)(timestamp=)(.*)$", "$1$2" + unique);
        }
        return url.contains("?") ? url + "&timestamp=" + unique : url + "?timestamp=" + unique;
    }

    protected boolean isLocalFile(String url) {
        return url.startsWith("file:");
    }

    public void back() {
        WebDriverRunner.getWebDriver().navigate().back();
    }

    public void forward() {
        WebDriverRunner.getWebDriver().navigate().forward();
    }
}

