/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ElementShould;
import com.codeborne.selenide.ex.ElementShouldNot;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.FileDownloader;
import com.codeborne.selenide.impl.SelenideLog;
import com.codeborne.selenide.impl.SelenideLogger;
import com.codeborne.selenide.impl.WaitingSelenideElement;
import com.codeborne.selenide.impl.WebElementProxy;
import com.codeborne.selenide.logevents.LogEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

abstract class AbstractSelenideElement
implements InvocationHandler {
    private static final Set<String> methodsToSkipLogging = new HashSet<String>(Arrays.asList("toWebElement", "toString"));
    private static final Set<String> methodsForSoftAssertion = new HashSet<String>(Arrays.asList("should", "shouldBe", "shouldHave", "shouldNot", "shouldNotHave", "shouldNotBe", "waitUntil", "waitWhile"));

    AbstractSelenideElement() {
    }

    abstract WebElement getDelegate();

    abstract WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException;

    abstract String getSearchCriteria();

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
        if (methodsToSkipLogging.contains(method.getName())) {
            return this.dispatchSelenideMethod(proxy, method, args);
        }
        SelenideLog log = SelenideLogger.beginStep(this.getSearchCriteria(), method.getName(), args);
        try {
            Object result = this.dispatchAndRetry(proxy, method, args);
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASSED);
            return result;
        }
        catch (Error error) {
            SelenideLogger.commitStep(log, error);
            if (Configuration.assertionMode == Configuration.AssertionMode.SOFT && methodsForSoftAssertion.contains(method.getName())) {
                return proxy;
            }
            throw UIAssertionError.wrap(error);
        }
        catch (RuntimeException error) {
            SelenideLogger.commitStep(log, error);
            throw error;
        }
    }

    protected Object dispatchAndRetry(Object proxy, Method method, Object[] args) throws Throwable {
        long timeoutMs = this.getTimeoutMs(method, args);
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                return method.getDeclaringClass() == SelenideElement.class ? this.dispatchSelenideMethod(proxy, method, args) : AbstractSelenideElement.delegateSeleniumMethod(this.getDelegate(), method, args);
            }
            catch (Throwable e) {
                if (Cleanup.of.isInvalidSelectorError(e)) {
                    throw Cleanup.of.wrap(e);
                }
                Throwable lastError = e;
                Selenide.sleep(Configuration.pollingInterval);
                if (System.currentTimeMillis() - startTime <= timeoutMs) continue;
                if (lastError instanceof UIAssertionError) {
                    UIAssertionError uiError = (UIAssertionError)((Object)lastError);
                    uiError.timeoutMs = timeoutMs;
                    throw uiError;
                }
                if (lastError instanceof WebDriverException) {
                    ElementNotFound uiError = this.createElementNotFoundError(Condition.exist, lastError);
                    uiError.timeoutMs = timeoutMs;
                    throw uiError;
                }
                throw lastError;
            }
            break;
        }
    }

    private long getTimeoutMs(Method method, Object[] args) {
        return "waitUntil".equals(method.getName()) || "waitWhile".equals(method.getName()) ? (Long)args[args.length - 1] : Configuration.timeout;
    }

    protected Object dispatchSelenideMethod(Object proxy, Method method, Object[] args) throws Throwable {
        if ("setValue".equals(method.getName())) {
            this.setValue((String)args[0]);
            return proxy;
        }
        if ("val".equals(method.getName())) {
            if (args == null || args.length == 0) {
                return this.getValue();
            }
            this.setValue((String)args[0]);
            return proxy;
        }
        if ("attr".equals(method.getName())) {
            return this.getDelegate().getAttribute((String)args[0]);
        }
        if ("name".equals(method.getName())) {
            return this.getDelegate().getAttribute("name");
        }
        if ("data".equals(method.getName())) {
            return this.getDelegate().getAttribute("data-" + args[0]);
        }
        if ("append".equals(method.getName())) {
            this.append((String)args[0]);
            return proxy;
        }
        if ("pressEnter".equals(method.getName())) {
            this.findAndAssertElementIsVisible().sendKeys(new CharSequence[]{Keys.ENTER});
            return proxy;
        }
        if ("pressTab".equals(method.getName())) {
            this.findAndAssertElementIsVisible().sendKeys(new CharSequence[]{Keys.TAB});
            return proxy;
        }
        if ("followLink".equals(method.getName())) {
            this.followLink();
            return null;
        }
        if ("text".equals(method.getName()) || "getText".equals(method.getName())) {
            return this.getText();
        }
        if ("innerText".equals(method.getName())) {
            return this.getInnerText();
        }
        if ("innerHtml".equals(method.getName())) {
            return this.getInnerHtml();
        }
        if ("should".equals(method.getName())) {
            return this.invokeShould(proxy, "", args);
        }
        if ("waitUntil".equals(method.getName())) {
            return this.invokeShould(proxy, "be ", args);
        }
        if ("shouldHave".equals(method.getName())) {
            return this.invokeShould(proxy, "have ", args);
        }
        if ("shouldBe".equals(method.getName())) {
            return this.invokeShould(proxy, "be ", args);
        }
        if ("shouldNot".equals(method.getName())) {
            return this.invokeShouldNot(proxy, "", args);
        }
        if ("waitWhile".equals(method.getName())) {
            return this.invokeShouldNot(proxy, "be ", args);
        }
        if ("shouldNotHave".equals(method.getName())) {
            return this.invokeShouldNot(proxy, "have ", args);
        }
        if ("shouldNotBe".equals(method.getName())) {
            return this.invokeShouldNot(proxy, "be ", args);
        }
        if ("parent".equals(method.getName())) {
            return this.parent((SelenideElement)proxy);
        }
        if ("closest".equals(method.getName())) {
            return this.closest((SelenideElement)proxy, (String)args[0]);
        }
        if ("find".equals(method.getName()) || "$".equals(method.getName())) {
            return args.length == 1 ? this.find((SelenideElement)proxy, args[0], 0) : this.find((SelenideElement)proxy, args[0], (Integer)args[1]);
        }
        if ("findAll".equals(method.getName()) || "$$".equals(method.getName())) {
            SelenideElement parent = (SelenideElement)proxy;
            return new ElementsCollection(new BySelectorCollection((SearchContext)parent, this.getSelector(args[0])));
        }
        if ("toString".equals(method.getName())) {
            return this.describe();
        }
        if ("exists".equals(method.getName())) {
            return this.exists();
        }
        if ("isDisplayed".equals(method.getName())) {
            return this.isDisplayed();
        }
        if ("is".equals(method.getName()) || "has".equals(method.getName())) {
            return this.matches((Condition)args[0]);
        }
        if ("setSelected".equals(method.getName())) {
            this.setSelected((Boolean)args[0]);
            return proxy;
        }
        if ("uploadFile".equals(method.getName())) {
            return this.uploadFile((SelenideElement)proxy, (File[])args[0]);
        }
        if ("uploadFromClasspath".equals(method.getName())) {
            return this.uploadFromClasspath((SelenideElement)proxy, (String[])args[0]);
        }
        if ("selectOption".equals(method.getName())) {
            this.selectOptionByText((String)args[0]);
            return null;
        }
        if ("selectOptionByValue".equals(method.getName())) {
            this.selectOptionByValue((String)args[0]);
            return null;
        }
        if ("getSelectedOption".equals(method.getName())) {
            return this.getSelectedOption(this.getDelegate());
        }
        if ("getSelectedValue".equals(method.getName())) {
            return this.getSelectedValue(this.getDelegate());
        }
        if ("getSelectedText".equals(method.getName())) {
            return this.getSelectedText(this.getDelegate());
        }
        if ("toWebElement".equals(method.getName())) {
            return this.getActualDelegate();
        }
        if ("scrollTo".equals(method.getName())) {
            this.scrollTo();
            return proxy;
        }
        if ("download".equals(method.getName())) {
            return this.download();
        }
        if ("click".equals(method.getName())) {
            this.click();
            return null;
        }
        if ("contextClick".equals(method.getName())) {
            this.contextClick();
            return proxy;
        }
        if ("doubleClick".equals(method.getName())) {
            this.doubleClick();
            return proxy;
        }
        if ("hover".equals(method.getName())) {
            this.hover();
            return proxy;
        }
        if ("dragAndDropTo".equals(method.getName())) {
            this.dragAndDropTo((String)args[0]);
            return proxy;
        }
        if ("getWrappedElement".equals(method.getName())) {
            return this.getActualDelegate();
        }
        if ("isImage".equals(method.getName())) {
            return this.isImage();
        }
        if ("screenshot".equals(method.getName())) {
            return this.screenshot();
        }
        throw new IllegalArgumentException("Unknown Selenide method: " + method.getName());
    }

    protected Object invokeShould(Object proxy, String prefix, Object[] args) {
        String message = null;
        if (args[0] instanceof String) {
            message = (String)args[0];
        }
        return this.should(proxy, prefix, message, this.argsToConditions(args));
    }

    private List<Condition> argsToConditions(Object[] args) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(args.length);
        for (Object arg : args) {
            if (arg instanceof Condition) {
                conditions.add((Condition)arg);
                continue;
            }
            if (arg instanceof Condition[]) {
                conditions.addAll(Arrays.asList((Condition[])arg));
                continue;
            }
            if (arg instanceof String || arg instanceof Long) continue;
            throw new IllegalArgumentException("Unknown parameter: " + arg);
        }
        return conditions;
    }

    protected Object invokeShouldNot(Object proxy, String prefix, Object[] args) {
        if (args[0] instanceof String) {
            return this.shouldNot(proxy, prefix, (String)args[0], this.argsToConditions(args));
        }
        return this.shouldNot(proxy, prefix, this.argsToConditions(args));
    }

    protected Boolean isImage() {
        WebElement img = this.getActualDelegate();
        if (!"img".equalsIgnoreCase(img.getTagName())) {
            throw new IllegalArgumentException("Method isImage() is only applicable for img elements");
        }
        return (Boolean)Selenide.executeJavaScript("return arguments[0].complete && typeof arguments[0].naturalWidth != 'undefined' && arguments[0].naturalWidth > 0", img);
    }

    protected File screenshot() {
        return Screenshots.takeScreenShot(this.getDelegate());
    }

    protected boolean matches(Condition condition) {
        WebElement element = this.getElementOrNull();
        if (element != null) {
            return condition.apply(element);
        }
        return condition.applyNull();
    }

    protected void setSelected(boolean selected) {
        WebElement element = this.getDelegate();
        if (element.isSelected() ^ selected) {
            this.click(element);
        }
    }

    protected String getText() {
        WebElement element = this.getDelegate();
        return "select".equalsIgnoreCase(element.getTagName()) ? this.getSelectedText(element) : element.getText();
    }

    protected String getInnerText() {
        WebElement element = this.getDelegate();
        if (WebDriverRunner.isHtmlUnit()) {
            return (String)Selenide.executeJavaScript("return arguments[0].innerText", element);
        }
        if (WebDriverRunner.isIE()) {
            return element.getAttribute("innerText");
        }
        return element.getAttribute("textContent");
    }

    protected String getInnerHtml() {
        WebElement element = this.getDelegate();
        if (WebDriverRunner.isHtmlUnit()) {
            return (String)Selenide.executeJavaScript("return arguments[0].innerHTML", element);
        }
        return element.getAttribute("innerHTML");
    }

    protected void click() {
        this.click(this.findAndAssertElementIsVisible());
    }

    protected void click(WebElement element) {
        if (Configuration.clickViaJs) {
            Selenide.executeJavaScript("arguments[0].click()", element);
        } else {
            element.click();
        }
    }

    protected WebElement findAndAssertElementIsVisible() {
        return this.checkCondition("be ", null, Condition.visible, false);
    }

    protected void contextClick() {
        Selenide.actions().contextClick(this.findAndAssertElementIsVisible()).perform();
    }

    protected void doubleClick() {
        Selenide.actions().doubleClick(this.findAndAssertElementIsVisible()).perform();
    }

    protected void hover() {
        Selenide.actions().moveToElement(this.getDelegate()).perform();
    }

    protected void dragAndDropTo(String targetCssSelector) {
        SelenideElement target = Selenide.$(targetCssSelector).shouldBe(Condition.visible);
        Selenide.actions().dragAndDrop(this.getDelegate(), (WebElement)target).perform();
    }

    protected void followLink() {
        WebElement link = this.getDelegate();
        String href = link.getAttribute("href");
        this.click(link);
        if (href != null) {
            Selenide.open(href);
        }
    }

    protected void setValue(String text) {
        WebElement element = this.findAndAssertElementIsVisible();
        if ("select".equalsIgnoreCase(element.getTagName())) {
            this.selectOptionByValue(text);
        } else if (text == null || text.isEmpty()) {
            element.clear();
        } else if (Configuration.fastSetValue) {
            Selenide.executeJavaScript("arguments[0].value = arguments[1]", element, text);
            this.fireEvent(element, "focus", "keydown", "keypress", "input", "keyup", "change");
        } else {
            element.clear();
            element.sendKeys(new CharSequence[]{text});
            this.fireChangeEvent(element);
        }
    }

    protected void fireChangeEvent(WebElement element) {
        this.fireEvent(element, "change");
    }

    protected String getValue() {
        return this.getDelegate().getAttribute("value");
    }

    protected void append(String text) {
        WebElement element = this.getDelegate();
        element.sendKeys(new CharSequence[]{text});
        this.fireChangeEvent(element);
    }

    protected void fireEvent(WebElement element, String ... event) {
        try {
            String jsCodeToTriggerEvent = "var webElement = arguments[0];\nvar eventNames = arguments[1];\nfor (var i = 0; i < eventNames.length; i++) {  if (document.createEventObject) {\n    var evt = document.createEventObject();\n    webElement.fireEvent('on' + eventNames[i], evt);\n  }\n  else {\n    var evt = document.createEvent('HTMLEvents');\n     evt.initEvent(eventNames[i], true, true );\n     webElement.dispatchEvent(evt);\n  }\n}";
            Selenide.executeJavaScript("var webElement = arguments[0];\nvar eventNames = arguments[1];\nfor (var i = 0; i < eventNames.length; i++) {  if (document.createEventObject) {\n    var evt = document.createEventObject();\n    webElement.fireEvent('on' + eventNames[i], evt);\n  }\n  else {\n    var evt = document.createEvent('HTMLEvents');\n     evt.initEvent(eventNames[i], true, true );\n     webElement.dispatchEvent(evt);\n  }\n}", element, event);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            // empty catch block
        }
    }

    protected Object should(Object proxy, String prefix, String message, List<Condition> conditions) {
        for (Condition condition : conditions) {
            this.checkCondition(prefix, message, condition, false);
        }
        return proxy;
    }

    protected WebElement checkCondition(String prefix, String message, Condition condition, boolean invert) {
        Condition check = invert ? Condition.not(condition) : condition;
        Throwable lastError = null;
        WebElement element = null;
        try {
            element = this.getActualDelegate();
            if (element != null && check.apply(element)) {
                return element;
            }
        }
        catch (WebDriverException elementNotFound) {
            lastError = elementNotFound;
        }
        catch (IndexOutOfBoundsException e) {
            lastError = e;
        }
        catch (RuntimeException e) {
            throw Cleanup.of.wrap(e);
        }
        if (Cleanup.of.isInvalidSelectorError(lastError)) {
            throw Cleanup.of.wrap(lastError);
        }
        if (element == null) {
            if (!check.applyNull()) {
                throw this.createElementNotFoundError(check, lastError);
            }
        } else {
            if (invert) {
                throw new ElementShouldNot(this.getSearchCriteria(), prefix, message, condition, element, lastError);
            }
            throw new ElementShould(this.getSearchCriteria(), prefix, message, condition, element, lastError);
        }
        return null;
    }

    protected Object shouldNot(Object proxy, String prefix, List<Condition> conditions) {
        return this.shouldNot(proxy, prefix, null, conditions);
    }

    protected Object shouldNot(Object proxy, String prefix, String message, List<Condition> conditions) {
        for (Condition condition : conditions) {
            this.checkCondition(prefix, message, condition, true);
        }
        return proxy;
    }

    protected File uploadFromClasspath(SelenideElement inputField, String ... fileName) throws URISyntaxException, IOException {
        File[] files = new File[fileName.length];
        for (int i = 0; i < fileName.length; ++i) {
            files[i] = this.findFileInClasspath(fileName[i]);
        }
        return this.uploadFile(inputField, files);
    }

    protected File findFileInClasspath(String name) throws URISyntaxException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("File not found in classpath: " + name);
        }
        return new File(resource.toURI());
    }

    protected File uploadFile(SelenideElement inputField, File ... file) throws IOException {
        if (file.length == 0) {
            throw new IllegalArgumentException("No files to upload");
        }
        File uploadedFile = this.uploadFile((WebElement)inputField, file[0]);
        if (file.length > 1) {
            SelenideElement form = inputField.closest("form");
            for (int i = 1; i < file.length; ++i) {
                this.uploadFile(this.cloneInputField(form, inputField), file[i]);
            }
        }
        return uploadedFile;
    }

    protected WebElement cloneInputField(SelenideElement form, SelenideElement inputField) {
        return (WebElement)Selenide.executeJavaScript("var fileInput = document.createElement('input');fileInput.setAttribute('type', arguments[1].getAttribute('type'));fileInput.setAttribute('name', arguments[1].getAttribute('name'));fileInput.style.width = '1px';fileInput.style.height = '1px';arguments[0].appendChild(fileInput);return fileInput;", form, inputField);
    }

    protected File uploadFile(WebElement inputField, File file) throws IOException {
        if (!"input".equalsIgnoreCase(inputField.getTagName())) {
            throw new IllegalArgumentException("Cannot upload file because " + Describe.describe(inputField) + " is not an INPUT");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + file.getAbsolutePath());
        }
        String canonicalPath = file.getCanonicalPath();
        inputField.sendKeys(new CharSequence[]{canonicalPath});
        return new File(canonicalPath);
    }

    protected void selectOptionByText(String optionText) {
        WebElement selectField = this.getDelegate();
        new Select(selectField).selectByVisibleText(optionText);
    }

    protected void selectOptionByValue(String optionValue) {
        WebElement selectField = this.getDelegate();
        this.selectOptionByValue(selectField, optionValue);
    }

    protected void selectOptionByValue(WebElement selectField, String optionValue) {
        new Select(selectField).selectByValue(optionValue);
    }

    protected String getSelectedValue(WebElement selectElement) {
        SelenideElement option = this.getSelectedOption(selectElement);
        return option == null ? null : option.getAttribute("value");
    }

    protected String getSelectedText(WebElement selectElement) {
        SelenideElement option = this.getSelectedOption(selectElement);
        return option == null ? null : option.getText();
    }

    protected SelenideElement getSelectedOption(WebElement selectElement) {
        return WebElementProxy.wrap(new Select(selectElement).getFirstSelectedOption());
    }

    protected boolean exists() {
        try {
            return this.getActualDelegate() != null;
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap(elementNotFound);
            }
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }

    protected boolean isDisplayed() {
        try {
            WebElement element = this.getActualDelegate();
            return element != null && element.isDisplayed();
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap(elementNotFound);
            }
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }

    protected String describe() {
        try {
            return Describe.describe(this.getActualDelegate());
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage(elementDoesNotExist);
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return invalidElementIndex.toString();
        }
    }

    static Object delegateSeleniumMethod(WebElement delegate, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        return new ElementNotFound(this.getSearchCriteria(), condition, lastError);
    }

    protected boolean exists(WebElement element) {
        try {
            if (element == null) {
                return false;
            }
            element.isSelected();
            return true;
        }
        catch (WebDriverException elementNotFound) {
            return false;
        }
        catch (IndexOutOfBoundsException elementNotFound) {
            return false;
        }
    }

    protected WebElement getElementOrNull() {
        try {
            return this.getActualDelegate();
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap(elementNotFound);
            }
            return null;
        }
        catch (IndexOutOfBoundsException ignore) {
            return null;
        }
        catch (RuntimeException e) {
            throw Cleanup.of.wrap(e);
        }
    }

    protected SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return WaitingSelenideElement.wrap((SearchContext)proxy, this.getSelector(arg), index);
    }

    protected By getSelector(Object arg) {
        return arg instanceof By ? (By)arg : By.cssSelector((String)((String)arg));
    }

    protected SelenideElement parent(SelenideElement me) {
        return this.find(me, By.xpath((String)".."), 0);
    }

    protected SelenideElement closest(SelenideElement me, String tagOrClass) {
        return tagOrClass.startsWith(".") ? this.find(me, By.xpath((String)("ancestor::*[contains(concat(' ', normalize-space(@class), ' '), ' " + tagOrClass.substring(1) + " ')][1]")), 0) : this.find(me, By.xpath((String)("ancestor::" + tagOrClass + "[1]")), 0);
    }

    protected void scrollTo() {
        Point location = this.getDelegate().getLocation();
        Selenide.executeJavaScript("window.scrollTo(" + location.getX() + ", " + location.getY() + ')', new Object[0]);
    }

    protected File download() throws IOException, URISyntaxException {
        return FileDownloader.instance.download(this.getDelegate());
    }
}

