/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.ex.ErrorMessages;
import com.codeborne.selenide.impl.Cleanup;
import java.util.List;

public class UIAssertionError
extends AssertionError {
    private String screenshot;
    protected List<String> jsErrors;
    public long timeoutMs;

    public UIAssertionError(Throwable cause) {
        this(cause.getClass().getSimpleName() + ": " + cause.getMessage(), cause);
    }

    protected UIAssertionError(String message) {
        super((Object)message);
    }

    protected UIAssertionError(String message, Throwable cause) {
        super(message, cause);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getLocalizedMessage() + this.uiDetails();
    }

    protected String uiDetails() {
        return ErrorMessages.screenshot(this.screenshot) + ErrorMessages.jsErrors(this.jsErrors) + ErrorMessages.timeout(this.timeoutMs) + ErrorMessages.causedBy(this.getCause());
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public List<String> getJsErrors() {
        return this.jsErrors;
    }

    private void collectCurrentWebdriverData() {
        this.screenshot = ErrorMessages.formatScreenShotPath();
        this.jsErrors = Selenide.getJavascriptErrors();
    }

    public static Error wrap(Error error) {
        if (Cleanup.of.isInvalidSelectorError(error)) {
            return error;
        }
        UIAssertionError uiError = error instanceof UIAssertionError ? (UIAssertionError)((Object)error) : new UIAssertionError(error);
        uiError.collectCurrentWebdriverData();
        return uiError;
    }
}

