/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.pdftest.matchers;

import com.codeborne.pdftest.PDF;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

abstract class PDFMatcher
extends TypeSafeMatcher<PDF>
implements SelfDescribing {
    PDFMatcher() {
    }

    protected String reduceSpaces(String text) {
        return text.replaceAll("[\\s\\n\\r\u00a0]+", " ").trim();
    }

    protected void buildErrorMessage(Description description, String text, String[] texts) {
        if (texts.length > 0) {
            List reducedStrings = Arrays.stream(texts).map(this::reduceSpaces).collect(Collectors.toList());
            reducedStrings.add(0, this.reduceSpaces(text));
            description.appendValueList("", ", ", "", reducedStrings);
        } else {
            description.appendValue((Object)this.reduceSpaces(text));
        }
    }
}

