/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.data;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.data.ExecutionData;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.data.IExecutionDataVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ExecutionDataStore
implements IExecutionDataVisitor {
    private final Map<Long, ExecutionData> entries = new HashMap<Long, ExecutionData>();
    private final Set<String> names = new HashSet<String>();

    public void put(ExecutionData data2) throws IllegalStateException {
        Long id = data2.getId();
        ExecutionData entry = this.entries.get(id);
        if (entry == null) {
            this.entries.put(id, data2);
            this.names.add(data2.getName());
        } else {
            entry.merge(data2);
        }
    }

    public void subtract(ExecutionData data2) throws IllegalStateException {
        Long id = data2.getId();
        ExecutionData entry = this.entries.get(id);
        if (entry != null) {
            entry.merge(data2, false);
        }
    }

    public void subtract(ExecutionDataStore store) {
        for (ExecutionData data2 : store.getContents()) {
            this.subtract(data2);
        }
    }

    public ExecutionData get(long id) {
        return this.entries.get(id);
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public ExecutionData get(Long id, String name, int probecount) {
        ExecutionData entry = this.entries.get(id);
        if (entry == null) {
            entry = new ExecutionData((long)id, name, probecount);
            this.entries.put(id, entry);
            this.names.add(name);
        } else {
            entry.assertCompatibility(id, name, probecount);
        }
        return entry;
    }

    public void reset() {
        for (ExecutionData executionData : this.entries.values()) {
            executionData.reset();
        }
    }

    public Collection<ExecutionData> getContents() {
        return new ArrayList<ExecutionData>(this.entries.values());
    }

    public void accept(IExecutionDataVisitor visitor2) {
        for (ExecutionData data2 : this.getContents()) {
            visitor2.visitClassExecution(data2);
        }
    }

    @Override
    public void visitClassExecution(ExecutionData data2) {
        this.put(data2);
    }
}

