/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator;

import com.code_intelligence.jazzer.mutation.annotation.AppliesTo;
import com.code_intelligence.jazzer.mutation.api.ChainedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.collection.CollectionMutators;
import com.code_intelligence.jazzer.mutation.mutator.lang.LangMutators;
import com.code_intelligence.jazzer.mutation.mutator.libfuzzer.LibFuzzerMutators;
import com.code_intelligence.jazzer.mutation.mutator.proto.ProtoMutators;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class Mutators {
    private Mutators() {
    }

    public static MutatorFactory newFactory() {
        return new ChainedMutatorFactory(LangMutators.newFactory(), CollectionMutators.newFactory(), ProtoMutators.newFactory(), LibFuzzerMutators.newFactory());
    }

    public static void validateAnnotationUsage(AnnotatedType type2) {
        TypeSupport.visitAnnotatedType(type2, (clazz, annotations2) -> {
            block0: for (Annotation annotation : annotations2) {
                AppliesTo appliesTo = annotation.annotationType().getAnnotation(AppliesTo.class);
                if (appliesTo == null) continue;
                for (Class<?> allowedClass : appliesTo.value()) {
                    if (allowedClass == clazz) continue block0;
                }
                for (Class<?> allowedSuperClass : appliesTo.subClassesOf()) {
                    if (allowedSuperClass.isAssignableFrom((Class<?>)clazz)) continue block0;
                }
                String helpText = "";
                if (appliesTo.value().length != 0) {
                    helpText = Arrays.stream(appliesTo.value()).map(Class::getName).collect(Collectors.joining(", "));
                }
                if (appliesTo.subClassesOf().length != 0) {
                    if (!helpText.isEmpty()) {
                        helpText = helpText + "as well as ";
                    }
                    helpText = helpText + "subclasses of ";
                    helpText = helpText + Arrays.stream(appliesTo.subClassesOf()).map(Class::getName).collect(Collectors.joining(", "));
                }
                throw new IllegalArgumentException(String.format("%s does not apply to %s, only applies to %s", annotation.annotationType().getSimpleName(), clazz.getName(), helpText));
            }
        });
    }
}

