/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.api;

import com.code_intelligence.jazzer.mutation.api.InPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.SerializingInPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.AnnotatedType;
import java.util.Optional;

public abstract class MutatorFactory {
    public final boolean canMutate(AnnotatedType type2) {
        return this.tryCreate(type2).isPresent();
    }

    public final <T> SerializingMutator<T> createOrThrow(Class<T> clazz) {
        return this.createOrThrow(TypeSupport.asAnnotatedType(clazz));
    }

    public final SerializingMutator<?> createOrThrow(AnnotatedType type2) {
        Optional<SerializingMutator<?>> maybeMutator = this.tryCreate(type2);
        Preconditions.require(maybeMutator.isPresent(), "Failed to create mutator for " + type2);
        return maybeMutator.get();
    }

    public final SerializingInPlaceMutator<?> createInPlaceOrThrow(AnnotatedType type2) {
        Optional<SerializingInPlaceMutator<?>> maybeMutator = this.tryCreateInPlace(type2);
        Preconditions.require(maybeMutator.isPresent(), "Failed to create mutator for " + type2);
        return maybeMutator.get();
    }

    public final Optional<SerializingInPlaceMutator<?>> tryCreateInPlace(AnnotatedType type2) {
        return this.tryCreate(type2).map(mutator -> {
            Preconditions.require(mutator instanceof InPlaceMutator, String.format("Mutator for %s is not in-place: %s", type2, mutator.getClass()));
            return (SerializingInPlaceMutator)mutator;
        });
    }

    @CheckReturnValue
    public final Optional<SerializingMutator<?>> tryCreate(AnnotatedType type2) {
        return this.tryCreate(type2, this);
    }

    @CheckReturnValue
    public abstract Optional<SerializingMutator<?>> tryCreate(AnnotatedType var1, MutatorFactory var2);
}

