/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.api;

import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ChainedMutatorFactory
extends MutatorFactory {
    private final List<MutatorFactory> factories;

    public ChainedMutatorFactory(MutatorFactory ... factories) {
        this.factories = Collections.unmodifiableList(Arrays.asList(factories));
    }

    @Override
    @CheckReturnValue
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type2, MutatorFactory parent) {
        return StreamSupport.findFirstPresent(this.factories.stream().map(factory -> factory.tryCreate(type2, parent)));
    }
}

