/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver.junit;

import com.code_intelligence.jazzer.driver.ExceptionUtils;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.driver.junit.ExitCodeException;
import com.code_intelligence.jazzer.utils.Log;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.engine.JupiterTestEngine;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public final class JUnitRunner {
    private final Launcher launcher;
    private final TestPlan testPlan;

    private JUnitRunner(Launcher launcher, TestPlan testPlan) {
        this.launcher = launcher;
        this.testPlan = testPlan;
    }

    public static boolean isSupported() {
        try {
            Class.forName("org.junit.platform.launcher.LauncherDiscoveryRequest");
            Class.forName("org.junit.jupiter.engine.JupiterTestEngine");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Optional<JUnitRunner> create(String testClassName, List<String> libFuzzerArgs) {
        LauncherConfig config = LauncherConfig.builder().addTestEngines(new TestEngine[]{new JupiterTestEngine()}).enableLauncherDiscoveryListenerAutoRegistration(false).enableLauncherSessionListenerAutoRegistration(false).enablePostDiscoveryFilterAutoRegistration(false).enableTestEngineAutoRegistration(false).enableTestExecutionListenerAutoRegistration(false).build();
        Map<String, String> indexedArgs = IntStream.range(0, libFuzzerArgs.size()).boxed().collect(Collectors.toMap(i -> "jazzer.internal.arg." + i, libFuzzerArgs::get));
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request().configurationParameter("junit.jupiter.execution.timeout.mode", "disabled").configurationParameter("jazzer.internal.command_line", "true").configurationParameters(indexedArgs).selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((String)testClassName)}).filters(new Filter[]{TagFilter.includeTags((String[])new String[]{"jazzer"})});
        if (!Opt.targetMethod.get().isEmpty()) {
            requestBuilder.filters(new Filter[]{testDescriptor -> FilterResult.includedIf((!(testDescriptor instanceof MethodBasedTestDescriptor) || ((MethodBasedTestDescriptor)testDescriptor).getTestMethod().getName().equals(Opt.targetMethod.get()) ? 1 : 0) != 0)});
        }
        LauncherDiscoveryRequest request = requestBuilder.build();
        Launcher launcher = LauncherFactory.create((LauncherConfig)config);
        TestPlan testPlan = launcher.discover(request);
        if (!testPlan.containsTests()) {
            return Optional.empty();
        }
        return Optional.of(new JUnitRunner(launcher, testPlan));
    }

    public int run() {
        final AtomicReference testResultHolder = new AtomicReference();
        final AtomicBoolean sawContainerFailure = new AtomicBoolean();
        this.launcher.execute(this.testPlan, new TestExecutionListener[]{new TestExecutionListener(){

            public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
                if (testIdentifier.isTest()) {
                    testResultHolder.set(testExecutionResult);
                } else {
                    testExecutionResult.getThrowable().map(ExceptionUtils::preprocessThrowable).ifPresent(throwable -> {
                        sawContainerFailure.set(true);
                        Log.error(throwable);
                    });
                }
            }

            public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
                entry.getKeyValuePairs().values().forEach(Log::info);
            }
        }});
        TestExecutionResult result = (TestExecutionResult)testResultHolder.get();
        if (result == null) {
            Log.error("Failed to run fuzz test");
            return 1;
        }
        if (result.getStatus() != TestExecutionResult.Status.FAILED) {
            if (result.getStatus() == TestExecutionResult.Status.ABORTED) {
                Log.warn("Fuzz test aborted", result.getThrowable().orElse(null));
            }
            if (sawContainerFailure.get()) {
                return 1;
            }
            return 0;
        }
        Throwable throwable = (Throwable)result.getThrowable().get();
        if (throwable instanceof ExitCodeException) {
            return ((ExitCodeException)throwable).exitCode;
        }
        return 77;
    }
}

