/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Base64;

public final class RecordingFuzzedDataProvider
implements FuzzedDataProvider {
    private final FuzzedDataProvider target;
    private final ArrayList<Object> recordedReplies = new ArrayList();

    private RecordingFuzzedDataProvider(FuzzedDataProvider target) {
        this.target = target;
    }

    public static FuzzedDataProvider makeFuzzedDataProviderProxy(FuzzedDataProvider target) {
        return new RecordingFuzzedDataProvider(target);
    }

    public static String serializeFuzzedDataProviderProxy(FuzzedDataProvider proxy) throws IOException {
        return ((RecordingFuzzedDataProvider)proxy).serialize();
    }

    private <T> T recordAndReturn(T object) {
        this.recordedReplies.add(object);
        return object;
    }

    private String serialize() throws IOException {
        byte[] rawOut;
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            try (ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);){
                objectStream.writeObject(this.recordedReplies);
            }
            rawOut = byteStream.toByteArray();
        }
        return Base64.getEncoder().encodeToString(rawOut);
    }

    public boolean consumeBoolean() {
        return this.recordAndReturn(this.target.consumeBoolean());
    }

    public boolean[] consumeBooleans(int maxLength) {
        return this.recordAndReturn(this.target.consumeBooleans(maxLength));
    }

    public byte consumeByte() {
        return this.recordAndReturn(this.target.consumeByte());
    }

    public byte consumeByte(byte min, byte max) {
        return this.recordAndReturn(this.target.consumeByte(min, max));
    }

    public byte[] consumeBytes(int maxLength) {
        return this.recordAndReturn(this.target.consumeBytes(maxLength));
    }

    public byte[] consumeRemainingAsBytes() {
        return this.recordAndReturn(this.target.consumeRemainingAsBytes());
    }

    public short consumeShort() {
        return this.recordAndReturn(this.target.consumeShort());
    }

    public short consumeShort(short min, short max) {
        return this.recordAndReturn(this.target.consumeShort(min, max));
    }

    public short[] consumeShorts(int maxLength) {
        return this.recordAndReturn(this.target.consumeShorts(maxLength));
    }

    public int consumeInt() {
        return this.recordAndReturn(this.target.consumeInt());
    }

    public int consumeInt(int min, int max) {
        return this.recordAndReturn(this.target.consumeInt(min, max));
    }

    public int[] consumeInts(int maxLength) {
        return this.recordAndReturn(this.target.consumeInts(maxLength));
    }

    public long consumeLong() {
        return this.recordAndReturn(this.target.consumeLong());
    }

    public long consumeLong(long min, long max) {
        return this.recordAndReturn(this.target.consumeLong(min, max));
    }

    public long[] consumeLongs(int maxLength) {
        return this.recordAndReturn(this.target.consumeLongs(maxLength));
    }

    public float consumeFloat() {
        return this.recordAndReturn(Float.valueOf(this.target.consumeFloat())).floatValue();
    }

    public float consumeRegularFloat() {
        return this.recordAndReturn(Float.valueOf(this.target.consumeRegularFloat())).floatValue();
    }

    public float consumeRegularFloat(float min, float max) {
        return this.recordAndReturn(Float.valueOf(this.target.consumeRegularFloat(min, max))).floatValue();
    }

    public float consumeProbabilityFloat() {
        return this.recordAndReturn(Float.valueOf(this.target.consumeProbabilityFloat())).floatValue();
    }

    public double consumeDouble() {
        return this.recordAndReturn(this.target.consumeDouble());
    }

    public double consumeRegularDouble() {
        return this.recordAndReturn(this.target.consumeRegularDouble());
    }

    public double consumeRegularDouble(double min, double max) {
        return this.recordAndReturn(this.target.consumeRegularDouble(min, max));
    }

    public double consumeProbabilityDouble() {
        return this.recordAndReturn(this.target.consumeProbabilityDouble());
    }

    public char consumeChar() {
        return this.recordAndReturn(Character.valueOf(this.target.consumeChar())).charValue();
    }

    public char consumeChar(char min, char max) {
        return this.recordAndReturn(Character.valueOf(this.target.consumeChar(min, max))).charValue();
    }

    public char consumeCharNoSurrogates() {
        return this.recordAndReturn(Character.valueOf(this.target.consumeCharNoSurrogates())).charValue();
    }

    public String consumeString(int maxLength) {
        return this.recordAndReturn(this.target.consumeString(maxLength));
    }

    public String consumeRemainingAsString() {
        return this.recordAndReturn(this.target.consumeRemainingAsString());
    }

    public String consumeAsciiString(int maxLength) {
        return this.recordAndReturn(this.target.consumeAsciiString(maxLength));
    }

    public String consumeRemainingAsAsciiString() {
        return this.recordAndReturn(this.target.consumeRemainingAsAsciiString());
    }

    public int remainingBytes() {
        return this.recordAndReturn(this.target.remainingBytes());
    }
}

