/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.autofuzz;

import com.code_intelligence.jazzer.autofuzz.AutofuzzError;
import java.util.Stack;
import java.util.stream.Collectors;

public class AutofuzzCodegenVisitor {
    private final Stack<Group> groups = new Stack();
    private int variableCounter = 0;

    AutofuzzCodegenVisitor() {
        this.init();
    }

    private void init() {
        this.pushGroup("", "", "");
    }

    public void pushGroup(String prefix, String delimiter, String suffix) {
        this.groups.push(new Group(prefix, delimiter, suffix));
    }

    public void pushElement(String element) {
        this.groups.peek().push(element);
    }

    public void popElement() {
        this.groups.peek().pop();
    }

    public void popGroup() {
        if (this.groups.size() == 1) {
            throw new AutofuzzError("popGroup must be called exactly once for every pushGroup: " + this.toDebugString());
        }
        this.pushElement(this.groups.pop().toString());
    }

    public String generate() {
        if (this.groups.size() != 1) {
            throw new AutofuzzError("popGroup must be called exactly once for every pushGroup: " + this.toDebugString());
        }
        return this.groups.pop().toString();
    }

    public void addCharLiteral(char c) {
        this.pushElement("'" + AutofuzzCodegenVisitor.escapeForLiteral(Character.toString(c)) + "'");
    }

    public void addStringLiteral(String string) {
        this.pushElement('\"' + AutofuzzCodegenVisitor.escapeForLiteral(string) + '\"');
    }

    public String uniqueVariableName() {
        return String.format("autofuzzVariable%s", this.variableCounter++);
    }

    static String escapeForLiteral(String string) {
        return string.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("\"", "\\\"").replace("'", "\\'");
    }

    private String toDebugString() {
        return this.groups.stream().map(group -> ((Group)group).elements.stream().collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "[", "]"));
    }

    private static class Group {
        private final String prefix;
        private final String delimiter;
        private final String suffix;
        private final Stack<String> elements = new Stack();

        Group(String prefix, String delimiter, String suffix) {
            this.prefix = prefix;
            this.delimiter = delimiter;
            this.suffix = suffix;
        }

        public void push(String element) {
            this.elements.push(element);
        }

        public void pop() {
            this.elements.pop();
        }

        public String toString() {
            return this.elements.stream().collect(Collectors.joining(this.delimiter, this.prefix, this.suffix));
        }
    }
}

