/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer;

import com.code_intelligence.jazzer.android.AndroidRuntime;
import com.code_intelligence.jazzer.driver.Driver;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.runtime.Constants;
import com.code_intelligence.jazzer.third_party.com.github.fmeum.rules_jni.RulesJni;
import com.code_intelligence.jazzer.utils.Log;
import com.code_intelligence.jazzer.utils.ZipUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Jazzer {
    public static void main(String[] args2) throws IOException, InterruptedException {
        Jazzer.start(Arrays.stream(args2).collect(Collectors.toList()));
    }

    private static void main(byte[][] nativeArgs) throws IOException, InterruptedException {
        Jazzer.start(Arrays.stream(nativeArgs).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).collect(Collectors.toList()));
    }

    private static void start(List<String> args2) throws IOException, InterruptedException {
        Log.fixOutErr(System.out, System.err);
        Opt.registerAndValidateCommandLineArgs(Jazzer.parseJazzerArgs(args2));
        Opt.handleHelpAndVersionArgs();
        boolean loadASan = Opt.asan.get();
        boolean loadUBSan = Opt.ubsan.get();
        boolean loadHWASan = Opt.hwasan.get();
        boolean needsNative = loadASan || loadUBSan || loadHWASan;
        Opt.fuzzNative.setIfDefault(needsNative);
        boolean fuzzNative = Opt.fuzzNative.get();
        if (needsNative && !fuzzNative) {
            Log.error("--asan, --hwasan and --ubsan cannot be used without --native");
            System.exit(1);
        }
        if (!fuzzNative) {
            boolean spawnsSubprocesses;
            if (Constants.IS_ANDROID) {
                AndroidRuntime.initialize();
            }
            String arg0 = (spawnsSubprocesses = Stream.of("fork", "jobs", "merge", "minimize_crash").anyMatch(option -> Jazzer.isLibFuzzerOptionEnabled(option, args2))) ? Jazzer.prepareArgv0(new HashMap<String, String>()) : "jazzer";
            List<String> argsWithArgv0 = Stream.concat(Stream.of(arg0), args2.stream()).collect(Collectors.toList());
            System.exit(Driver.start(argsWithArgv0, spawnsSubprocesses));
        }
        if (!Jazzer.isLinux() && !Jazzer.isMacOs()) {
            Log.error("--asan, --ubsan, and --native are only supported on Linux and macOS");
            System.exit(1);
        }
        Set argsToFilter = Stream.of("--asan", "--ubsan", "--hwasan", "--native").collect(Collectors.toSet());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ArrayList<Path> preloadLibs = new ArrayList<Path>();
        preloadLibs.add(RulesJni.extractLibrary("jazzer_preload", Jazzer.class));
        if (loadASan) {
            processBuilder.environment().compute("ASAN_OPTIONS", (name, currentValue) -> Jazzer.appendWithPathListSeparator(name, "detect_leaks=0", "verify_asan_link_order=0"));
            Log.warn("Jazzer is not compatible with LeakSanitizer. Leaks are not reported.");
            preloadLibs.add(Jazzer.findLibrary(Jazzer.asanLibNames()));
        }
        if (loadHWASan) {
            processBuilder.environment().compute("HWASAN_OPTIONS", (name, currentValue) -> Jazzer.appendWithPathListSeparator(name, "detect_leaks=0", "verify_asan_link_order=0"));
            Log.warn("Jazzer is not compatible with LeakSanitizer. Leaks are not reported.");
            preloadLibs.add(Jazzer.findLibrary(Jazzer.hwasanLibNames()));
        }
        if (loadUBSan) {
            preloadLibs.add(Jazzer.findLibrary(Jazzer.ubsanLibNames()));
        }
        processBuilder.environment().remove(Jazzer.preloadVariable());
        HashMap<String, String> additionalEnvironment = new HashMap<String, String>();
        additionalEnvironment.put(Jazzer.preloadVariable(), Jazzer.appendWithPathListSeparator(Jazzer.preloadVariable(), (String[])preloadLibs.stream().map(Path::toString).toArray(String[]::new)));
        List<String> subProcessArgs = Stream.concat(Stream.of(Jazzer.prepareArgv0(additionalEnvironment)), args2.stream().filter(arg -> !argsToFilter.contains(arg.split("=")[0]))).collect(Collectors.toList());
        processBuilder.command(subProcessArgs);
        processBuilder.inheritIO();
        System.exit(processBuilder.start().waitFor());
    }

    private static List<Map.Entry<String, String>> parseJazzerArgs(List<String> args2) {
        return args2.stream().filter(arg -> arg.startsWith("--")).map(arg -> arg.substring("--".length())).filter(arg -> !arg.isEmpty()).map(Jazzer::parseSingleArg).collect(Collectors.toList());
    }

    private static AbstractMap.SimpleImmutableEntry<String, String> parseSingleArg(String arg) {
        String[] nameAndValue = arg.split("=", 2);
        if (nameAndValue.length == 2) {
            return new AbstractMap.SimpleImmutableEntry<String, String>(nameAndValue[0], nameAndValue[1]);
        }
        if (nameAndValue[0].startsWith("no")) {
            return new AbstractMap.SimpleImmutableEntry<String, String>(nameAndValue[0].substring("no".length()), "false");
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(nameAndValue[0], "true");
    }

    static boolean isLibFuzzerOptionEnabled(String option, List<String> args2) {
        return args2.stream().filter(arg -> arg.startsWith(String.format("-%s=", option))).map(arg -> arg.split("=", 2)[1]).map(value -> !value.isEmpty() && !value.equals("0")).reduce(false, (prev, current) -> current);
    }

    private static String prepareArgv0(Map<String, String> additionalEnvironment) throws IOException {
        Path launcher;
        String launcherContent;
        String invocation;
        FileAttribute[] fileAttributeArray;
        String launcherExtension;
        char shellQuote;
        if (!Jazzer.isPosixOrAndroid() && !additionalEnvironment.isEmpty()) {
            throw new IllegalArgumentException("Setting environment variables in the wrapper is only supported on POSIX systems and Android");
        }
        char c = shellQuote = Jazzer.isPosixOrAndroid() ? (char)'\'' : '\"';
        String launcherTemplate = Constants.IS_ANDROID ? "#!/system/bin/env sh\n%s LD_LIBRARY_PATH=%s \n%s $@\n" : (Jazzer.isPosix() ? "#!/usr/bin/env sh\n%s $@\n" : "@echo off\r\n%s %%*\r\n");
        String string = launcherExtension = Jazzer.isPosix() ? ".sh" : ".bat";
        if (Jazzer.isPosixOrAndroid()) {
            FileAttribute[] fileAttributeArray2 = new FileAttribute[1];
            fileAttributeArray = fileAttributeArray2;
            fileAttributeArray2[0] = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        } else {
            fileAttributeArray = new FileAttribute[]{};
        }
        FileAttribute[] launcherScriptAttributes = fileAttributeArray;
        String env = additionalEnvironment.entrySet().stream().map(e -> (String)e.getKey() + "='" + (String)e.getValue() + "'").collect(Collectors.joining(" "));
        String command = Stream.concat(Stream.of(Constants.IS_ANDROID ? "exec" : Jazzer.javaBinary().toString()), Jazzer.javaBinaryArgs()).map(str -> shellQuote + str + shellQuote).collect(Collectors.joining(" "));
        String string2 = invocation = env.isEmpty() ? command : env + " " + command;
        if (Constants.IS_ANDROID) {
            String exportCommand = AndroidRuntime.getClassPathsCommand();
            String ldLibraryPath = AndroidRuntime.getLdLibraryPath();
            launcherContent = String.format(launcherTemplate, exportCommand, ldLibraryPath, invocation);
            launcher = Files.createTempFile(Paths.get("/data/local/tmp/", new String[0]), "jazzer-", launcherExtension, launcherScriptAttributes);
        } else {
            launcherContent = String.format(launcherTemplate, invocation);
            launcher = Files.createTempFile("jazzer-", launcherExtension, launcherScriptAttributes);
        }
        launcher.toFile().deleteOnExit();
        Files.write(launcher, launcherContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return launcher.toAbsolutePath().toString();
    }

    private static Path javaBinary() {
        String javaBinaryName = Jazzer.isPosix() ? "java" : "java.exe";
        return Paths.get(System.getProperty("java.home"), "bin", javaBinaryName);
    }

    private static Stream<String> javaBinaryArgs() throws IOException {
        if (Constants.IS_ANDROID) {
            Path agentPath = RulesJni.extractLibrary("android_native_agent", "/com/code_intelligence/jazzer/android");
            String jazzerAgentPath = Opt.agentPath.get();
            String bootclassClassOverrides = Opt.androidBootclassClassesOverrides.get();
            String jazzerBootstrapJarPath = "com/code_intelligence/jazzer/android/jazzer_bootstrap_android.jar";
            String jazzerBootstrapJarOut = "/data/local/tmp/jazzer_bootstrap_android.jar";
            try {
                ZipUtils.extractFile(jazzerAgentPath, jazzerBootstrapJarPath, jazzerBootstrapJarOut);
            }
            catch (IOException ioe) {
                Log.error("Could not extract jazzer_bootstrap_android.jar from Jazzer standalone agent", ioe);
                System.exit(1);
            }
            String nativeAgentOptions = "injectJars=" + jazzerBootstrapJarOut;
            if (bootclassClassOverrides != null && !bootclassClassOverrides.isEmpty()) {
                nativeAgentOptions = nativeAgentOptions + ",bootstrapClassOverrides=" + bootclassClassOverrides;
            }
            Stream<String> stream = Stream.of("app_process", "-Djdk.attach.allowAttachSelf=true", "-Xplugin:libopenjdkjvmti.so", "-agentpath:" + agentPath.toString() + "=" + nativeAgentOptions, "-Xcompiler-option", "--debuggable", "/system/bin", Jazzer.class.getName());
            return stream;
        }
        Stream<String> stream = Stream.of("-cp", System.getProperty("java.class.path"), "-Djdk.attach.allowAttachSelf=true", Jazzer.class.getName());
        return Stream.concat(ManagementFactory.getRuntimeMXBean().getInputArguments().stream(), stream);
    }

    private static String appendWithPathListSeparator(String name, String ... options) {
        if (options.length == 0) {
            throw new IllegalArgumentException("options must not be empty");
        }
        String currentValue = Optional.ofNullable(System.getenv(name)).orElse("");
        String additionalOptions = String.join((CharSequence)File.pathSeparator, options);
        if (currentValue.isEmpty()) {
            return additionalOptions;
        }
        return currentValue + File.pathSeparator + additionalOptions;
    }

    private static Path findLibrary(List<String> candidateNames) {
        if (!Constants.IS_ANDROID) {
            return Jazzer.findHostClangLibrary(candidateNames);
        }
        for (String candidateName : candidateNames) {
            String candidateFullPath = "/apex/com.android.runtime/lib64/bionic/" + candidateName;
            File f = new File(candidateFullPath);
            if (!f.exists()) continue;
            return Paths.get(candidateFullPath, new String[0]);
        }
        Log.error(String.format("Failed to find one of %s%n for Android", String.join((CharSequence)", ", candidateNames)));
        Log.error("If fuzzing hwasan, make sure you have a hwasan build flashed to your device");
        System.exit(1);
        throw new IllegalStateException("not reached");
    }

    private static Path findHostClangLibrary(List<String> candidateNames) {
        Optional<Path> path;
        for (String name : candidateNames) {
            path = Jazzer.tryFindLibraryInJazzerNativeSanitizersDir(name);
            if (!path.isPresent()) continue;
            return path.get();
        }
        for (String name : candidateNames) {
            path = Jazzer.tryFindLibraryUsingClang(name);
            if (!path.isPresent()) continue;
            return path.get();
        }
        Log.error("Failed to find one of: " + String.join((CharSequence)", ", candidateNames));
        System.exit(1);
        throw new IllegalStateException("not reached");
    }

    private static Optional<Path> tryFindLibraryInJazzerNativeSanitizersDir(String name) {
        String nativeSanitizersDir = System.getenv("JAZZER_NATIVE_SANITIZERS_DIR");
        if (nativeSanitizersDir == null) {
            return Optional.empty();
        }
        Path candidatePath = Paths.get(nativeSanitizersDir, name);
        if (Files.exists(candidatePath, new LinkOption[0])) {
            return Optional.of(candidatePath);
        }
        return Optional.empty();
    }

    private static Optional<Path> tryFindLibraryUsingClang(String name) {
        byte[] output;
        List<String> command = Arrays.asList(Jazzer.hostClang(), "--print-file-name", name);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.start();
            if (process.waitFor() != 0) {
                Log.error(String.format("'%s' exited with exit code %d", String.join((CharSequence)" ", command), process.exitValue()));
                Jazzer.copy(process.getInputStream(), System.out);
                Jazzer.copy(process.getErrorStream(), System.err);
                System.exit(1);
            }
            output = Jazzer.readAllBytes(process.getInputStream());
        }
        catch (IOException | InterruptedException e) {
            Log.error(String.format("Failed to run '%s'", String.join((CharSequence)" ", command)), e);
            System.exit(1);
            throw new IllegalStateException("not reached");
        }
        Path library = Paths.get(new String(output).trim(), new String[0]);
        if (Files.exists(library, new LinkOption[0])) {
            return Optional.of(library);
        }
        return Optional.empty();
    }

    private static String hostClang() {
        return Optional.ofNullable(System.getenv("CC")).orElse("clang");
    }

    private static List<String> hwasanLibNames() {
        if (!Constants.IS_ANDROID) {
            Log.error("HWAsan is only supported for Android. Please try --asan");
            System.exit(1);
        }
        return Collections.singletonList("libclang_rt.hwasan-aarch64-android.so");
    }

    private static List<String> asanLibNames() {
        if (Jazzer.isLinux()) {
            if (Constants.IS_ANDROID) {
                Log.error("ASan is not supported for Android at this time. Use --hwasan for Address Sanitization on Android");
                System.exit(1);
            }
            return Arrays.asList("libclang_rt.asan.so", "libclang_rt.asan-x86_64.so");
        }
        return Collections.singletonList("libclang_rt.asan_osx_dynamic.dylib");
    }

    private static List<String> ubsanLibNames() {
        if (Jazzer.isLinux()) {
            if (Constants.IS_ANDROID) {
                Log.error("ERROR: UBSan is not supported for Android at this time.");
                System.exit(1);
            }
            return Arrays.asList("libclang_rt.ubsan_standalone.so", "libclang_rt.ubsan_standalone-x86_64.so");
        }
        return Collections.singletonList("libclang_rt.ubsan_osx_dynamic.dylib");
    }

    private static String preloadVariable() {
        return Jazzer.isLinux() ? "LD_PRELOAD" : "DYLD_INSERT_LIBRARIES";
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    private static boolean isMacOs() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    private static boolean isPosix() {
        return !Constants.IS_ANDROID && FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private static boolean isPosixOrAndroid() {
        if (Jazzer.isPosix()) {
            return true;
        }
        return Constants.IS_ANDROID;
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Jazzer.copy(in, out);
        return out.toByteArray();
    }

    private static void copy(InputStream source, OutputStream target) throws IOException {
        int read;
        byte[] buffer = new byte[0x680000];
        while ((read = source.read(buffer)) != -1) {
            target.write(buffer, 0, read);
        }
    }
}

