/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.transformation;

import com.cloudinary.Transformation;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseExpression<T extends BaseExpression> {
    public static final Map<String, String> OPERATORS = ObjectUtils.asMap("=", "eq", "!=", "ne", "<", "lt", ">", "gt", "<=", "lte", ">=", "gte", "&&", "and", "||", "or", "*", "mul", "/", "div", "+", "add", "-", "sub");
    public static final Map<String, String> PREDEFINED_VARS = ObjectUtils.asMap("width", "w", "height", "h", "initialWidth", "iw", "initialHeight", "ih", "aspect_ratio", "ar", "initial_aspect_ratio", "iar", "aspectRatio", "ar", "initialAspectRatio", "iar", "page_count", "pc", "pageCount", "pc", "face_count", "fc", "faceCount", "fc", "current_page", "cp", "currentPage", "cp", "tags", "tags", "pageX", "px", "pageY", "py");
    private static final Pattern PATTERN = BaseExpression.getPattern();
    protected List<String> expressions = new ArrayList<String>();
    protected Transformation parent = null;

    protected BaseExpression() {
    }

    public static String normalize(Object expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof Number) {
            return String.valueOf(expression);
        }
        String conditionStr = StringUtils.mergeToSingleUnderscore(String.valueOf(expression));
        Matcher matcher = PATTERN.matcher(conditionStr);
        StringBuffer result = new StringBuffer(conditionStr.length());
        while (matcher.find()) {
            String replacement = OPERATORS.containsKey(matcher.group()) ? OPERATORS.get(matcher.group()) : (PREDEFINED_VARS.containsKey(matcher.group()) ? PREDEFINED_VARS.get(matcher.group()) : matcher.group());
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static Pattern getPattern() {
        ArrayList<String> operators = new ArrayList<String>(OPERATORS.keySet());
        Collections.sort(operators, Collections.reverseOrder());
        StringBuilder sb = new StringBuilder("((");
        for (String op : operators) {
            sb.append(Pattern.quote(op)).append("|");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")(?=[ _])|").append(StringUtils.join(PREDEFINED_VARS.keySet(), "|")).append(")");
        String pattern = sb.toString();
        return Pattern.compile(pattern);
    }

    public Transformation getParent() {
        return this.parent;
    }

    public T setParent(Transformation parent) {
        this.parent = parent;
        return (T)this;
    }

    public String serialize() {
        return BaseExpression.normalize(StringUtils.join(this.expressions, "_"));
    }

    public String toString() {
        return this.serialize();
    }

    public T clone() {
        T newCondition = this.newInstance();
        ((BaseExpression)newCondition).expressions.addAll(this.expressions);
        ((BaseExpression)newCondition).parent = this.parent;
        return newCondition;
    }

    public T multiple(Object value) {
        this.expressions.add("mul");
        this.expressions.add(value.toString());
        return (T)this;
    }

    protected abstract T newInstance();

    public T gt(Object value) {
        return ((BaseExpression)this.gt()).value(value);
    }

    public T gt() {
        this.expressions.add("gt");
        return (T)this;
    }

    public T and(Object value) {
        return ((BaseExpression)this.and()).value(value);
    }

    public T and() {
        this.expressions.add("and");
        return (T)this;
    }

    public T or(Object value) {
        return ((BaseExpression)this.or()).value(value);
    }

    public T or() {
        this.expressions.add("or");
        return (T)this;
    }

    public T eq(Object value) {
        return ((BaseExpression)this.eq()).value(value);
    }

    public T eq() {
        this.expressions.add("eq");
        return (T)this;
    }

    public T ne(Object value) {
        return ((BaseExpression)this.ne()).value(value);
    }

    public T ne() {
        this.expressions.add("ne");
        return (T)this;
    }

    public T lt(Object value) {
        return ((BaseExpression)this.lt()).value(value);
    }

    public T lt() {
        this.expressions.add("lt");
        return (T)this;
    }

    public T lte(Object value) {
        return ((BaseExpression)this.lte()).value(value);
    }

    public T lte() {
        this.expressions.add("lte");
        return (T)this;
    }

    public T gte(Object value) {
        return ((BaseExpression)this.gte()).value(value);
    }

    public T gte() {
        this.expressions.add("gte");
        return (T)this;
    }

    public T div(Object value) {
        return ((BaseExpression)this.div()).value(value);
    }

    public T div() {
        this.expressions.add("div");
        return (T)this;
    }

    public T add(Object value) {
        return ((BaseExpression)this.add()).value(value);
    }

    public T add() {
        this.expressions.add("add");
        return (T)this;
    }

    public T sub(Object value) {
        return ((BaseExpression)this.sub()).value(value);
    }

    public T sub() {
        this.expressions.add("sub");
        return (T)this;
    }

    public T value(Object value) {
        this.expressions.add(String.valueOf(value));
        return (T)this;
    }
}

