/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.filefilter;

import com.cloudhopper.commons.util.DateTimeUtil;
import java.io.File;
import java.io.FileFilter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNameDateTimeFilter
implements FileFilter {
    private static final Logger logger = LoggerFactory.getLogger(FileNameDateTimeFilter.class);
    private String pattern;
    private DateTime cutoffDate;
    private DateTimeZone zone;

    public FileNameDateTimeFilter(DateTime cutoffDate) {
        this(cutoffDate, null, null);
    }

    public FileNameDateTimeFilter(DateTime cutoffDate, DateTimeZone zone) {
        this(cutoffDate, null, zone);
    }

    public FileNameDateTimeFilter(DateTime cutoffDate, String pattern) {
        this(cutoffDate, pattern, null);
    }

    public FileNameDateTimeFilter(DateTime cutoffDate, String pattern, DateTimeZone zone) {
        this.cutoffDate = cutoffDate;
        this.pattern = pattern == null ? "yyyy-MM-dd" : pattern;
        this.zone = zone == null ? DateTimeZone.UTC : zone;
    }

    @Override
    public boolean accept(File file) {
        DateTime d = null;
        try {
            d = DateTimeUtil.parseEmbedded(file.getName(), this.pattern, this.zone);
        }
        catch (Exception e) {
            return false;
        }
        logger.trace("Filename '" + file.getName() + "' contained an embedded date of " + d);
        if (d.isBefore((ReadableInstant)this.cutoffDate) || d.isEqual((ReadableInstant)this.cutoffDate)) {
            logger.trace("Filename '" + file.getName() + "' embedded date of " + d + " occurred beforeOrEquals " + d.isBefore((ReadableInstant)this.cutoffDate));
            return true;
        }
        logger.trace("Skipping filename '" + file.getName() + "' since its embedded date of " + d + " occurred after " + this.cutoffDate);
        return false;
    }
}

