/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource.sync;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.AzureBlobImportRequest;
import com.cloudconvert.dto.request.GoogleCloudStorageImportRequest;
import com.cloudconvert.dto.request.OpenStackImportRequest;
import com.cloudconvert.dto.request.S3ImportRequest;
import com.cloudconvert.dto.request.SftpImportRequest;
import com.cloudconvert.dto.request.UploadImportRequest;
import com.cloudconvert.dto.request.UrlImportRequest;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.executor.RequestExecutor;
import com.cloudconvert.resource.AbstractImportFilesResource;
import com.cloudconvert.resource.sync.TasksResource;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFilesResource
extends AbstractImportFilesResource<Result<TaskResponse>> {
    private static final Logger log = LoggerFactory.getLogger(ImportFilesResource.class);
    private final RequestExecutor requestExecutor;
    private final TasksResource tasksResource;

    public ImportFilesResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, RequestExecutor requestExecutor, TasksResource tasksResource) {
        super(settingsProvider, objectMapperProvider);
        this.requestExecutor = requestExecutor;
        this.tasksResource = tasksResource;
    }

    @Override
    public Result<TaskResponse> url(@NotNull UrlImportRequest urlImportRequest) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getUrlHttpUriRequest(urlImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> upload(@NotNull UploadImportRequest uploadImportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)"import", (Object)"upload"));
        HttpEntity httpEntity = this.getHttpEntity(uploadImportRequest);
        HttpUriRequest httpUriRequest = this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
        return this.requestExecutor.execute(httpUriRequest, TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> upload(@NotNull UploadImportRequest uploadImportRequest, @NotNull File file) throws IOException, URISyntaxException {
        return this.upload((Result<TaskResponse>)this.upload(uploadImportRequest), file);
    }

    @Override
    public Result<TaskResponse> upload(@NotNull Result<TaskResponse> TaskResponseResult, @NotNull File file) throws IOException, URISyntaxException {
        if (201 == TaskResponseResult.getStatus()) {
            TaskResponse taskResponse = TaskResponseResult.getBody();
            return this.upload(taskResponse.getId(), taskResponse.getResult().getForm(), file);
        }
        return Result.builder().status(TaskResponseResult.getStatus()).message(TaskResponseResult.getMessage()).build();
    }

    @Override
    public Result<TaskResponse> upload(@NotNull String taskId, @NotNull TaskResponse.Result.Form taskResponseResultForm, @NotNull File file) throws IOException, URISyntaxException {
        URI multipartUri = new URI(taskResponseResultForm.getUrl());
        HttpEntity multipartHttpEntity = this.getMultipartHttpEntity(taskResponseResultForm, file);
        HttpUriRequest multipartHttpUriRequest = this.getHttpUriRequest(HttpPost.class, multipartUri, multipartHttpEntity);
        multipartHttpUriRequest.removeHeaders("Authorization");
        return this.uploadPostProcess(taskId, this.requestExecutor.execute(multipartHttpUriRequest, VOID_TYPE_REFERENCE));
    }

    @Override
    public Result<TaskResponse> upload(@NotNull UploadImportRequest uploadImportRequest, @NotNull InputStream inputStream) throws IOException, URISyntaxException {
        return this.upload((Result<TaskResponse>)this.upload(uploadImportRequest), inputStream);
    }

    @Override
    public Result<TaskResponse> upload(@NotNull Result<TaskResponse> TaskResponseResult, @NotNull InputStream inputStream) throws IOException, URISyntaxException {
        if (201 == TaskResponseResult.getStatus()) {
            TaskResponse taskResponse = TaskResponseResult.getBody();
            return this.upload(taskResponse.getId(), taskResponse.getResult().getForm(), inputStream);
        }
        return Result.builder().status(TaskResponseResult.getStatus()).message(TaskResponseResult.getMessage()).build();
    }

    @Override
    public Result<TaskResponse> upload(@NotNull String taskId, @NotNull TaskResponse.Result.Form taskResponseResultForm, @NotNull InputStream inputStream) throws IOException, URISyntaxException {
        URI multipartUri = new URI(taskResponseResultForm.getUrl());
        HttpEntity multipartHttpEntity = this.getMultipartHttpEntity(taskResponseResultForm, inputStream);
        HttpUriRequest multipartHttpUriRequest = this.getHttpUriRequest(HttpPost.class, multipartUri, multipartHttpEntity);
        multipartHttpUriRequest.removeHeaders("Authorization");
        return this.uploadPostProcess(taskId, this.requestExecutor.execute(multipartHttpUriRequest, VOID_TYPE_REFERENCE));
    }

    private Result<TaskResponse> uploadPostProcess(String taskId, Result<Void> multipartVoidResult) throws IOException, URISyntaxException {
        if (201 == multipartVoidResult.getStatus()) {
            return this.tasksResource.show(taskId);
        }
        if (303 == multipartVoidResult.getStatus()) {
            URI redirectUri = new URI(multipartVoidResult.getHeaders().get("Location"));
            HttpUriRequest redirectHttpUriRequest = this.getHttpUriRequest(HttpGet.class, redirectUri);
            Result redirectVoidResult = this.requestExecutor.execute(redirectHttpUriRequest, VOID_TYPE_REFERENCE);
            if (201 == redirectVoidResult.getStatus()) {
                return this.tasksResource.show(taskId);
            }
            return Result.builder().status(redirectVoidResult.getStatus()).message(redirectVoidResult.getMessage()).build();
        }
        return Result.builder().status(multipartVoidResult.getStatus()).message(multipartVoidResult.getMessage()).build();
    }

    @Override
    public Result<TaskResponse> s3(@NotNull S3ImportRequest s3ImportRequest) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getS3HttpUriRequest(s3ImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> azureBlob(@NotNull AzureBlobImportRequest azureBlobImportRequest) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getAzureBlobHttpUriRequest(azureBlobImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> googleCloudStorage(@NotNull GoogleCloudStorageImportRequest googleCloudStorageImportRequest) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getGoogleCloudHttpUriRequest(googleCloudStorageImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> openStack(@NotNull OpenStackImportRequest openStackImportRequest) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getOpenStackHttpUriRequest(openStackImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> sftp(@NotNull SftpImportRequest sftpImportRequest) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getSftpHttpUriRequest(sftpImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public void close() throws IOException {
        this.requestExecutor.close();
        this.tasksResource.close();
    }
}

