/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zendesk.client.v2.DefaultUserAgent;
import org.zendesk.client.v2.FixedUri;
import org.zendesk.client.v2.TemplateUri;
import org.zendesk.client.v2.Uri;
import org.zendesk.client.v2.ZendeskException;
import org.zendesk.client.v2.ZendeskResponseException;
import org.zendesk.client.v2.ZendeskResponseRateLimitException;
import org.zendesk.client.v2.model.AgentRole;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.Audit;
import org.zendesk.client.v2.model.Automation;
import org.zendesk.client.v2.model.Brand;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.ComplianceDeletionStatus;
import org.zendesk.client.v2.model.CustomTicketStatus;
import org.zendesk.client.v2.model.DeletedTicket;
import org.zendesk.client.v2.model.Field;
import org.zendesk.client.v2.model.Forum;
import org.zendesk.client.v2.model.Group;
import org.zendesk.client.v2.model.GroupMembership;
import org.zendesk.client.v2.model.Identity;
import org.zendesk.client.v2.model.JiraLink;
import org.zendesk.client.v2.model.JobStatus;
import org.zendesk.client.v2.model.Locale;
import org.zendesk.client.v2.model.Macro;
import org.zendesk.client.v2.model.Metric;
import org.zendesk.client.v2.model.Organization;
import org.zendesk.client.v2.model.OrganizationField;
import org.zendesk.client.v2.model.OrganizationMembership;
import org.zendesk.client.v2.model.Request;
import org.zendesk.client.v2.model.SatisfactionRating;
import org.zendesk.client.v2.model.SearchResultEntity;
import org.zendesk.client.v2.model.SortOrder;
import org.zendesk.client.v2.model.Status;
import org.zendesk.client.v2.model.SuspendedTicket;
import org.zendesk.client.v2.model.Ticket;
import org.zendesk.client.v2.model.TicketCount;
import org.zendesk.client.v2.model.TicketForm;
import org.zendesk.client.v2.model.TicketImport;
import org.zendesk.client.v2.model.TicketPage;
import org.zendesk.client.v2.model.TicketResult;
import org.zendesk.client.v2.model.TimeZone;
import org.zendesk.client.v2.model.Topic;
import org.zendesk.client.v2.model.Trigger;
import org.zendesk.client.v2.model.TwitterMonitor;
import org.zendesk.client.v2.model.User;
import org.zendesk.client.v2.model.UserField;
import org.zendesk.client.v2.model.UserRelatedInfo;
import org.zendesk.client.v2.model.View;
import org.zendesk.client.v2.model.dynamic.DynamicContentItem;
import org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant;
import org.zendesk.client.v2.model.hc.Article;
import org.zendesk.client.v2.model.hc.ArticleAttachments;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.ContentTag;
import org.zendesk.client.v2.model.hc.Locales;
import org.zendesk.client.v2.model.hc.PermissionGroup;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.Subscription;
import org.zendesk.client.v2.model.hc.Translation;
import org.zendesk.client.v2.model.hc.UserSegment;
import org.zendesk.client.v2.model.schedules.Holiday;
import org.zendesk.client.v2.model.schedules.Schedule;
import org.zendesk.client.v2.model.targets.BasecampTarget;
import org.zendesk.client.v2.model.targets.CampfireTarget;
import org.zendesk.client.v2.model.targets.EmailTarget;
import org.zendesk.client.v2.model.targets.PivotalTarget;
import org.zendesk.client.v2.model.targets.Target;
import org.zendesk.client.v2.model.targets.TwitterTarget;
import org.zendesk.client.v2.model.targets.UrlTarget;
import org.zendesk.client.v2.model.views.ExecutedViewPage;
import org.zendesk.client.v2.model.views.ViewRow;

public class Zendesk
implements Closeable {
    private static final String JSON = "application/json; charset=UTF-8";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final DefaultAsyncHttpClientConfig DEFAULT_ASYNC_HTTP_CLIENT_CONFIG = new DefaultAsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
    private final boolean closeClient;
    private final AsyncHttpClient client;
    private final Realm realm;
    private final String url;
    private final String oauthToken;
    private final Map<String, String> headers;
    private final int cbpPageSize;
    private final ObjectMapper mapper;
    private final Logger logger = LoggerFactory.getLogger(Zendesk.class);
    private boolean closed = false;
    private static final Map<String, Class<? extends SearchResultEntity>> searchResultTypes = Zendesk.searchResultTypes();
    private static final Map<String, Class<? extends Target>> targetTypes = Zendesk.targetTypes();
    private static final String CURSOR_LINKS = "links";
    private static final String CURSOR_NEXT_PAGE = "next";
    private static final String NEXT_PAGE = "next_page";
    private static final String END_TIME = "end_time";
    private static final String COUNT = "count";
    private static final int INCREMENTAL_EXPORT_MAX_COUNT_BY_REQUEST = 1000;
    private static final long FIVE_MINUTES = TimeUnit.MINUTES.toMillis(5L);
    private static final String UTF_8 = "UTF-8";

    private static Map<String, Class<? extends SearchResultEntity>> searchResultTypes() {
        HashMap<String, Class> result = new HashMap<String, Class>();
        result.put("ticket", Ticket.class);
        result.put("user", User.class);
        result.put("group", Group.class);
        result.put("organization", Organization.class);
        result.put("topic", Topic.class);
        result.put("article", Article.class);
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, Class<? extends Target>> targetTypes() {
        HashMap<String, Class> result = new HashMap<String, Class>();
        result.put("url_target", UrlTarget.class);
        result.put("email_target", EmailTarget.class);
        result.put("basecamp_target", BasecampTarget.class);
        result.put("campfire_target", CampfireTarget.class);
        result.put("pivotal_target", PivotalTarget.class);
        result.put("twitter_target", TwitterTarget.class);
        return Collections.unmodifiableMap(result);
    }

    private Zendesk(AsyncHttpClient client, String url, String username, String password, Map<String, String> headers, int cbpPageSize) {
        this.closeClient = client == null;
        this.oauthToken = null;
        this.client = client == null ? new DefaultAsyncHttpClient((AsyncHttpClientConfig)DEFAULT_ASYNC_HTTP_CLIENT_CONFIG) : client;
        Object object = this.url = url.endsWith("/") ? url + "api/v2" : url + "/api/v2";
        if (username != null) {
            this.realm = new Realm.Builder(username, password).setScheme(Realm.AuthScheme.BASIC).setUsePreemptiveAuth(true).build();
        } else {
            if (password != null) {
                throw new IllegalStateException("Cannot specify token or password without specifying username");
            }
            this.realm = null;
        }
        headers.putIfAbsent(USER_AGENT_HEADER, new DefaultUserAgent().toString());
        this.headers = Collections.unmodifiableMap(headers);
        this.cbpPageSize = cbpPageSize;
        this.mapper = Zendesk.createMapper();
    }

    private Zendesk(AsyncHttpClient client, String url, String oauthToken, Map<String, String> headers, int cbpPageSize) {
        this.closeClient = client == null;
        this.realm = null;
        this.client = client == null ? new DefaultAsyncHttpClient((AsyncHttpClientConfig)DEFAULT_ASYNC_HTTP_CLIENT_CONFIG) : client;
        Object object = this.url = url.endsWith("/") ? url + "api/v2" : url + "/api/v2";
        if (oauthToken == null) {
            throw new IllegalStateException("Cannot specify token or password without specifying username");
        }
        this.oauthToken = oauthToken;
        headers.putIfAbsent(USER_AGENT_HEADER, new DefaultUserAgent().toString());
        this.headers = Collections.unmodifiableMap(headers);
        this.cbpPageSize = cbpPageSize;
        this.mapper = Zendesk.createMapper();
    }

    public boolean isClosed() {
        return this.closed || this.client.isClosed();
    }

    @Override
    public void close() {
        if (this.closeClient && !this.client.isClosed()) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                this.logger.warn("Unexpected error on client close", (Throwable)e);
            }
        }
        this.closed = true;
    }

    public JobStatus getJobStatus(JobStatus status) {
        return Zendesk.complete(this.getJobStatusAsync(status));
    }

    public ListenableFuture<JobStatus> getJobStatusAsync(JobStatus status) {
        return this.submit(this.req("GET", this.tmpl("/job_statuses/{id}.json").set("id", status.getId())), this.handleJobStatus());
    }

    public List<JobStatus> getJobStatuses(List<JobStatus> statuses) {
        return Zendesk.complete(this.getJobStatusesAsync(statuses));
    }

    public ListenableFuture<List<JobStatus>> getJobStatusesAsync(List<JobStatus> statuses) {
        ArrayList<String> ids = new ArrayList<String>(statuses.size());
        for (JobStatus status : statuses) {
            ids.add(status.getId());
        }
        Class<JobStatus> clazz = JobStatus.class;
        return this.submit(this.req("GET", this.tmpl("/job_statuses/show_many.json{?ids}").set("ids", ids)), this.handleList(clazz, "job_statuses"));
    }

    public Iterable<Brand> getBrands() {
        return new PagedIterable<Brand>(this.cbp("/brands.json"), this.handleList(Brand.class, "brands"));
    }

    public TicketForm getTicketForm(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/ticket_forms/{id}.json").set("id", id)), this.handle(TicketForm.class, "ticket_form", new Class[0])));
    }

    public List<TicketForm> getTicketForms() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/ticket_forms.json")), this.handleList(TicketForm.class, "ticket_forms")));
    }

    public TicketForm createTicketForm(TicketForm ticketForm) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/ticket_forms.json"), JSON, this.json(Collections.singletonMap("ticket_form", ticketForm))), this.handle(TicketForm.class, "ticket_form", new Class[0])));
    }

    public TicketForm updateTicketForm(TicketForm ticketForm) {
        Zendesk.checkHasId(ticketForm);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/ticket_forms/{id}.json").set("id", ticketForm.getId()), JSON, this.json(Collections.singletonMap("ticket_form", ticketForm))), this.handle(TicketForm.class, "ticket_form", new Class[0])));
    }

    public void deleteTicketForm(TicketForm ticketForm) {
        Zendesk.checkHasId(ticketForm);
        this.deleteTicketForm(ticketForm.getId());
    }

    public void deleteTicketForm(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/ticket_forms/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Ticket importTicket(TicketImport ticketImport) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/imports/tickets.json"), JSON, this.json(Collections.singletonMap("ticket", ticketImport))), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public JobStatus importTickets(TicketImport ... ticketImports) {
        return this.importTickets(Arrays.asList(ticketImports));
    }

    public JobStatus importTickets(List<TicketImport> ticketImports) {
        return Zendesk.complete(this.importTicketsAsync(ticketImports));
    }

    public ListenableFuture<JobStatus> importTicketsAsync(List<TicketImport> ticketImports) {
        return this.submit(this.req("POST", this.cnst("/imports/tickets/create_many.json"), JSON, this.json(Collections.singletonMap("tickets", ticketImports))), this.handleJobStatus());
    }

    public TicketCount getTicketsCount() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/tickets/count.json")), this.handle(TicketCount.class, COUNT, new Class[0])));
    }

    public TicketCount getTicketsCountForOrganization(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/organizations/{id}/tickets/count.json").set("id", id)), this.handle(TicketCount.class, COUNT, new Class[0])));
    }

    public TicketCount getCcdTicketsCountForUser(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}/tickets/ccd/count.json").set("id", id)), this.handle(TicketCount.class, COUNT, new Class[0])));
    }

    public TicketCount getAssignedTicketsCountForUser(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}/tickets/assigned/count.json").set("id", id)), this.handle(TicketCount.class, COUNT, new Class[0])));
    }

    public Ticket getTicket(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{id}.json").set("id", id)), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public Iterable<Ticket> getTicketIncidents(long id) {
        return new PagedIterable<Ticket>(this.cbp("/tickets/{id}/incidents.json").set("id", id), this.handleList(Ticket.class, "tickets"));
    }

    public List<User> getTicketCollaborators(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{id}/collaborators.json").set("id", id)), this.handleList(User.class, "users")));
    }

    public Iterable<DeletedTicket> getDeletedTickets() {
        return new PagedIterable<DeletedTicket>(this.cbp("/deleted_tickets.json"), this.handleList(DeletedTicket.class, "deleted_tickets"));
    }

    public Iterable<DeletedTicket> getDeletedTickets(String sortBy, SortOrder sortOrder) {
        return new PagedIterable<DeletedTicket>(this.tmpl("/deleted_tickets.json?sort_by={sortBy}&sort_order={sortOrder}").set("sortBy", sortBy).set("sortOrder", sortOrder.getQueryParameter()), this.handleList(DeletedTicket.class, "deleted_tickets"));
    }

    public void deleteTicket(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        this.deleteTicket(ticket.getId());
    }

    public void deleteTicket(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/tickets/{id}.json").set("id", id)), this.handleStatus()));
    }

    public JobStatus permanentlyDeleteTicket(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        return this.permanentlyDeleteTicket(ticket.getId());
    }

    public JobStatus permanentlyDeleteTicket(long id) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/deleted_tickets/{id}.json").set("id", id)), this.handleJobStatus()));
    }

    public ListenableFuture<JobStatus> queueCreateTicketAsync(Ticket ticket) {
        return this.submit(this.req("POST", this.cnst("/tickets.json?async=true"), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handleJobStatus());
    }

    public ListenableFuture<Ticket> createTicketAsync(Ticket ticket) {
        return this.submit(this.req("POST", this.cnst("/tickets.json"), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handle(Ticket.class, "ticket", new Class[0]));
    }

    public Ticket createTicket(Ticket ticket) {
        return Zendesk.complete(this.createTicketAsync(ticket));
    }

    public JobStatus createTickets(Ticket ... tickets) {
        return this.createTickets(Arrays.asList(tickets));
    }

    public JobStatus createTickets(List<Ticket> tickets) {
        return Zendesk.complete(this.createTicketsAsync(tickets));
    }

    public ListenableFuture<JobStatus> createTicketsAsync(List<Ticket> tickets) {
        return this.submit(this.req("POST", this.cnst("/tickets/create_many.json"), JSON, this.json(Collections.singletonMap("tickets", tickets))), this.handleJobStatus());
    }

    public Ticket updateTicket(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}.json").set("id", ticket.getId()), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public JobStatus updateTickets(Ticket ... tickets) {
        return this.updateTickets(Arrays.asList(tickets));
    }

    public JobStatus updateTickets(List<Ticket> tickets) {
        return Zendesk.complete(this.updateTicketsAsync(tickets));
    }

    public ListenableFuture<JobStatus> updateTicketsAsync(List<Ticket> tickets) {
        return this.submit(this.req("PUT", this.cnst("/tickets/update_many.json"), JSON, this.json(Collections.singletonMap("tickets", tickets))), this.handleJobStatus());
    }

    public void markTicketAsSpam(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        this.markTicketAsSpam(ticket.getId());
    }

    public void markTicketAsSpam(long id) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}/mark_as_spam.json").set("id", id)), this.handleStatus()));
    }

    public JobStatus deleteTickets(long id, long ... ids) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/tickets/destroy_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleJobStatus()));
    }

    public JobStatus permanentlyDeleteTickets(long id, long ... ids) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/deleted_tickets/destroy_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleJobStatus()));
    }

    public Iterable<Ticket> getTickets() {
        return new PagedIterable<Ticket>(this.cbp("/tickets.json"), this.handleList(Ticket.class, "tickets"));
    }

    @Deprecated
    public Iterable<Ticket> getTicketsByStatus(Status ... ticketStatus) {
        return new PagedIterable<Ticket>(this.tmpl("/tickets.json{?status}").set("status", Zendesk.statusArray(ticketStatus)), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getTicketsByExternalId(String externalId, boolean includeArchived) {
        PagedIterable<Ticket> results = new PagedIterable<Ticket>(this.tmpl("/tickets.json{?external_id}").set("external_id", externalId), this.handleList(Ticket.class, "tickets"));
        if (!includeArchived || results.iterator().hasNext()) {
            return results;
        }
        return new PagedIterable<Ticket>(this.tmpl("/search.json{?query}{&type}").set("query", "external_id:" + externalId).set("type", "ticket"), this.handleList(Ticket.class, "results"));
    }

    public Iterable<Ticket> getTicketsByExternalId(String externalId) {
        return this.getTicketsByExternalId(externalId, false);
    }

    public Iterable<Ticket> getTicketsFromSearch(String searchTerm) {
        return new PagedIterable<Ticket>(this.tmpl("/search.json{?query}").set("query", searchTerm + " type:ticket"), this.handleList(Ticket.class, "results"));
    }

    public Iterable<Article> getArticleFromSearch(String searchTerm) {
        return new PagedIterable<Article>(this.tmpl("/help_center/articles/search.json{?query}").set("query", searchTerm), this.handleList(Article.class, "results"));
    }

    public Iterable<Article> getArticleFromSearch(String searchTerm, Long sectionId) {
        return new PagedIterable<Article>(this.tmpl("/help_center/articles/search.json{?section,query}").set("query", searchTerm).set("section", sectionId), this.handleList(Article.class, "results"));
    }

    public Iterable<Article> getArticlesFromAnyLabels(List<String> labels) {
        return new PagedIterable<Article>(this.tmpl("/help_center/articles/search.json{?label_names}").set("label_names", labels), this.handleList(Article.class, "results"));
    }

    public Iterable<Article> getArticlesFromAllLabels(List<String> labels) {
        return new PagedIterable<Article>(this.tmpl("/help_center/en-us/articles.json{?label_names}").set("label_names", labels), this.handleList(Article.class, "articles"));
    }

    public List<ArticleAttachments> getAttachmentsFromArticle(Long articleID) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/articles/{id}/attachments.json").set("id", articleID)), this.handleArticleAttachmentsList("article_attachments")));
    }

    public List<Ticket> getTickets(long id, long ... ids) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/show_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleList(Ticket.class, "tickets")));
    }

    public Iterable<Ticket> getRecentTickets() {
        return new PagedIterable<Ticket>(this.cnst("/tickets/recent.json"), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getTicketsIncrementally(Date startTime) {
        return new PagedIterable<Ticket>(this.tmpl("/incremental/tickets.json{?start_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())), this.handleIncrementalList(Ticket.class, "tickets"));
    }

    @Deprecated
    public Iterable<Ticket> getTicketsIncrementally(Date startTime, Date endTime) {
        return new PagedIterable<Ticket>(this.tmpl("/incremental/tickets.json{?start_time,end_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())).set(END_TIME, Zendesk.msToSeconds(endTime.getTime())), this.handleIncrementalList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getOrganizationTickets(long organizationId) {
        return new PagedIterable<Ticket>(this.tmpl("/organizations/{organizationId}/tickets.json").set("organizationId", organizationId), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Request> getOrganizationRequests(long organizationId) {
        return new PagedIterable<Request>(this.tmpl("/organizations/{organizationId}/requests.json").set("organizationId", organizationId), this.handleList(Request.class, "requests"));
    }

    public Iterable<Ticket> getUserRequestedTickets(long userId) {
        return new PagedIterable<Ticket>(this.tmpl("/users/{userId}/tickets/requested.json").set("userId", userId), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<ComplianceDeletionStatus> getComplianceDeletionStatuses(long userId) {
        return new PagedIterable<ComplianceDeletionStatus>(this.tmpl("/users/{userId}/compliance_deletion_statuses.json").set("userId", userId), this.handleList(ComplianceDeletionStatus.class, "compliance_deletion_statuses"));
    }

    public Iterable<CustomTicketStatus> getCustomTicketStatuses() {
        return new PagedIterable<CustomTicketStatus>(this.tmpl("/custom_statuses.json"), this.handleList(CustomTicketStatus.class, "custom_statuses"));
    }

    public Iterable<Ticket> getUserCCDTickets(long userId) {
        return new PagedIterable<Ticket>(this.tmpl("/users/{userId}/tickets/ccd.json").set("userId", userId), this.handleList(Ticket.class, "tickets"));
    }

    public UserRelatedInfo getUserRelatedInfo(long userId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{userId}/related.json").set("userId", userId)), this.handle(UserRelatedInfo.class, "user_related", new Class[0])));
    }

    public Iterable<Metric> getTicketMetrics() {
        return new PagedIterable<Metric>(this.cbp("/ticket_metrics.json"), this.handleList(Metric.class, "ticket_metrics"));
    }

    public Metric getTicketMetricByTicket(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{ticketId}/metrics.json").set("ticketId", id)), this.handle(Metric.class, "ticket_metric", new Class[0])));
    }

    public Metric getTicketMetric(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/ticket_metrics/{ticketMetricId}.json").set("ticketMetricId", id)), this.handle(Metric.class, "ticket_metric", new Class[0])));
    }

    public Iterable<Audit> getTicketAudits(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        return this.getTicketAudits(ticket.getId());
    }

    public Iterable<Audit> getTicketAudits(Long id) {
        return new PagedIterable<Audit>(this.cbp("/tickets/{ticketId}/audits.json").set("ticketId", id), this.handleList(Audit.class, "audits"));
    }

    public Audit getTicketAudit(Ticket ticket, Audit audit) {
        Zendesk.checkHasId(audit);
        return this.getTicketAudit(ticket, (long)audit.getId());
    }

    public Audit getTicketAudit(Ticket ticket, long id) {
        Zendesk.checkHasId(ticket);
        return this.getTicketAudit(ticket.getId(), id);
    }

    public Audit getTicketAudit(long ticketId, long auditId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{ticketId}/audits/{auditId}.json").set("ticketId", ticketId).set("auditId", auditId)), this.handle(Audit.class, "audit", new Class[0])));
    }

    public void trustTicketAudit(Ticket ticket, Audit audit) {
        Zendesk.checkHasId(audit);
        this.trustTicketAudit(ticket, (long)audit.getId());
    }

    public void trustTicketAudit(Ticket ticket, long id) {
        Zendesk.checkHasId(ticket);
        this.trustTicketAudit(ticket.getId(), id);
    }

    public void trustTicketAudit(long ticketId, long auditId) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{ticketId}/audits/{auditId}/trust.json").set("ticketId", ticketId).set("auditId", auditId)), this.handleStatus()));
    }

    public void makePrivateTicketAudit(Ticket ticket, Audit audit) {
        Zendesk.checkHasId(audit);
        this.makePrivateTicketAudit(ticket, (long)audit.getId());
    }

    public void makePrivateTicketAudit(Ticket ticket, long id) {
        Zendesk.checkHasId(ticket);
        this.makePrivateTicketAudit(ticket.getId(), id);
    }

    public void makePrivateTicketAudit(long ticketId, long auditId) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{ticketId}/audits/{auditId}/make_private.json").set("ticketId", ticketId).set("auditId", auditId)), this.handleStatus()));
    }

    public Iterable<Field> getTicketFields() {
        return new PagedIterable<Field>(this.cbp("/ticket_fields.json"), this.handleList(Field.class, "ticket_fields"));
    }

    public Field getTicketField(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/ticket_fields/{id}.json").set("id", id)), this.handle(Field.class, "ticket_field", new Class[0])));
    }

    public Field createTicketField(Field field) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/ticket_fields.json"), JSON, this.json(Collections.singletonMap("ticket_field", field))), this.handle(Field.class, "ticket_field", new Class[0])));
    }

    public Field updateTicketField(Field field) {
        Zendesk.checkHasId(field);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/ticket_fields/{id}.json").set("id", field.getId()), JSON, this.json(Collections.singletonMap("ticket_field", field))), this.handle(Field.class, "ticket_field", new Class[0])));
    }

    public void deleteTicketField(Field field) {
        Zendesk.checkHasId(field);
        this.deleteTicket(field.getId());
    }

    public void deleteTicketField(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/ticket_fields/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<SuspendedTicket> getSuspendedTickets() {
        return new PagedIterable<SuspendedTicket>(this.cbp("/suspended_tickets.json"), this.handleList(SuspendedTicket.class, "suspended_tickets"));
    }

    public Iterable<Ticket> recoverSuspendedTickets(List<SuspendedTicket> tickets) {
        if (100 < tickets.size()) {
            throw new IllegalArgumentException("This endpoint accepts up to 100 tickets. Provided " + tickets.size() + " tickets.\nhttps://developer.zendesk.com/rest_api/docs/support/suspended_tickets#recover-multiple-suspended-tickets");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (SuspendedTicket ticket : tickets) {
            ids.add(ticket.getId());
        }
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/suspended_tickets/recover_many.json{?ids}").set("ids", ids)), this.handleList(Ticket.class, "tickets")));
    }

    public void deleteSuspendedTicket(SuspendedTicket ticket) {
        Zendesk.checkHasId(ticket);
        this.deleteSuspendedTicket(ticket.getId());
    }

    public void deleteSuspendedTicket(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/suspended_tickets/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Attachment.Upload createUpload(String fileName, byte[] content) {
        return this.createUpload(null, fileName, "application/binary", content);
    }

    public Attachment.Upload createUpload(String fileName, String contentType, byte[] content) {
        return this.createUpload(null, fileName, contentType, content);
    }

    public Attachment.Upload createUpload(String token, String fileName, String contentType, byte[] content) {
        TemplateUri uri = this.tmpl("/uploads.json{?filename,token}").set("filename", fileName);
        if (token != null) {
            uri.set("token", token);
        }
        return Zendesk.complete(this.submit(this.req("POST", uri, contentType, content), this.handle(Attachment.Upload.class, "upload", new Class[0])));
    }

    public void associateAttachmentsToArticle(String idArticle, List<Attachment> attachments) {
        TemplateUri uri = this.tmpl("/help_center/articles/{article_id}/bulk_attachments.json").set("article_id", idArticle);
        ArrayList<Long> attachmentsIds = new ArrayList<Long>();
        for (Attachment item : attachments) {
            attachmentsIds.add(item.getId());
        }
        Zendesk.complete(this.submit(this.req("POST", uri, JSON, this.json(Collections.singletonMap("attachment_ids", attachmentsIds))), this.handleStatus()));
    }

    public ArticleAttachments createUploadArticle(long articleId, File file) throws IOException {
        return this.createUploadArticle(articleId, file, false);
    }

    public ArticleAttachments createUploadArticle(long articleId, File file, boolean inline) throws IOException {
        RequestBuilder builder = this.reqBuilder("POST", this.tmpl("/help_center/articles/{id}/attachments.json").set("id", articleId).toString());
        builder.setHeader((CharSequence)"Content-Type", "multipart/form-data");
        if (inline) {
            builder.addBodyPart((Part)new StringPart("inline", "true"));
        }
        builder.addBodyPart((Part)new FilePart("file", file, "application/octet-stream", StandardCharsets.UTF_8, file.getName()));
        org.asynchttpclient.Request req = builder.build();
        return Zendesk.complete(this.submit(req, this.handle(ArticleAttachments.class, "article_attachment", new Class[0])));
    }

    public void deleteUpload(Attachment.Upload upload) {
        Zendesk.checkHasToken(upload);
        this.deleteUpload(upload.getToken());
    }

    public void deleteUpload(String token) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/uploads/{token}.json").set("token", token)), this.handleStatus()));
    }

    public Attachment getAttachment(Attachment attachment) {
        Zendesk.checkHasId(attachment);
        return this.getAttachment(attachment.getId());
    }

    public Attachment getAttachment(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/attachments/{id}.json").set("id", id)), this.handle(Attachment.class, "attachment", new Class[0])));
    }

    public void deleteAttachment(Attachment attachment) {
        Zendesk.checkHasId(attachment);
        this.deleteAttachment(attachment.getId());
    }

    public void deleteAttachment(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/attachments/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<Target> getTargets() {
        return new PagedIterable<Target>(this.cnst("/targets.json"), this.handleTargetList("targets"));
    }

    public Target getTarget(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/targets/{id}.json").set("id", id)), this.handle(Target.class, "target", new Class[0])));
    }

    public Target createTarget(Target target) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/targets.json"), JSON, this.json(Collections.singletonMap("target", target))), this.handle(Target.class, "target", new Class[0])));
    }

    public void deleteTarget(long targetId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/targets/{id}.json").set("id", targetId)), this.handleStatus()));
    }

    public Iterable<Trigger> getTriggers() {
        return new PagedIterable<Trigger>(this.cbp("/triggers.json"), this.handleList(Trigger.class, "triggers"));
    }

    public Iterable<Trigger> getTriggers(String categoryId, boolean active, String sortBy, SortOrder sortOrder) {
        return new PagedIterable<Trigger>(this.tmpl("/triggers.json{?category_id,active,sort_by,sort_order}").set("category_id", categoryId).set("active", active).set("sort_by", sortBy).set("sort_order", sortOrder.getQueryParameter()), this.handleList(Trigger.class, "triggers"));
    }

    public Iterable<Trigger> getActiveTriggers() {
        return new PagedIterable<Trigger>(this.cbp("/triggers/active.json"), this.handleList(Trigger.class, "triggers"));
    }

    public Iterable<Trigger> searchTriggers(String query) {
        return new PagedIterable<Trigger>(this.tmpl("/triggers/search.json{?query}").set("query", query), this.handleList(Trigger.class, "triggers"));
    }

    public Iterable<Trigger> searchTriggers(String query, boolean active, String sortBy, SortOrder sortOrder) {
        return new PagedIterable<Trigger>(this.tmpl("/triggers/search.json{?query,active,sort_by,sort_order}").set("query", query).set("active", active).set("sort_by", sortBy).set("sort_order", sortOrder.getQueryParameter()), this.handleList(Trigger.class, "triggers"));
    }

    public Trigger getTrigger(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/triggers/{id}.json").set("id", id)), this.handle(Trigger.class, "trigger", new Class[0])));
    }

    public Trigger createTrigger(Trigger trigger) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/triggers.json"), JSON, this.json(Collections.singletonMap("trigger", trigger))), this.handle(Trigger.class, "trigger", new Class[0])));
    }

    public Trigger updateTrigger(Long triggerId, Trigger trigger) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/triggers/{id}.json").set("id", triggerId), JSON, this.json(Collections.singletonMap("trigger", trigger))), this.handle(Trigger.class, "trigger", new Class[0])));
    }

    public void deleteTrigger(long triggerId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/triggers/{id}.json").set("id", triggerId)), this.handleStatus()));
    }

    public Iterable<View> getViews() {
        return new PagedIterable<View>(this.cbp("/views.json"), this.handleList(View.class, "views"));
    }

    public Iterable<Ticket> getView(long id) {
        return new PagedIterable<Ticket>(this.tmpl("/views/{id}/tickets.json").set("id", id), this.handleList(Ticket.class, "tickets"));
    }

    public <V extends ViewRow> Optional<ExecutedViewPage<V>> executeView(long id, Class<V> clazz) {
        ObjectReader objectReader = this.mapper.readerFor(this.mapper.getTypeFactory().constructParametricType(ExecutedViewPage.class, new Class[]{clazz}));
        return Optional.of((ExecutedViewPage)Zendesk.complete(this.submit(this.req("GET", this.tmpl("/views/{id}/execute.json").set("id", id)), this.handle(objectReader))));
    }

    public Iterable<Automation> getAutomations() {
        return new PagedIterable<Automation>(this.cbp("/automations.json"), this.handleList(Automation.class, "automations"));
    }

    public Automation getAutomation(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/automations/{id}.json").set("id", id)), this.handle(Automation.class, "automation", new Class[0])));
    }

    public Automation createAutomation(Automation automation) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/automations.json"), JSON, this.json(Collections.singletonMap("automation", automation))), this.handle(Automation.class, "automation", new Class[0])));
    }

    public Automation updateAutomation(Long automationId, Automation automation) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/automations/{id}.json").set("id", automationId), JSON, this.json(Collections.singletonMap("automation", automation))), this.handle(Automation.class, "automation", new Class[0])));
    }

    public void deleteAutomation(long automationId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/automations/{id}.json").set("id", automationId)), this.handleStatus()));
    }

    public Iterable<TwitterMonitor> getTwitterMonitors() {
        return new PagedIterable<TwitterMonitor>(this.cnst("/channels/twitter/monitored_twitter_handles.json"), this.handleList(TwitterMonitor.class, "monitored_twitter_handles"));
    }

    public Iterable<User> getUsers() {
        return new PagedIterable<User>(this.cbp("/users.json"), this.handleList(User.class, "users"));
    }

    public Iterable<User> getUsersByRole(String role, String ... roles) {
        StringBuilder uriBuilder = new StringBuilder("/users.json?page[size]=").append(this.cbpPageSize);
        if (roles.length == 0) {
            uriBuilder.append("&role=").append(Zendesk.encodeUrl(role));
        } else {
            uriBuilder.append("&role[]=").append(Zendesk.encodeUrl(role));
        }
        for (String curRole : roles) {
            uriBuilder.append("&role[]=").append(Zendesk.encodeUrl(curRole));
        }
        return new PagedIterable<User>(this.cnst(uriBuilder.toString()), this.handleList(User.class, "users"));
    }

    public List<User> getUsers(long id, long ... ids) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/show_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleList(User.class, "users")));
    }

    @Deprecated
    public List<User> getUsersByExternalIds(long externalId, long ... externalIds) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/show_many.json{?external_ids}").set("external_ids", Zendesk.idArray(externalId, externalIds))), this.handleList(User.class, "users")));
    }

    public List<User> getUsersByExternalIds(String externalId, String ... externalIds) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/show_many.json{?external_ids}").set("external_ids", Zendesk.idArray(externalId, externalIds))), this.handleList(User.class, "users")));
    }

    public Iterable<User> getUsersIncrementally(Date startTime) {
        return new PagedIterable<User>(this.tmpl("/incremental/users.json{?start_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())), this.handleIncrementalList(User.class, "users"));
    }

    public Iterable<User> getGroupUsers(long id) {
        return new PagedIterable<User>(this.cbp("/groups/{id}/users.json").set("id", id), this.handleList(User.class, "users"));
    }

    public Iterable<User> getOrganizationUsers(long id) {
        return new PagedIterable<User>(this.cbp("/organizations/{id}/users.json").set("id", id), this.handleList(User.class, "users"));
    }

    public User getUser(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}.json").set("id", id)), this.handle(User.class, "user", new Class[0])));
    }

    public User getAuthenticatedUser() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/users/me.json")), this.handle(User.class, "user", new Class[0])));
    }

    public Iterable<UserField> getUserFields() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/user_fields.json")), this.handleList(UserField.class, "user_fields")));
    }

    public User createUser(User user) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/users.json"), JSON, this.json(Collections.singletonMap("user", user))), this.handle(User.class, "user", new Class[0])));
    }

    public User mergeUsers(long userIdThatWillRemain, long userIdThatWillBeMerged) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{id}/merge.json").set("id", userIdThatWillBeMerged), JSON, this.json(Collections.singletonMap("user", Collections.singletonMap("id", userIdThatWillRemain)))), this.handle(User.class, "user", new Class[0])));
    }

    public JobStatus createUsers(User ... users) {
        return this.createUsers(Arrays.asList(users));
    }

    public JobStatus createUsers(List<User> users) {
        return Zendesk.complete(this.createUsersAsync(users));
    }

    public ListenableFuture<JobStatus> createUsersAsync(List<User> users) {
        return this.submit(this.req("POST", this.cnst("/users/create_many.json"), JSON, this.json(Collections.singletonMap("users", users))), this.handleJobStatus());
    }

    public User createOrUpdateUser(User user) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/users/create_or_update.json"), JSON, this.json(Collections.singletonMap("user", user))), this.handle(User.class, "user", new Class[0])));
    }

    public JobStatus createOrUpdateUsers(User ... users) {
        return this.createOrUpdateUsers(Arrays.asList(users));
    }

    public JobStatus createOrUpdateUsers(List<User> users) {
        return Zendesk.complete(this.createOrUpdateUsersAsync(users));
    }

    public ListenableFuture<JobStatus> createOrUpdateUsersAsync(List<User> users) {
        return this.submit(this.req("POST", this.cnst("/users/create_or_update_many.json"), JSON, this.json(Collections.singletonMap("users", users))), this.handleJobStatus());
    }

    public User updateUser(User user) {
        Zendesk.checkHasId(user);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{id}.json").set("id", user.getId()), JSON, this.json(Collections.singletonMap("user", user))), this.handle(User.class, "user", new Class[0])));
    }

    public JobStatus updateUsers(User ... users) {
        return this.updateUsers(Arrays.asList(users));
    }

    public JobStatus updateUsers(List<User> users) {
        return Zendesk.complete(this.updateUsersAsync(users));
    }

    public ListenableFuture<JobStatus> updateUsersAsync(List<User> users) {
        return this.submit(this.req("PUT", this.cnst("/users/update_many.json"), JSON, this.json(Collections.singletonMap("users", users))), this.handleJobStatus());
    }

    public void deleteUser(User user) {
        Zendesk.checkHasId(user);
        this.deleteUser(user.getId());
    }

    public void deleteUser(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{id}.json").set("id", id)), this.handleStatus()));
    }

    public JobStatus deleteUsers(long ... ids) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/destroy_many.json{?ids}").set("ids", ids)), this.handleJobStatus()));
    }

    public User permanentlyDeleteUser(User user) {
        Zendesk.checkHasId(user);
        return this.permanentlyDeleteUser(user.getId());
    }

    public User permanentlyDeleteUser(long id) {
        this.deleteUser(id);
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/deleted_users/{id}.json").set("id", id)), this.handle(User.class)));
    }

    public User suspendUser(long id) {
        User user = new User();
        user.setId(id);
        user.setSuspended(true);
        return this.updateUser(user);
    }

    public User unsuspendUser(long id) {
        User user = new User();
        user.setId(id);
        user.setSuspended(false);
        return this.updateUser(user);
    }

    public Iterable<User> lookupUserByEmail(String email) {
        return new PagedIterable<User>(this.tmpl("/users/search.json{?query}").set("query", email), this.handleList(User.class, "users"));
    }

    public Iterable<User> lookupUserByExternalId(String externalId) {
        return new PagedIterable<User>(this.tmpl("/users/search.json{?external_id}").set("external_id", externalId), this.handleList(User.class, "users"));
    }

    public User getCurrentUser() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/users/me.json")), this.handle(User.class, "user", new Class[0])));
    }

    public void resetUserPassword(User user, String password) {
        Zendesk.checkHasId(user);
        this.resetUserPassword(user.getId(), password);
    }

    public void resetUserPassword(long id, String password) {
        Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{id}/password.json").set("id", id), JSON, this.json(Collections.singletonMap("password", password))), this.handleStatus()));
    }

    public void changeUserPassword(User user, String oldPassword, String newPassword) {
        Zendesk.checkHasId(user);
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("previous_password", oldPassword);
        req.put("password", newPassword);
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{id}/password.json").set("id", user.getId()), JSON, this.json(req)), this.handleStatus()));
    }

    public List<Identity> getUserIdentities(User user) {
        Zendesk.checkHasId(user);
        return this.getUserIdentities(user.getId());
    }

    public List<Identity> getUserIdentities(long userId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}/identities.json").set("id", userId)), this.handleList(Identity.class, "identities")));
    }

    public Identity getUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.getUserIdentity(user, (long)identity.getId());
    }

    public Identity getUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.getUserIdentity(user.getId(), identityId);
    }

    public Identity getUserIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{userId}/identities/{identityId}.json").set("userId", userId).set("identityId", identityId)), this.handle(Identity.class, "identity", new Class[0])));
    }

    public List<Identity> setUserPrimaryIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.setUserPrimaryIdentity(user, (long)identity.getId());
    }

    public List<Identity> setUserPrimaryIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.setUserPrimaryIdentity(user.getId(), identityId);
    }

    public List<Identity> setUserPrimaryIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}/make_primary.json").set("userId", userId).set("identityId", identityId), JSON, null), this.handleList(Identity.class, "identities")));
    }

    public Identity verifyUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.verifyUserIdentity(user, (long)identity.getId());
    }

    public Identity verifyUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.verifyUserIdentity(user.getId(), identityId);
    }

    public Identity verifyUserIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}/verify.json").set("userId", userId).set("identityId", identityId), JSON, null), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Identity requestVerifyUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.requestVerifyUserIdentity(user, (long)identity.getId());
    }

    public Identity requestVerifyUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.requestVerifyUserIdentity(user.getId(), identityId);
    }

    public Identity requestVerifyUserIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}/request_verification.json").set("userId", userId).set("identityId", identityId), JSON, null), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Identity updateUserIdentity(long userId, Identity identity) {
        Zendesk.checkHasId(identity);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}.json").set("userId", userId).set("identityId", identity.getId()), JSON, this.json(Collections.singletonMap("identity", identity))), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Identity updateUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(user);
        return this.updateUserIdentity(user.getId(), identity);
    }

    public void deleteUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        this.deleteUserIdentity(user, (long)identity.getId());
    }

    public void deleteUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        this.deleteUserIdentity(user.getId(), identityId);
    }

    public void deleteUserIdentity(long userId, long identityId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{userId}/identities/{identityId}.json").set("userId", userId).set("identityId", identityId)), this.handleStatus()));
    }

    public Identity createUserIdentity(long userId, Identity identity) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{userId}/identities.json").set("userId", userId), JSON, this.json(Collections.singletonMap("identity", identity))), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Identity createUserIdentity(User user, Identity identity) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{userId}/identities.json").set("userId", user.getId()), JSON, this.json(Collections.singletonMap("identity", identity))), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Iterable<AgentRole> getCustomAgentRoles() {
        return new PagedIterable<AgentRole>(this.cnst("/custom_roles.json"), this.handleList(AgentRole.class, "custom_roles"));
    }

    public Iterable<Request> getRequests() {
        return new PagedIterable<Request>(this.cbp("/requests.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getOpenRequests() {
        return new PagedIterable<Request>(this.cbp("/requests/open.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getSolvedRequests() {
        return new PagedIterable<Request>(this.cbp("/requests/solved.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getCCRequests() {
        return new PagedIterable<Request>(this.cnst("/requests/ccd.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getUserRequests(User user) {
        Zendesk.checkHasId(user);
        return this.getUserRequests(user.getId());
    }

    public Iterable<Request> getUserRequests(long id) {
        return new PagedIterable<Request>(this.tmpl("/users/{id}/requests.json").set("id", id), this.handleList(Request.class, "requests"));
    }

    public Request getRequest(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/requests/{id}.json").set("id", id)), this.handle(Request.class, "request", new Class[0])));
    }

    public Request createRequest(Request request) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/requests.json"), JSON, this.json(Collections.singletonMap("request", request))), this.handle(Request.class, "request", new Class[0])));
    }

    public Request updateRequest(Request request) {
        Zendesk.checkHasId(request);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/requests/{id}.json").set("id", request.getId()), JSON, this.json(Collections.singletonMap("request", request))), this.handle(Request.class, "request", new Class[0])));
    }

    public Iterable<Comment> getRequestComments(Request request) {
        Zendesk.checkHasId(request);
        return this.getRequestComments(request.getId());
    }

    public Iterable<Comment> getRequestComments(long id) {
        return new PagedIterable<Comment>(this.cbp("/requests/{id}/comments.json").set("id", id), this.handleList(Comment.class, "comments"));
    }

    public Iterable<Comment> getTicketComments(long id) {
        return this.getTicketComments(id, SortOrder.ASCENDING);
    }

    public Iterable<Comment> getTicketComments(long id, SortOrder order) {
        return new PagedIterable<Comment>(this.tmpl("/tickets/{id}/comments.json?sort_order={order}").set("id", id).set("order", order.getQueryParameter()), this.handleList(Comment.class, "comments"));
    }

    public Comment getRequestComment(Request request, Comment comment) {
        Zendesk.checkHasId(comment);
        return this.getRequestComment(request, (long)comment.getId());
    }

    public Comment getRequestComment(Request request, long commentId) {
        Zendesk.checkHasId(request);
        return this.getRequestComment(request.getId(), commentId);
    }

    public Comment getRequestComment(long requestId, long commentId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/requests/{requestId}/comments/{commentId}.json").set("requestId", requestId).set("commentId", commentId)), this.handle(Comment.class, "comment", new Class[0])));
    }

    public Ticket createComment(long ticketId, Comment comment) {
        Ticket ticket = new Ticket();
        ticket.setComment(comment);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}.json").set("id", ticketId), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public Ticket createTicketFromTweet(long tweetId, long monitorId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("twitter_status_message_id", tweetId);
        map.put("monitored_twitter_handle_id", monitorId);
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/channels/twitter/tickets.json"), JSON, this.json(Collections.singletonMap("ticket", map))), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public Iterable<Organization> getOrganizations() {
        return new PagedIterable<Organization>(this.cbp("/organizations.json"), this.handleList(Organization.class, "organizations"));
    }

    public List<Organization> getOrganizations(long id, long ... ids) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/organizations/show_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleList(Organization.class, "organizations")));
    }

    public Iterable<Organization> getOrganizationsIncrementally(Date startTime) {
        return new PagedIterable<Organization>(this.tmpl("/incremental/organizations.json{?start_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())), this.handleIncrementalList(Organization.class, "organizations"));
    }

    public Iterable<OrganizationField> getOrganizationFields() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/organization_fields.json")), this.handleList(OrganizationField.class, "organization_fields")));
    }

    public Iterable<Organization> getAutoCompleteOrganizations(String name) {
        if (name == null || name.length() < 2) {
            throw new IllegalArgumentException("Name must be at least 2 characters long");
        }
        return new PagedIterable<Organization>(this.tmpl("/organizations/autocomplete.json{?name}").set("name", name), this.handleList(Organization.class, "organizations"));
    }

    public Organization getOrganization(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/organizations/{id}.json").set("id", id)), this.handle(Organization.class, "organization", new Class[0])));
    }

    public Organization createOrganization(Organization organization) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/organizations.json"), JSON, this.json(Collections.singletonMap("organization", organization))), this.handle(Organization.class, "organization", new Class[0])));
    }

    public JobStatus createOrganizations(Organization ... organizations) {
        return this.createOrganizations(Arrays.asList(organizations));
    }

    public JobStatus createOrganizations(List<Organization> organizations) {
        return Zendesk.complete(this.createOrganizationsAsync(organizations));
    }

    public ListenableFuture<JobStatus> createOrganizationsAsync(List<Organization> organizations) {
        return this.submit(this.req("POST", this.cnst("/organizations/create_many.json"), JSON, this.json(Collections.singletonMap("organizations", organizations))), this.handleJobStatus());
    }

    public Organization createOrUpdateOrganization(Organization organization) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/organizations/create_or_update.json"), JSON, this.json(Collections.singletonMap("organization", organization))), this.handle(Organization.class, "organization", new Class[0])));
    }

    public Organization updateOrganization(Organization organization) {
        Zendesk.checkHasId(organization);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/organizations/{id}.json").set("id", organization.getId()), JSON, this.json(Collections.singletonMap("organization", organization))), this.handle(Organization.class, "organization", new Class[0])));
    }

    public JobStatus updateOrganizations(Organization ... organizations) {
        return this.updateOrganizations(Arrays.asList(organizations));
    }

    public JobStatus updateOrganizations(List<Organization> organizations) {
        return Zendesk.complete(this.updateOrganizationsAsync(organizations));
    }

    public ListenableFuture<JobStatus> updateOrganizationsAsync(List<Organization> organizations) {
        return this.submit(this.req("PUT", this.cnst("/organizations/update_many.json"), JSON, this.json(Collections.singletonMap("organizations", organizations))), this.handleJobStatus());
    }

    public void deleteOrganization(Organization organization) {
        Zendesk.checkHasId(organization);
        this.deleteOrganization(organization.getId());
    }

    public void deleteOrganization(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/organizations/{id}.json").set("id", id)), this.handleStatus()));
    }

    public JobStatus deleteOrganizations(long ... ids) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/organizations/destroy_many.json{?ids}").set("ids", ids)), this.handleJobStatus()));
    }

    public Iterable<Organization> lookupOrganizationsByExternalId(String externalId) {
        if (externalId == null || externalId.length() == 0) {
            throw new IllegalArgumentException("External ID must not be null or length 0");
        }
        return new PagedIterable<Organization>(this.tmpl("/organizations/search.json{?external_id}").set("external_id", externalId), this.handleList(Organization.class, "organizations"));
    }

    public Iterable<OrganizationMembership> getOrganizationMemberships() {
        return new PagedIterable<OrganizationMembership>(this.cbp("/organization_memberships.json"), this.handleList(OrganizationMembership.class, "organization_memberships"));
    }

    public Iterable<OrganizationMembership> getOrganizationMembershipsForOrg(long organization_id) {
        return new PagedIterable<OrganizationMembership>(this.cbp("/organizations/{organization_id}/organization_memberships.json").set("organization_id", organization_id), this.handleList(OrganizationMembership.class, "organization_memberships"));
    }

    public Iterable<OrganizationMembership> getOrganizationMembershipsForUser(long user_id) {
        return new PagedIterable<OrganizationMembership>(this.cbp("/users/{user_id}/organization_memberships.json").set("user_id", user_id), this.handleList(OrganizationMembership.class, "organization_memberships"));
    }

    public OrganizationMembership getOrganizationMembershipForUser(long user_id, long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{user_id}/organization_memberships/{id}.json").set("user_id", user_id).set("id", id)), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public OrganizationMembership getOrganizationMembership(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/organization_memberships/{id}.json").set("id", id)), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public OrganizationMembership createOrganizationMembership(OrganizationMembership organizationMembership) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/organization_memberships.json"), JSON, this.json(Collections.singletonMap("organization_membership", organizationMembership))), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public JobStatus createOrganizationMemberships(OrganizationMembership ... organizationMemberships) {
        return this.createOrganizationMemberships(Arrays.asList(organizationMemberships));
    }

    public JobStatus createOrganizationMemberships(List<OrganizationMembership> organizationMemberships) {
        return Zendesk.complete(this.createOrganizationMembershipsAsync(organizationMemberships));
    }

    public ListenableFuture<JobStatus> createOrganizationMembershipsAsync(List<OrganizationMembership> organizationMemberships) {
        return this.submit(this.req("POST", this.cnst("/organization_memberships/create_many.json"), JSON, this.json(Collections.singletonMap("organization_memberships", organizationMemberships))), this.handleJobStatus());
    }

    public void deleteOrganizationMembership(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/organization_memberships/{id}.json").set("id", id)), this.handleStatus()));
    }

    public void deleteOrganizationMemberships(long id, long ... ids) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/organization_memberships/destroy_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleStatus()));
    }

    public Iterable<Group> getGroups() {
        return new PagedIterable<Group>(this.cbp("/groups.json"), this.handleList(Group.class, "groups"));
    }

    public Iterable<Group> getAssignableGroups() {
        return new PagedIterable<Group>(this.cbp("/groups/assignable.json"), this.handleList(Group.class, "groups"));
    }

    public Group getGroup(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/groups/{id}.json").set("id", id)), this.handle(Group.class, "group", new Class[0])));
    }

    public Group createGroup(Group group) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/groups.json"), JSON, this.json(Collections.singletonMap("group", group))), this.handle(Group.class, "group", new Class[0])));
    }

    @Deprecated
    public List<Group> createGroups(Group ... groups) {
        return this.createGroups(Arrays.asList(groups));
    }

    @Deprecated
    public List<Group> createGroups(List<Group> groups) {
        throw new ZendeskException("API Endpoint for createGroups does not exist.");
    }

    public Group updateGroup(Group group) {
        Zendesk.checkHasId(group);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/groups/{id}.json").set("id", group.getId()), JSON, this.json(Collections.singletonMap("group", group))), this.handle(Group.class, "group", new Class[0])));
    }

    public void deleteGroup(Group group) {
        Zendesk.checkHasId(group);
        this.deleteGroup(group.getId());
    }

    public void deleteGroup(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/groups/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<Macro> getMacros() {
        return new PagedIterable<Macro>(this.cbp("/macros.json"), this.handleList(Macro.class, "macros"));
    }

    public Macro getMacro(long macroId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/macros/{id}.json").set("id", macroId)), this.handle(Macro.class, "macro", new Class[0])));
    }

    public Macro createMacro(Macro macro) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/macros.json"), JSON, this.json(Collections.singletonMap("macro", macro))), this.handle(Macro.class, "macro", new Class[0])));
    }

    public Macro updateMacro(Long macroId, Macro macro) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/macros/{id}.json").set("id", macroId), JSON, this.json(Collections.singletonMap("macro", macro))), this.handle(Macro.class, "macro", new Class[0])));
    }

    public Ticket macrosShowChangesToTicket(long macroId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/macros/{id}/apply.json").set("id", macroId)), this.handle(TicketResult.class, "result", new Class[0]))).getTicket();
    }

    public Ticket macrosShowTicketAfterChanges(long ticketId, long macroId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{ticket_id}/macros/{id}/apply.json").set("ticket_id", ticketId).set("id", macroId)), this.handle(TicketResult.class, "result", new Class[0]))).getTicket();
    }

    public List<String> addTagToTicket(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> addTagToTopics(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/topics/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> addTagToOrganisations(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/organizations/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> setTagOnTicket(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/tickets/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> setTagOnTopics(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/topics/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> setTagOnOrganisations(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/organizations/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> removeTagFromTicket(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/tickets/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> removeTagFromTopics(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/topics/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> removeTagFromOrganisations(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/organizations/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public Map getIncrementalTicketsResult(long unixEpochTime) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/exports/tickets.json?start_time={time}").set("time", unixEpochTime)), this.handle(Map.class)));
    }

    public Iterable<GroupMembership> getGroupMemberships() {
        return new PagedIterable<GroupMembership>(this.cbp("/group_memberships.json"), this.handleList(GroupMembership.class, "group_memberships"));
    }

    public Iterable<GroupMembership> getGroupMembershipByUser(long user_id) {
        return new PagedIterable<GroupMembership>(this.cbp("/users/{user_id}/group_memberships.json").set("user_id", user_id), this.handleList(GroupMembership.class, "group_memberships"));
    }

    public Iterable<GroupMembership> getGroupMemberships(long group_id) {
        return new PagedIterable<GroupMembership>(this.cbp("/groups/{group_id}/memberships.json").set("group_id", group_id), this.handleList(GroupMembership.class, "group_memberships"));
    }

    public Iterable<GroupMembership> getAssignableGroupMemberships() {
        return new PagedIterable<GroupMembership>(this.cbp("/group_memberships/assignable.json"), this.handleList(GroupMembership.class, "group_memberships"));
    }

    public Iterable<GroupMembership> getAssignableGroupMemberships(long group_id) {
        return new PagedIterable<GroupMembership>(this.cbp("/groups/{group_id}/memberships/assignable.json").set("group_id", group_id), this.handleList(GroupMembership.class, "group_memberships"));
    }

    public GroupMembership getGroupMembership(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/group_memberships/{id}.json").set("id", id)), this.handle(GroupMembership.class, "group_membership", new Class[0])));
    }

    public GroupMembership getGroupMembership(long user_id, long group_membership_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{uid}/group_memberships/{gmid}.json").set("uid", user_id).set("gmid", group_membership_id)), this.handle(GroupMembership.class, "group_membership", new Class[0])));
    }

    public GroupMembership createGroupMembership(GroupMembership groupMembership) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/group_memberships.json"), JSON, this.json(Collections.singletonMap("group_membership", groupMembership))), this.handle(GroupMembership.class, "group_membership", new Class[0])));
    }

    public GroupMembership createGroupMembership(long user_id, GroupMembership groupMembership) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{id}/group_memberships.json").set("id", user_id), JSON, this.json(Collections.singletonMap("group_membership", groupMembership))), this.handle(GroupMembership.class, "group_membership", new Class[0])));
    }

    public void deleteGroupMembership(GroupMembership groupMembership) {
        Zendesk.checkHasId(groupMembership);
        this.deleteGroupMembership(groupMembership.getId());
    }

    public void deleteGroupMembership(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/group_memberships/{id}.json").set("id", id)), this.handleStatus()));
    }

    public void deleteGroupMembership(long user_id, GroupMembership groupMembership) {
        Zendesk.checkHasId(groupMembership);
        this.deleteGroupMembership(user_id, groupMembership.getId());
    }

    public void deleteGroupMembership(long user_id, long group_membership_id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{uid}/group_memberships/{gmid}.json").set("uid", user_id).set("gmid", group_membership_id)), this.handleStatus()));
    }

    public List<GroupMembership> setGroupMembershipAsDefault(long user_id, GroupMembership groupMembership) {
        Zendesk.checkHasId(groupMembership);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{uid}/group_memberships/{gmid}/make_default.json").set("uid", user_id).set("gmid", groupMembership.getId()), JSON, this.json(Collections.singletonMap("group_memberships", groupMembership))), this.handleList(GroupMembership.class, "results")));
    }

    public Iterable<Forum> getForums() {
        return new PagedIterable<Forum>(this.cnst("/forums.json"), this.handleList(Forum.class, "forums"));
    }

    public List<Forum> getForums(long category_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/categories/{id}/forums.json").set("id", category_id)), this.handleList(Forum.class, "forums")));
    }

    public Forum getForum(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/forums/{id}.json").set("id", id)), this.handle(Forum.class, "forum", new Class[0])));
    }

    public Forum createForum(Forum forum) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/forums.json"), JSON, this.json(Collections.singletonMap("forum", forum))), this.handle(Forum.class, "forum", new Class[0])));
    }

    public Forum updateForum(Forum forum) {
        this.checkHasId(forum);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/forums/{id}.json").set("id", forum.getId()), JSON, this.json(Collections.singletonMap("forum", forum))), this.handle(Forum.class, "forum", new Class[0])));
    }

    public void deleteForum(Forum forum) {
        this.checkHasId(forum);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/forums/{id}.json").set("id", forum.getId())), this.handleStatus()));
    }

    public Iterable<Topic> getTopics() {
        return new PagedIterable<Topic>(this.cnst("/topics.json"), this.handleList(Topic.class, "topics"));
    }

    public List<Topic> getTopics(long forum_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/forums/{id}/topics.json").set("id", forum_id)), this.handleList(Topic.class, "topics")));
    }

    public List<Topic> getTopicsByUser(long user_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}/topics.json").set("id", user_id)), this.handleList(Topic.class, "topics")));
    }

    public Topic getTopic(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/topics/{id}.json").set("id", id)), this.handle(Topic.class, "topic", new Class[0])));
    }

    public Topic createTopic(Topic topic) {
        this.checkHasId(topic);
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/topics.json"), JSON, this.json(Collections.singletonMap("topic", topic))), this.handle(Topic.class, "topic", new Class[0])));
    }

    public Topic importTopic(Topic topic) {
        this.checkHasId(topic);
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/import/topics.json"), JSON, this.json(Collections.singletonMap("topic", topic))), this.handle(Topic.class, "topic", new Class[0])));
    }

    public List<Topic> getTopics(long id, long ... ids) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/topics/show_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleList(Topic.class, "topics")));
    }

    public Topic updateTopic(Topic topic) {
        this.checkHasId(topic);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/topics/{id}.json").set("id", topic.getId()), JSON, this.json(Collections.singletonMap("topic", topic))), this.handle(Topic.class, "topic", new Class[0])));
    }

    public void deleteTopic(Topic topic) {
        this.checkHasId(topic);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/topics/{id}.json").set("id", topic.getId())), this.handleStatus()));
    }

    public Iterable<OrganizationMembership> getOrganizationMembershipByUser(long user_id) {
        return this.getOrganizationMembershipsForUser(user_id);
    }

    public OrganizationMembership getGroupOrganization(long user_id, long organization_membership_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{uid}/organization_memberships/{oid}.json").set("uid", user_id).set("oid", organization_membership_id)), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public OrganizationMembership createOrganizationMembership(long user_id, OrganizationMembership organizationMembership) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{id}/organization_memberships.json").set("id", user_id), JSON, this.json(Collections.singletonMap("organization_membership", organizationMembership))), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public void deleteOrganizationMembership(long user_id, OrganizationMembership organizationMembership) {
        Zendesk.checkHasId(organizationMembership);
        this.deleteOrganizationMembership(user_id, organizationMembership.getId());
    }

    public void deleteOrganizationMembership(long user_id, long organization_membership_id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{uid}/organization_memberships/{oid}.json").set("uid", user_id).set("oid", organization_membership_id)), this.handleStatus()));
    }

    public void unassignOrganizationMembership(long user_id, long organization_id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{uid}/organizations/{oid}.json").set("uid", user_id).set("oid", organization_id)), this.handleStatus()));
    }

    public List<OrganizationMembership> setOrganizationMembershipAsDefault(long user_id, OrganizationMembership organizationMembership) {
        Zendesk.checkHasId(organizationMembership);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{uid}/organization_memberships/{omid}/make_default.json").set("uid", user_id).set("omid", organizationMembership.getId()), JSON, this.json(Collections.singletonMap("organization_memberships", organizationMembership))), this.handleList(OrganizationMembership.class, "results")));
    }

    public Iterable<SearchResultEntity> getSearchResults(String query) {
        return new PagedIterable<SearchResultEntity>(this.tmpl("/search.json{?query}").set("query", query), this.handleSearchList("results"));
    }

    public <T extends SearchResultEntity> Iterable<T> getSearchResults(Class<T> type, String query) {
        return this.getSearchResults(type, query, Collections.emptyMap());
    }

    @Deprecated
    public <T extends SearchResultEntity> Iterable<T> getSearchResults(Class<T> type, String query, String params) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("params", params);
        return this.getSearchResults(type, query, paramsMap);
    }

    public <T extends SearchResultEntity> Iterable<T> getSearchResults(Class<T> type, String query, String sortBy, SortOrder sortOrder) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        paramsMap.put("sort_by", sortBy);
        paramsMap.put("sort_order", sortOrder.getQueryParameter());
        return this.getSearchResults(type, query, paramsMap);
    }

    public <T extends SearchResultEntity> Iterable<T> getSearchResults(Class<T> type, String query, Map<String, Object> params) {
        String typeName = Zendesk.getTypeName(type);
        if (typeName == null) {
            return Collections.emptyList();
        }
        TemplateUri templateUri = this.getSearchUri(params, query, typeName);
        return new PagedIterable<T>(templateUri, this.handleList(type, "results"));
    }

    public <T> Optional<T> getSearchResults(Class<?> searchType, Class<T> pageType, String query, Map<String, Object> queryParams, String sortBy, SortOrder sortOrder) {
        String typeName = Zendesk.getTypeName(searchType);
        if (typeName == null) {
            return Optional.empty();
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (queryParams != null) {
            paramsMap.putAll(queryParams);
        }
        if (sortBy != null && sortOrder != null) {
            paramsMap.put("sort_by", sortBy);
            paramsMap.put("sort_order", sortOrder.getQueryParameter());
        }
        TemplateUri templateUri = this.getSearchUri(paramsMap, query, typeName);
        return Optional.of(Zendesk.complete(this.submit(this.req("GET", templateUri.toString()), this.handle(pageType))));
    }

    public Optional<TicketPage> getSearchTicketResults(String query, Map<String, Object> queryParams, String sortBy, SortOrder sortOrder) {
        return this.getSearchResults(Ticket.class, TicketPage.class, query, queryParams, sortBy, sortOrder);
    }

    public void notifyApp(String json) {
        Zendesk.complete(this.submit(this.req("POST", this.cnst("/apps/notify.json"), JSON, json.getBytes()), this.handleStatus()));
    }

    public void updateInstallation(int id, String json) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/apps/installations/{id}.json").set("id", id), JSON, json.getBytes()), this.handleStatus()));
    }

    public Iterable<SatisfactionRating> getSatisfactionRatings() {
        return new PagedIterable<SatisfactionRating>(this.cbp("/satisfaction_ratings.json"), this.handleList(SatisfactionRating.class, "satisfaction_ratings"));
    }

    public SatisfactionRating getSatisfactionRating(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/satisfaction_ratings/{id}.json").set("id", id)), this.handle(SatisfactionRating.class, "satisfaction_rating", new Class[0])));
    }

    public SatisfactionRating createSatisfactionRating(long ticketId, SatisfactionRating satisfactionRating) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/tickets/{ticketId}/satisfaction_rating.json").set("ticketId", ticketId), JSON, this.json(Collections.singletonMap("satisfaction_rating", satisfactionRating))), this.handle(SatisfactionRating.class, "satisfaction_rating", new Class[0])));
    }

    public SatisfactionRating createSatisfactionRating(Ticket ticket, SatisfactionRating satisfactionRating) {
        return this.createSatisfactionRating(ticket.getId(), satisfactionRating);
    }

    public Iterable<DynamicContentItem> getDynamicContentItems() {
        return new PagedIterable<DynamicContentItem>(this.cbp("/dynamic_content/items.json"), this.handleList(DynamicContentItem.class, "items"));
    }

    public DynamicContentItem getDynamicContentItem(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/dynamic_content/items/{id}.json").set("id", id)), this.handle(DynamicContentItem.class, "item", new Class[0])));
    }

    public DynamicContentItem createDynamicContentItem(DynamicContentItem item) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/dynamic_content/items.json"), JSON, this.json(Collections.singletonMap("item", item))), this.handle(DynamicContentItem.class, "item", new Class[0])));
    }

    public DynamicContentItem updateDynamicContentItem(DynamicContentItem item) {
        Zendesk.checkHasId(item);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/dynamic_content/items/{id}.json").set("id", item.getId()), JSON, this.json(Collections.singletonMap("item", item))), this.handle(DynamicContentItem.class, "item", new Class[0])));
    }

    public void deleteDynamicContentItem(DynamicContentItem item) {
        Zendesk.checkHasId(item);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/dynamic_content/items/{id}.json").set("id", item.getId())), this.handleStatus()));
    }

    public Iterable<DynamicContentItemVariant> getDynamicContentItemVariants(DynamicContentItem item) {
        Zendesk.checkHasId(item);
        return new PagedIterable<DynamicContentItemVariant>(this.cbp("/dynamic_content/items/{id}/variants.json").set("id", item.getId()), this.handleList(DynamicContentItemVariant.class, "variants"));
    }

    public DynamicContentItemVariant getDynamicContentItemVariant(Long itemId, long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/dynamic_content/items/{itemId}/variants/{id}.json").set("itemId", itemId).set("id", id)), this.handle(DynamicContentItemVariant.class, "variant", new Class[0])));
    }

    public DynamicContentItemVariant createDynamicContentItemVariant(Long itemId, DynamicContentItemVariant variant) {
        Zendesk.checkHasItemId(itemId);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/dynamic_content/items/{id}/variants.json").set("id", itemId), JSON, this.json(Collections.singletonMap("variant", variant))), this.handle(DynamicContentItemVariant.class, "variant", new Class[0])));
    }

    public DynamicContentItemVariant updateDynamicContentItemVariant(Long itemId, DynamicContentItemVariant variant) {
        Zendesk.checkHasItemId(itemId);
        Zendesk.checkHasId(variant);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/dynamic_content/items/{itemId}/variants/{id}.json").set("itemId", itemId).set("id", variant.getId()), JSON, this.json(Collections.singletonMap("variant", variant))), this.handle(DynamicContentItemVariant.class, "variant", new Class[0])));
    }

    public void deleteDynamicContentItemVariant(Long itemId, DynamicContentItemVariant variant) {
        Zendesk.checkHasItemId(itemId);
        Zendesk.checkHasId(variant);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/dynamic_content/items/{itemId}/variants/{id}.json").set("itemId", itemId).set("id", variant.getId())), this.handleStatus()));
    }

    public Iterable<Locale> getLocales() {
        return new PagedIterable<Locale>(this.cnst("/locales.json"), this.handleList(Locale.class, "locales"));
    }

    public Iterable<PermissionGroup> getPermissionGroups() {
        return new PagedIterable<PermissionGroup>(this.cnst("/guide/permission_groups.json"), this.handleList(PermissionGroup.class, "permission_groups"));
    }

    public PermissionGroup getPermissionGroup(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/guide/permission_groups/{id}.json").set("id", id)), this.handle(PermissionGroup.class, "permission_group", new Class[0])));
    }

    public PermissionGroup createPermissionGroup(PermissionGroup permissionGroup) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/guide/permission_groups.json"), JSON, this.json(Collections.singletonMap("permission_group", permissionGroup))), this.handle(PermissionGroup.class, "permission_group", new Class[0])));
    }

    public PermissionGroup updatePermissionGroup(PermissionGroup permissionGroup) {
        Zendesk.checkHasId(permissionGroup);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/guide/permission_groups/{id}.json").set("id", permissionGroup.getId()), JSON, this.json(Collections.singletonMap("permission_group", permissionGroup))), this.handle(PermissionGroup.class, "permission_group", new Class[0])));
    }

    public void deletePermissionGroup(PermissionGroup permissionGroup) {
        Zendesk.checkHasId(permissionGroup);
        this.deletePermissionGroup(permissionGroup.getId());
    }

    public void deletePermissionGroup(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/guide/permission_groups/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<UserSegment> getUserSegments() {
        return new PagedIterable<UserSegment>(this.cnst("/help_center/user_segments.json"), this.handleList(UserSegment.class, "user_segments"));
    }

    public Iterable<UserSegment> getUserSegments(long id) {
        return new PagedIterable<UserSegment>(this.tmpl("/help_center/users/{id}/user_segments.json").set("id", id), this.handleList(UserSegment.class, "user_segments"));
    }

    public Iterable<UserSegment> getUserSegmentsApplicable() {
        return new PagedIterable<UserSegment>(this.cnst("/help_center/user_segments/applicable.json"), this.handleList(UserSegment.class, "user_segments"));
    }

    public UserSegment getUserSegment(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/user_segments/{id}.json").set("id", id)), this.handle(UserSegment.class, "user_segment", new Class[0])));
    }

    public Iterable<Section> getSections(UserSegment userSegment) {
        Zendesk.checkHasId(userSegment);
        return new PagedIterable<Section>(this.tmpl("/help_center/user_segments/{id}/sections.json").set("id", userSegment.getId()), this.handleList(Section.class, "sections"));
    }

    public Iterable<Topic> getTopics(UserSegment userSegment) {
        Zendesk.checkHasId(userSegment);
        return new PagedIterable<Topic>(this.tmpl("/help_center/user_segments/{id}/topics.json").set("id", userSegment.getId()), this.handleList(Topic.class, "topics"));
    }

    public UserSegment createUserSegment(UserSegment userSegment) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/user_segments.json"), JSON, this.json(Collections.singletonMap("user_segment", userSegment))), this.handle(UserSegment.class, "user_segment", new Class[0])));
    }

    public UserSegment updateUserSegment(UserSegment userSegment) {
        Zendesk.checkHasId(userSegment);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/user_segments/{id}.json").set("id", userSegment.getId()), JSON, this.json(Collections.singletonMap("user_segment", userSegment))), this.handle(UserSegment.class, "user_segment", new Class[0])));
    }

    public void deleteUserSegment(UserSegment userSegment) {
        Zendesk.checkHasId(userSegment);
        this.deleteUserSegment(userSegment.getId());
    }

    public void deleteUserSegment(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/user_segments/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Locales listHelpCenterLocales() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/help_center/locales.json")), this.handle(Locales.class)));
    }

    @Deprecated
    public List<String> getHelpCenterLocales() {
        return this.listHelpCenterLocales().getLocales();
    }

    public Iterable<Article> getArticles() {
        return new PagedIterable<Article>(this.cbp("/help_center/articles.json"), this.handleList(Article.class, "articles"));
    }

    public Iterable<Article> getArticles(String locale) {
        return new PagedIterable<Article>(this.cbp("/help_center/{locale}/articles.json").set("locale", locale), this.handleList(Article.class, "articles"));
    }

    public Iterable<Article> getArticles(Category category) {
        Zendesk.checkHasId(category);
        return new PagedIterable<Article>(this.cbp("/help_center/categories/{id}/articles.json").set("id", category.getId()), this.handleList(Article.class, "articles"));
    }

    public Iterable<Article> getArticles(Category category, String locale) {
        Zendesk.checkHasId(category);
        return new PagedIterable<Article>(this.cbp("/help_center/{locale}/categories/{id}/articles.json").set("id", category.getId()).set("locale", locale), this.handleList(Article.class, "articles"));
    }

    public Iterable<Article> getArticles(Section section) {
        Zendesk.checkHasId(section);
        return new PagedIterable<Article>(this.cbp("/help_center/sections/{id}/articles.json").set("id", section.getId()), this.handleList(Article.class, "articles"));
    }

    public Iterable<Article> getArticles(Section section, String locale) {
        Zendesk.checkHasId(section);
        return new PagedIterable<Article>(this.cbp("/help_center/{locale}/sections/{id}/articles.json").set("id", section.getId()).set("locale", locale), this.handleList(Article.class, "articles"));
    }

    public Iterable<Article> getArticlesIncrementally(Date startTime) {
        return new PagedIterable<Article>(this.tmpl("/help_center/incremental/articles.json{?start_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())), this.handleIncrementalList(Article.class, "articles"));
    }

    public List<Article> getArticlesFromPage(int page) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/articles.json?page={page}").set("page", page)), this.handleList(Article.class, "articles")));
    }

    public Article getArticle(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/articles/{id}.json").set("id", id)), this.handle(Article.class, "article", new Class[0])));
    }

    public Iterable<Translation> getArticleTranslations(Long articleId) {
        return new PagedIterable<Translation>(this.cbp("/help_center/articles/{articleId}/translations.json").set("articleId", articleId), this.handleList(Translation.class, "translations"));
    }

    public Translation showArticleTranslation(long articleId, String locale) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/articles/{articleId}/translations/{locale}.json").set("articleId", articleId).set("locale", locale)), this.handle(Translation.class, "translation", new Class[0])));
    }

    public Article createArticle(Article article) {
        Zendesk.checkHasSectionId(article);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/sections/{id}/articles.json").set("id", article.getSectionId()), JSON, this.json(Collections.singletonMap("article", article))), this.handle(Article.class, "article", new Class[0])));
    }

    public Article createArticle(Article article, boolean notifySubscribers) {
        Zendesk.checkHasSectionId(article);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("article", article);
        map.put("notify_subscribers", notifySubscribers ? String.valueOf("true") : String.valueOf("false"));
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/sections/{id}/articles.json").set("id", article.getSectionId()), JSON, this.json(Collections.unmodifiableMap(map))), this.handle(Article.class, "article", new Class[0])));
    }

    public Article updateArticle(Article article) {
        Zendesk.checkHasId(article);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/articles/{id}.json").set("id", article.getId()), JSON, this.json(Collections.singletonMap("article", article))), this.handle(Article.class, "article", new Class[0])));
    }

    public Translation createArticleTranslation(Long articleId, Translation translation) {
        Zendesk.checkHasArticleId(articleId);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/articles/{id}/translations.json").set("id", articleId), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public Translation updateArticleTranslation(Long articleId, String locale, Translation translation) {
        Zendesk.checkHasId(translation);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/articles/{id}/translations/{locale}.json").set("id", articleId).set("locale", locale), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public void deleteArticle(Article article) {
        Zendesk.checkHasId(article);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/articles/{id}.json").set("id", article.getId())), this.handleStatus()));
    }

    public void deleteTranslation(Translation translation) {
        Zendesk.checkHasId(translation);
        this.deleteTranslation(translation.getId());
    }

    public void deleteTranslation(Long translationId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/translations/{id}.json").set("id", translationId)), this.handleStatus()));
    }

    public void deleteArticleAttachment(ArticleAttachments attachment) {
        Zendesk.checkHasId(attachment);
        this.deleteArticleAttachment(attachment.getId());
    }

    public void deleteArticleAttachment(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/articles/attachments/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<Category> getCategories() {
        return new PagedIterable<Category>(this.cnst("/help_center/categories.json"), this.handleList(Category.class, "categories"));
    }

    public Category getCategory(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/categories/{id}.json").set("id", id)), this.handle(Category.class, "category", new Class[0])));
    }

    public Iterable<Translation> getCategoryTranslations(Long categoryId) {
        return new PagedIterable<Translation>(this.tmpl("/help_center/categories/{categoryId}/translations.json").set("categoryId", categoryId), this.handleList(Translation.class, "translations"));
    }

    public Translation showCategoryTranslation(long categoryId, String locale) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/categories/{categoryId}/translations/{locale}.json").set("categoryId", categoryId).set("locale", locale)), this.handle(Translation.class, "translation", new Class[0])));
    }

    public Category createCategory(Category category) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/help_center/categories.json"), JSON, this.json(Collections.singletonMap("category", category))), this.handle(Category.class, "category", new Class[0])));
    }

    public Category updateCategory(Category category) {
        Zendesk.checkHasId(category);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/categories/{id}.json").set("id", category.getId()), JSON, this.json(Collections.singletonMap("category", category))), this.handle(Category.class, "category", new Class[0])));
    }

    public Translation createCategoryTranslation(Long categoryId, Translation translation) {
        Zendesk.checkHasCategoryId(categoryId);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/categories/{id}/translations.json").set("id", categoryId), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public Translation updateCategoryTranslation(Long categoryId, String locale, Translation translation) {
        Zendesk.checkHasId(translation);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/categories/{id}/translations/{locale}.json").set("id", categoryId).set("locale", locale), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public void deleteCategory(Category category) {
        Zendesk.checkHasId(category);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/categories/{id}.json").set("id", category.getId())), this.handleStatus()));
    }

    public Iterable<Section> getSections() {
        return new PagedIterable<Section>(this.cnst("/help_center/sections.json"), this.handleList(Section.class, "sections"));
    }

    public Iterable<Section> getSections(Category category) {
        Zendesk.checkHasId(category);
        return new PagedIterable<Section>(this.tmpl("/help_center/categories/{id}/sections.json").set("id", category.getId()), this.handleList(Section.class, "sections"));
    }

    public Section getSection(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/sections/{id}.json").set("id", id)), this.handle(Section.class, "section", new Class[0])));
    }

    public Iterable<Translation> getSectionTranslations(Long sectionId) {
        return new PagedIterable<Translation>(this.tmpl("/help_center/sections/{sectionId}/translations.json").set("sectionId", sectionId), this.handleList(Translation.class, "translations"));
    }

    public Translation showSectionTranslation(long sectionId, String locale) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/sections/{sectionId}/translations/{locale}.json").set("sectionId", sectionId).set("locale", locale)), this.handle(Translation.class, "translation", new Class[0])));
    }

    public Section createSection(Section section) {
        Zendesk.checkHasCategoryId(section);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/categories/{id}/sections.json").set("id", section.getCategoryId()), JSON, this.json(Collections.singletonMap("section", section))), this.handle(Section.class, "section", new Class[0])));
    }

    public Section updateSection(Section section) {
        Zendesk.checkHasId(section);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/sections/{id}.json").set("id", section.getId()), JSON, this.json(Collections.singletonMap("section", section))), this.handle(Section.class, "section", new Class[0])));
    }

    public Translation createSectionTranslation(Long sectionId, Translation translation) {
        Zendesk.checkHasSectionId(sectionId);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/sections/{id}/translations.json").set("id", sectionId), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public Translation updateSectionTranslation(Long sectionId, String locale, Translation translation) {
        Zendesk.checkHasId(translation);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/sections/{id}/translations/{locale}.json").set("id", sectionId).set("locale", locale), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public void deleteSection(Section section) {
        Zendesk.checkHasId(section);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/sections/{id}.json").set("id", section.getId())), this.handleStatus()));
    }

    public Iterable<Subscription> getUserSubscriptions(User user) {
        Zendesk.checkHasId(user);
        return this.getUserSubscriptions(user.getId());
    }

    public Iterable<Subscription> getUserSubscriptions(Long userId) {
        return new PagedIterable<Subscription>(this.tmpl("/help_center/users/{userId}/subscriptions.json").set("userId", userId), this.handleList(Subscription.class, "subscriptions"));
    }

    public Iterable<Subscription> getArticleSubscriptions(Long articleId) {
        return this.getArticleSubscriptions(articleId, null);
    }

    public Iterable<Subscription> getArticleSubscriptions(Long articleId, String locale) {
        return new PagedIterable<Subscription>(this.tmpl("/help_center{/locale}/articles/{articleId}/subscriptions.json").set("locale", locale).set("articleId", articleId), this.handleList(Subscription.class, "subscriptions"));
    }

    public Iterable<Subscription> getSectionSubscriptions(Long sectionId) {
        return this.getSectionSubscriptions(sectionId, null);
    }

    public Iterable<Subscription> getSectionSubscriptions(Long sectionId, String locale) {
        return new PagedIterable<Subscription>(this.tmpl("/help_center{/locale}/sections/{sectionId}/subscriptions.json").set("locale", locale).set("sectionId", sectionId), this.handleList(Subscription.class, "subscriptions"));
    }

    public Iterable<Schedule> getSchedules() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/business_hours/schedules.json")), this.handleList(Schedule.class, "schedules")));
    }

    public Schedule getSchedule(Schedule schedule) {
        Zendesk.checkHasId(schedule);
        return this.getSchedule(schedule.getId());
    }

    public Schedule getSchedule(Long scheduleId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/business_hours/schedules/{id}.json").set("id", scheduleId)), this.handle(Schedule.class, "schedule", new Class[0])));
    }

    public Iterable<Holiday> getHolidaysForSchedule(Schedule schedule) {
        Zendesk.checkHasId(schedule);
        return this.getHolidaysForSchedule(schedule.getId());
    }

    public Iterable<Holiday> getHolidaysForSchedule(Long scheduleId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/business_hours/schedules/{id}/holidays.json").set("id", scheduleId)), this.handleList(Holiday.class, "holidays")));
    }

    public ContentTag getContentTag(String contentTagId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/guide/content_tags/{id}").set("id", contentTagId)), this.handle(ContentTag.class, "content_tag", new Class[0])));
    }

    public ContentTag createContentTag(ContentTag contentTag) {
        Zendesk.checkHasName(contentTag);
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/guide/content_tags"), JSON, this.json(Collections.singletonMap("content_tag", contentTag))), this.handle(ContentTag.class, "content_tag", new Class[0])));
    }

    public ContentTag updateContentTag(ContentTag contentTag) {
        Zendesk.checkHasId(contentTag);
        Zendesk.checkHasName(contentTag);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/guide/content_tags/{id}").set("id", contentTag.getId()), JSON, this.json(Collections.singletonMap("content_tag", contentTag))), this.handle(ContentTag.class, "content_tag", new Class[0])));
    }

    public void deleteContentTag(ContentTag contentTag) {
        Zendesk.checkHasId(contentTag);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/guide/content_tags/{id}").set("id", contentTag.getId())), this.handleStatus()));
    }

    public Iterable<ContentTag> getContentTags() {
        int defaultPageSize = 10;
        return this.getContentTags(defaultPageSize, null);
    }

    public Iterable<ContentTag> getContentTags(int pageSize) {
        return this.getContentTags(pageSize, null);
    }

    public Iterable<ContentTag> getContentTags(int pageSize, String namePrefix) {
        Function<String, Uri> afterCursorUriBuilder = afterCursor -> this.buildContentTagsSearchUrl(pageSize, namePrefix, (String)afterCursor);
        return new PagedIterable<ContentTag>(afterCursorUriBuilder.apply(null), this.handleListWithAfterCursorButNoLinks(ContentTag.class, afterCursorUriBuilder, "records"));
    }

    public Iterable<JiraLink> getJiraLinks() {
        return new PagedIterable<JiraLink>(this.cnst("/jira/links"), this.handleList(JiraLink.class, CURSOR_LINKS));
    }

    private Uri buildContentTagsSearchUrl(int pageSize, String namePrefixFilter, String afterCursor) {
        StringBuilder uriBuilder = new StringBuilder("/guide/content_tags?page[size]=").append(pageSize);
        if (namePrefixFilter != null) {
            uriBuilder.append("&filter[name_prefix]=").append(Zendesk.encodeUrl(namePrefixFilter));
        }
        if (afterCursor != null) {
            uriBuilder.append("&page[after]=").append(Zendesk.encodeUrl(afterCursor));
        }
        return this.cnst(uriBuilder.toString());
    }

    public List<TimeZone> getTimeZones() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/time_zones.json")), this.handleList(TimeZone.class, "time_zones")));
    }

    private byte[] json(Object object) {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new ZendeskException(e.getMessage(), e);
        }
    }

    private <T> ListenableFuture<T> submit(org.asynchttpclient.Request request, ZendeskAsyncCompletionHandler<T> handler) {
        if (this.logger.isDebugEnabled()) {
            if (request.getStringData() != null) {
                this.logger.debug("Request {} {}\n{}", new Object[]{request.getMethod(), request.getUrl(), request.getStringData()});
            } else if (request.getByteData() != null) {
                this.logger.debug("Request {} {} {} {} bytes", new Object[]{request.getMethod(), request.getUrl(), request.getHeaders().get("Content-type"), request.getByteData().length});
            } else {
                this.logger.debug("Request {} {}", (Object)request.getMethod(), (Object)request.getUrl());
            }
        }
        return this.client.executeRequest(request, handler);
    }

    private org.asynchttpclient.Request req(String method, Uri template) {
        return this.req(method, template.toString());
    }

    private org.asynchttpclient.Request req(String method, String url) {
        return this.reqBuilder(method, url).build();
    }

    private org.asynchttpclient.Request req(String method, Uri template, String contentType, byte[] body) {
        RequestBuilder builder = this.reqBuilder(method, template.toString());
        builder.addHeader((CharSequence)"Content-type", contentType);
        builder.setBody(body);
        return builder.build();
    }

    private RequestBuilder reqBuilder(String method, String url) {
        RequestBuilder builder = new RequestBuilder(method);
        if (this.realm != null) {
            builder.setRealm(this.realm);
        } else {
            builder.addHeader((CharSequence)"Authorization", "Bearer " + this.oauthToken);
        }
        this.headers.forEach((arg_0, arg_1) -> ((RequestBuilder)builder).setHeader(arg_0, arg_1));
        return (RequestBuilder)builder.setUrl(url);
    }

    protected ZendeskAsyncCompletionHandler<Void> handleStatus() {
        return new ZendeskAsyncCompletionHandler<Void>(){

            public Void onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    return null;
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected <T> ZendeskAsyncCompletionHandler<T> handle(Class<T> clazz) {
        return this.handle(this.mapper.readerFor(clazz));
    }

    protected <T> ZendeskAsyncCompletionHandler<T> handle(final ObjectReader reader) {
        return new ZendeskAsyncCompletionHandler<T>(){

            public T onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    return reader.readValue(response.getResponseBodyAsStream());
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                if (response.getStatusCode() == 404) {
                    return null;
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected <T> ZendeskAsyncCompletionHandler<T> handle(Class<T> clazz, String name, Class ... typeParams) {
        return new BasicAsyncCompletionHandler(clazz, name, typeParams);
    }

    protected ZendeskAsyncCompletionHandler<JobStatus> handleJobStatus() {
        return new BasicAsyncCompletionHandler<JobStatus>(JobStatus.class, "job_status", new Class[0]){

            @Override
            public JobStatus onCompleted(Response response) throws Exception {
                JobStatus result = (JobStatus)super.onCompleted(response);
                if (result == null) {
                    throw new ZendeskResponseException(response);
                }
                return result;
            }
        };
    }

    protected <T> PagedAsyncCompletionHandler<List<T>> handleList(Class<T> clazz, String name) {
        return new PagedAsyncListCompletionHandler<T>(clazz, name);
    }

    protected <T> PagedAsyncCompletionHandler<List<T>> handleIncrementalList(Class<T> clazz, String name) {
        return new PagedAsyncListCompletionHandler<T>((Class)clazz, name){

            @Override
            public void setPagedProperties(JsonNode responseNode, Class<?> clazz) {
                JsonNode node = responseNode.get(Zendesk.NEXT_PAGE);
                if (node == null) {
                    if (Zendesk.this.logger.isDebugEnabled()) {
                        Zendesk.this.logger.debug("next_page property not found, pagination not supported" + (String)(clazz != null ? " for " + clazz.getName() : ""));
                    }
                    this.setNextPage(null);
                    return;
                }
                JsonNode endTimeNode = responseNode.get(Zendesk.END_TIME);
                if (endTimeNode == null || endTimeNode.asLong() == 0L) {
                    if (Zendesk.this.logger.isDebugEnabled()) {
                        Zendesk.this.logger.debug("end_time property not found, incremental export pagination not supported" + (String)(clazz != null ? " for " + clazz.getName() : ""));
                    }
                    this.setNextPage(null);
                    return;
                }
                if (TimeUnit.SECONDS.toMillis(endTimeNode.asLong()) > System.currentTimeMillis() - FIVE_MINUTES) {
                    this.setNextPage(null);
                } else {
                    JsonNode countNode = responseNode.get(Zendesk.COUNT);
                    if (countNode == null) {
                        if (Zendesk.this.logger.isDebugEnabled()) {
                            Zendesk.this.logger.debug("count property not found, incremental export pagination not supported" + (String)(clazz != null ? " for " + clazz.getName() : ""));
                        }
                        this.setNextPage(null);
                        return;
                    }
                    if (countNode.asInt() < 1000) {
                        this.setNextPage(null);
                    } else {
                        this.setNextPage(node.asText());
                    }
                }
            }
        };
    }

    protected PagedAsyncCompletionHandler<List<SearchResultEntity>> handleSearchList(final String name) {
        return new PagedAsyncCompletionHandler<List<SearchResultEntity>>(){

            public List<SearchResultEntity> onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    JsonNode responseNode = Zendesk.this.mapper.readTree(response.getResponseBodyAsStream()).get(name);
                    this.setPagedProperties(responseNode, null);
                    ArrayList<SearchResultEntity> values = new ArrayList<SearchResultEntity>();
                    for (JsonNode node : responseNode) {
                        Class<? extends SearchResultEntity> clazz = searchResultTypes.get(node.get("result_type").asText());
                        if (clazz == null) continue;
                        values.add((SearchResultEntity)Zendesk.this.mapper.convertValue((Object)node, clazz));
                    }
                    return values;
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected PagedAsyncCompletionHandler<List<Target>> handleTargetList(final String name) {
        return new PagedAsyncCompletionHandler<List<Target>>(){

            public List<Target> onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    JsonNode responseNode = Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes());
                    this.setPagedProperties(responseNode, null);
                    ArrayList<Target> values = new ArrayList<Target>();
                    for (JsonNode node : responseNode.get(name)) {
                        Class<? extends Target> clazz = targetTypes.get(node.get("type").asText());
                        if (clazz == null) continue;
                        values.add((Target)Zendesk.this.mapper.convertValue((Object)node, clazz));
                    }
                    return values;
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected PagedAsyncCompletionHandler<List<ArticleAttachments>> handleArticleAttachmentsList(final String name) {
        return new PagedAsyncCompletionHandler<List<ArticleAttachments>>(){

            public List<ArticleAttachments> onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    JsonNode responseNode = Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes());
                    ArrayList<ArticleAttachments> values = new ArrayList<ArticleAttachments>();
                    for (JsonNode node : responseNode.get(name)) {
                        values.add((ArticleAttachments)Zendesk.this.mapper.convertValue((Object)node, ArticleAttachments.class));
                    }
                    return values;
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    private <T> PagedAsyncCompletionHandler<List<T>> handleListWithAfterCursorButNoLinks(Class<T> clazz, final Function<String, Uri> afterCursorUriBuilder, String name) {
        return new PagedAsyncListCompletionHandler<T>(clazz, name){

            @Override
            public void setPagedProperties(JsonNode responseNode, Class<?> clazz) {
                JsonNode metaNode = responseNode.get("meta");
                String nextPage = null;
                if (metaNode == null) {
                    if (Zendesk.this.logger.isDebugEnabled()) {
                        Zendesk.this.logger.debug("meta property not found, pagination not supported" + (String)(clazz != null ? " for " + clazz.getName() : ""));
                    }
                } else {
                    JsonNode hasMoreNode;
                    JsonNode afterCursorNode = metaNode.get("after_cursor");
                    if (afterCursorNode != null && (hasMoreNode = metaNode.get("has_more")) != null && hasMoreNode.asBoolean()) {
                        nextPage = ((Uri)afterCursorUriBuilder.apply(afterCursorNode.asText())).toString();
                    }
                }
                this.setNextPage(nextPage);
            }
        };
    }

    private TemplateUri tmpl(String template) {
        return new TemplateUri(this.url + template);
    }

    private TemplateUri cbp(String path) {
        Objects.requireNonNull(path, "Path cannot be null");
        if (path.indexOf(63) != -1) {
            throw new IllegalArgumentException("Path cannot contain a query string");
        }
        return new TemplateUri(this.url + path + "?page[size]={pageSize}").set("pageSize", this.cbpPageSize);
    }

    private Uri cnst(String template) {
        return new FixedUri(this.url + template);
    }

    private void logResponse(Response response) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Response HTTP/{} {}\n{}", new Object[]{response.getStatusCode(), response.getStatusText(), response.getResponseBody()});
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Response headers {}", (Object)response.getHeaders());
        }
    }

    private static String encodeUrl(String input) {
        try {
            return URLEncoder.encode(input, UTF_8);
        }
        catch (UnsupportedEncodingException impossible) {
            return input;
        }
    }

    private static long msToSeconds(long millis) {
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    private boolean isStatus2xx(Response response) {
        return response.getStatusCode() / 100 == 2;
    }

    private boolean isRateLimitResponse(Response response) {
        return response.getStatusCode() == 429;
    }

    private static <T> T complete(ListenableFuture<T> future) {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            throw new ZendeskException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ZendeskException) {
                if (e.getCause() instanceof ZendeskResponseRateLimitException) {
                    throw new ZendeskResponseRateLimitException((ZendeskResponseRateLimitException)e.getCause());
                }
                if (e.getCause() instanceof ZendeskResponseException) {
                    throw new ZendeskResponseException((ZendeskResponseException)e.getCause());
                }
                throw new ZendeskException(e.getCause());
            }
            throw new ZendeskException(e.getMessage(), e);
        }
    }

    private static void checkHasId(Ticket ticket) {
        if (ticket.getId() == null) {
            throw new IllegalArgumentException("Ticket requires id");
        }
    }

    private static void checkHasId(TicketForm ticketForm) {
        if (ticketForm.getId() == null) {
            throw new IllegalArgumentException("TicketForm requires id");
        }
    }

    private static void checkHasId(Request request) {
        if (request.getId() == null) {
            throw new IllegalArgumentException("Request requires id");
        }
    }

    private static void checkHasId(Audit audit) {
        if (audit.getId() == null) {
            throw new IllegalArgumentException("Audit requires id");
        }
    }

    private static void checkHasId(Comment comment) {
        if (comment.getId() == null) {
            throw new IllegalArgumentException("Comment requires id");
        }
    }

    private static void checkHasId(Field field) {
        if (field.getId() == null) {
            throw new IllegalArgumentException("Field requires id");
        }
    }

    private static void checkHasId(Attachment attachment) {
        if (attachment.getId() == null) {
            throw new IllegalArgumentException("Attachment requires id");
        }
    }

    private static void checkHasId(ArticleAttachments attachments) {
        if (attachments.getId() == null) {
            throw new IllegalArgumentException("Attachment requires id");
        }
    }

    private static void checkHasId(User user) {
        if (user.getId() == null) {
            throw new IllegalArgumentException("User requires id");
        }
    }

    private static void checkHasId(Identity identity) {
        if (identity.getId() == null) {
            throw new IllegalArgumentException("Identity requires id");
        }
    }

    private static void checkHasId(Organization organization) {
        if (organization.getId() == null) {
            throw new IllegalArgumentException("Organization requires id");
        }
    }

    private static void checkHasId(Group group) {
        if (group.getId() == null) {
            throw new IllegalArgumentException("Group requires id");
        }
    }

    private static void checkHasId(GroupMembership groupMembership) {
        if (groupMembership.getId() == null) {
            throw new IllegalArgumentException("GroupMembership requires id");
        }
    }

    private void checkHasId(Forum forum) {
        if (forum.getId() == null) {
            throw new IllegalArgumentException("Forum requires id");
        }
    }

    private void checkHasId(Topic topic) {
        if (topic.getId() == null) {
            throw new IllegalArgumentException("Topic requires id");
        }
    }

    private static void checkHasId(OrganizationMembership organizationMembership) {
        if (organizationMembership.getId() == null) {
            throw new IllegalArgumentException("OrganizationMembership requires id");
        }
    }

    private static void checkHasId(Article article) {
        if (article.getId() == null) {
            throw new IllegalArgumentException("Article requires id");
        }
    }

    private static void checkHasId(DynamicContentItem item) {
        if (item.getId() == null) {
            throw new IllegalArgumentException("Item requires id");
        }
    }

    private static void checkHasId(DynamicContentItemVariant variant) {
        if (variant.getId() == null) {
            throw new IllegalArgumentException("Variant requires id");
        }
    }

    private static void checkHasItemId(Long itemId) {
        if (itemId == null) {
            throw new IllegalArgumentException("Variant requires item id");
        }
    }

    private static void checkHasSectionId(Article article) {
        if (article.getSectionId() == null) {
            throw new IllegalArgumentException("Article requires section id");
        }
    }

    private static void checkHasArticleId(Long articleId) {
        if (articleId == null) {
            throw new IllegalArgumentException("Translation requires article id");
        }
    }

    private static void checkHasSectionId(Long articleId) {
        if (articleId == null) {
            throw new IllegalArgumentException("Translation requires section id");
        }
    }

    private static void checkHasCategoryId(Long articleId) {
        if (articleId == null) {
            throw new IllegalArgumentException("Translation requires category id");
        }
    }

    private static void checkHasCategoryId(Section section) {
        if (section.getCategoryId() == null) {
            throw new IllegalArgumentException("Section requires category id");
        }
    }

    private static void checkHasId(Category category) {
        if (category.getId() == null) {
            throw new IllegalArgumentException("Category requires id");
        }
    }

    private static void checkHasId(Section section) {
        if (section.getId() == null) {
            throw new IllegalArgumentException("Section requires id");
        }
    }

    private static void checkHasId(SuspendedTicket ticket) {
        if (ticket == null || ticket.getId() == null) {
            throw new IllegalArgumentException("SuspendedTicket requires id");
        }
    }

    private static void checkHasId(Translation translation) {
        if (translation.getId() == null) {
            throw new IllegalArgumentException("Translation requires id");
        }
    }

    private static void checkHasId(Schedule schedule) {
        if (schedule == null || schedule.getId() == null) {
            throw new IllegalArgumentException("Schedule requires id");
        }
    }

    private static void checkHasId(Holiday holiday) {
        if (holiday == null || holiday.getId() == null) {
            throw new IllegalArgumentException("Holiday requires id");
        }
    }

    private static void checkHasId(PermissionGroup permissionGroup) {
        if (permissionGroup.getId() == null) {
            throw new IllegalArgumentException("PermissionGroup requires id");
        }
    }

    private static void checkHasId(UserSegment userSegment) {
        if (userSegment.getId() == null) {
            throw new IllegalArgumentException("UserSegment requires id");
        }
    }

    private static void checkHasId(ContentTag contentTag) {
        if (contentTag.getId() == null) {
            throw new IllegalArgumentException("Content Tag requires id");
        }
    }

    private static void checkHasName(ContentTag contentTag) {
        if (contentTag.getName() == null || contentTag.getName().trim().isEmpty()) {
            throw new IllegalArgumentException("Content Tag requires name");
        }
    }

    private static void checkHasToken(Attachment.Upload upload) {
        if (upload.getToken() == null) {
            throw new IllegalArgumentException("Upload requires token");
        }
    }

    private static List<Long> idArray(long id, long ... ids) {
        ArrayList<Long> result = new ArrayList<Long>(ids.length + 1);
        result.add(id);
        for (long i : ids) {
            result.add(i);
        }
        return result;
    }

    private static List<String> idArray(String id, String ... ids) {
        ArrayList<String> result = new ArrayList<String>(ids.length + 1);
        result.add(id);
        for (String i : ids) {
            result.add(i);
        }
        return result;
    }

    private static List<String> statusArray(Status ... statuses) {
        ArrayList<String> result = new ArrayList<String>(statuses.length);
        for (Status s : statuses) {
            result.add(s.toString());
        }
        return result;
    }

    private static String getTypeName(Class<?> type) {
        String typeName = null;
        for (Map.Entry<String, Class<? extends SearchResultEntity>> entry : searchResultTypes.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            typeName = entry.getKey();
            break;
        }
        return typeName;
    }

    private TemplateUri getSearchUri(Map<String, Object> params, String query, String typeName) {
        StringBuilder uriTemplate = new StringBuilder("/search.json{?query");
        for (String paramName : params.keySet()) {
            uriTemplate.append(",").append(paramName);
        }
        uriTemplate.append("}");
        TemplateUri templateUri = this.tmpl(uriTemplate.toString()).set("query", query + " type:" + typeName);
        if (params != null) {
            templateUri.set(params);
        }
        return templateUri;
    }

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.setDateFormat((DateFormat)new StdDateFormat());
        mapper.enable(DeserializationFeature.USE_LONG_FOR_INTS);
        return mapper;
    }

    public static class Builder {
        private static final Integer DEFAULT_CBP_PAGE_SIZE = 100;
        private AsyncHttpClient client = null;
        private final String url;
        private String username = null;
        private String password = null;
        private String token = null;
        private String oauthToken = null;
        private int cbpPageSize = DEFAULT_CBP_PAGE_SIZE;
        private final Map<String, String> headers;

        public Builder(String url) {
            this.url = url;
            this.headers = new HashMap<String, String>();
        }

        public Builder setClient(AsyncHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            if (password != null) {
                this.token = null;
                this.oauthToken = null;
            }
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            if (token != null) {
                this.password = null;
                this.oauthToken = null;
            }
            return this;
        }

        public Builder setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            if (oauthToken != null) {
                this.password = null;
                this.token = null;
            }
            return this;
        }

        public Builder setRetry(boolean retry) {
            return this;
        }

        public Builder addHeader(String name, String value) {
            Objects.requireNonNull(name, "Header name cannot be null");
            Objects.requireNonNull(value, "Header value cannot be null");
            this.headers.put(name, value);
            return this;
        }

        public Builder setCbpPageSize(int cbpPageSize) {
            this.cbpPageSize = cbpPageSize;
            return this;
        }

        public Zendesk build() {
            if (this.token != null) {
                return new Zendesk(this.client, this.url, this.username + "/token", this.token, this.headers, this.cbpPageSize);
            }
            if (this.oauthToken != null) {
                return new Zendesk(this.client, this.url, this.oauthToken, this.headers, this.cbpPageSize);
            }
            return new Zendesk(this.client, this.url, this.username, this.password, this.headers, this.cbpPageSize);
        }
    }

    private class PagedIterable<T>
    implements Iterable<T> {
        private final Uri url;
        private final PagedAsyncCompletionHandler<List<T>> handler;

        private PagedIterable(Uri url, PagedAsyncCompletionHandler<List<T>> handler) {
            this.handler = handler;
            this.url = url;
        }

        @Override
        public Iterator<T> iterator() {
            return new PagedIterator(this.url);
        }

        private class PagedIterator
        implements Iterator<T> {
            private Iterator<T> current;
            private String nextPage;

            public PagedIterator(Uri url) {
                this.nextPage = url.toString();
            }

            @Override
            public boolean hasNext() {
                if (this.current == null || !this.current.hasNext()) {
                    if (this.nextPage == null || this.nextPage.equalsIgnoreCase("null")) {
                        return false;
                    }
                    List values = Zendesk.complete(Zendesk.this.submit(Zendesk.this.req("GET", this.nextPage), PagedIterable.this.handler));
                    this.nextPage = PagedIterable.this.handler.getNextPage();
                    this.current = values.iterator();
                }
                return this.current.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class PagedAsyncListCompletionHandler<T>
    extends PagedAsyncCompletionHandler<List<T>> {
        private final Class<T> clazz;
        private final String name;

        public PagedAsyncListCompletionHandler(Class<T> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public List<T> onCompleted(Response response) throws Exception {
            Zendesk.this.logResponse(response);
            if (Zendesk.this.isStatus2xx(response)) {
                JsonNode responseNode = Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes());
                this.setPagedProperties(responseNode, this.clazz);
                ArrayList<Object> values = new ArrayList<Object>();
                for (JsonNode node : responseNode.get(this.name)) {
                    values.add(Zendesk.this.mapper.convertValue((Object)node, this.clazz));
                }
                return values;
            }
            if (Zendesk.this.isRateLimitResponse(response)) {
                throw new ZendeskResponseRateLimitException(response);
            }
            throw new ZendeskResponseException(response);
        }
    }

    private abstract class PagedAsyncCompletionHandler<T>
    extends ZendeskAsyncCompletionHandler<T> {
        private String nextPage;

        private PagedAsyncCompletionHandler() {
        }

        public void setPagedProperties(JsonNode responseNode, Class<?> clazz) {
            JsonNode node = responseNode.get(Zendesk.CURSOR_LINKS);
            node = node != null ? node.get(Zendesk.CURSOR_NEXT_PAGE) : responseNode.get(Zendesk.NEXT_PAGE);
            if (node == null) {
                this.nextPage = null;
                if (Zendesk.this.logger.isDebugEnabled()) {
                    Zendesk.this.logger.debug("next_page property not found, pagination not supported" + (String)(clazz != null ? " for " + clazz.getName() : ""));
                }
            } else {
                this.nextPage = node.asText();
            }
        }

        public String getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(String nextPage) {
            this.nextPage = nextPage;
        }
    }

    private class BasicAsyncCompletionHandler<T>
    extends ZendeskAsyncCompletionHandler<T> {
        private final Class<T> clazz;
        private final String name;
        private final Class[] typeParams;

        public BasicAsyncCompletionHandler(Class clazz, String name, Class ... typeParams) {
            this.clazz = clazz;
            this.name = name;
            this.typeParams = typeParams;
        }

        public T onCompleted(Response response) throws Exception {
            Zendesk.this.logResponse(response);
            if (Zendesk.this.isStatus2xx(response)) {
                if (this.typeParams.length > 0) {
                    JavaType type = Zendesk.this.mapper.getTypeFactory().constructParametricType(this.clazz, this.typeParams);
                    return (T)Zendesk.this.mapper.convertValue((Object)Zendesk.this.mapper.readTree(response.getResponseBodyAsStream()).get(this.name), type);
                }
                return (T)Zendesk.this.mapper.convertValue((Object)Zendesk.this.mapper.readTree(response.getResponseBodyAsStream()).get(this.name), this.clazz);
            }
            if (Zendesk.this.isRateLimitResponse(response)) {
                throw new ZendeskResponseRateLimitException(response);
            }
            if (response.getStatusCode() == 404) {
                return null;
            }
            throw new ZendeskResponseException(response);
        }
    }

    private static abstract class ZendeskAsyncCompletionHandler<T>
    extends AsyncCompletionHandler<T> {
        private ZendeskAsyncCompletionHandler() {
        }

        public void onThrowable(Throwable t) {
            if (t instanceof IOException) {
                throw new ZendeskException(t);
            }
            super.onThrowable(t);
        }
    }
}

