/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.CommentType;
import org.zendesk.client.v2.model.Via;

public class Comment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String body;
    private String htmlBody;
    private Long authorId;
    private List<String> uploads;
    private List<Attachment> attachments;
    private Date createdAt;
    private Boolean publicComment;
    private CommentType type;
    private Via via;

    public Comment() {
    }

    public Comment(String body) {
        this.body = body;
    }

    public Comment(String body, String ... uploads) {
        this.body = body;
        this.uploads = uploads.length == 0 ? null : Arrays.asList(uploads);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @JsonProperty(value="html_body")
    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public List<String> getUploads() {
        return this.uploads;
    }

    public void setUploads(List<String> uploads) {
        this.uploads = uploads;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    @JsonProperty(value="author_id")
    public Long getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Long authorId) {
        this.authorId = authorId;
    }

    @JsonProperty(value="created_at")
    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="public")
    public Boolean isPublic() {
        return this.publicComment;
    }

    public void setPublic(Boolean isPublic) {
        this.publicComment = isPublic;
    }

    @JsonProperty(value="type")
    public CommentType getType() {
        return this.type;
    }

    public void setType(CommentType type) {
        this.type = type;
    }

    @JsonProperty(value="via")
    public Via getVia() {
        return this.via;
    }

    public void setVia(Via via) {
        this.via = via;
    }

    public String toString() {
        return "Comment{id=" + this.id + ", body='" + this.body + "', authorId=" + this.authorId + ", attachments=" + this.attachments + ", createdAt=" + this.createdAt + ", uploads=" + this.uploads + ", via=" + this.via + "}";
    }
}

