/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.sync.replication;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.cloudant.sync.replication.PeriodicReplicationReceiver;
import com.cloudant.sync.replication.PeriodicReplicationService;

public abstract class WifiPeriodicReplicationReceiver<T extends PeriodicReplicationService>
extends PeriodicReplicationReceiver {
    private static final String WAS_ON_WIFI_SUFFIX = ".wasOnWifi";

    protected WifiPeriodicReplicationReceiver(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        int command = -1;
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            boolean isConnectedToWifi = WifiPeriodicReplicationReceiver.isConnectedToWifi(context);
            if (isConnectedToWifi == this.wasOnWifi(context)) {
                return;
            }
            if (isConnectedToWifi) {
                this.setWasOnWifi(context, true);
                if (PeriodicReplicationService.replicationsPending(context, this.clazz)) {
                    command = 0;
                }
            } else if (!WifiPeriodicReplicationReceiver.isConnectedToWifi(context)) {
                this.setWasOnWifi(context, false);
                command = 1;
            }
        } else if ("android.intent.action.BOOT_COMPLETED".equals(intent.getAction())) {
            super.onReceive(context, intent);
            this.setWasOnWifi(context, false);
            if (PeriodicReplicationService.isPeriodicReplicationEnabled(context, this.clazz)) {
                command = 2;
            }
        } else if (!"com.cloudant.sync.replication.PeriodicReplicationReceiver.Alarm".equals(intent.getAction()) || WifiPeriodicReplicationReceiver.isConnectedToWifi(context)) {
            super.onReceive(context, intent);
        } else {
            PeriodicReplicationService.setReplicationsPending(context, this.clazz, true);
        }
        if (command != -1) {
            Intent serviceIntent = new Intent(context.getApplicationContext(), this.clazz);
            serviceIntent.putExtra("command", command);
            WifiPeriodicReplicationReceiver.startWakefulService((Context)context, (Intent)serviceIntent);
        }
    }

    public static boolean isConnectedToWifi(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.getType() == 1 && activeNetwork.isConnectedOrConnecting();
    }

    private void setWasOnWifi(Context context, boolean onWifi) {
        SharedPreferences prefs = context.getSharedPreferences("com.cloudant.preferences", 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean(PeriodicReplicationService.constructKey(this.clazz, WAS_ON_WIFI_SUFFIX), onWifi);
        editor.apply();
    }

    private boolean wasOnWifi(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("com.cloudant.preferences", 0);
        return prefs.getBoolean(PeriodicReplicationService.constructKey(this.clazz, WAS_ON_WIFI_SUFFIX), false);
    }
}

