/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.sync.replication;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.cloudant.sync.replication.PeriodicReplicationReceiver;
import com.cloudant.sync.replication.ReplicationService;

public abstract class PeriodicReplicationService<T extends PeriodicReplicationReceiver>
extends ReplicationService {
    static final String PREFERENCES_FILE_NAME = "com.cloudant.preferences";
    private static final String LAST_ALARM_ELAPSED_TIME_SUFFIX = ".lastAlarmElapsed";
    private static final String LAST_ALARM_CLOCK_TIME_SUFFIX = ".lastAlarmClock";
    private static final String PERIODIC_REPLICATION_ENABLED_SUFFIX = ".periodicReplicationsActive";
    private static final String EXPLICITLY_STOPPED_SUFFIX = ".explicitlyStopped";
    private static final String REPLICATIONS_PENDING_SUFFIX = ".replicationsPending";
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    public static final int COMMAND_START_PERIODIC_REPLICATION = 2;
    public static final int COMMAND_STOP_PERIODIC_REPLICATION = 3;
    public static final int COMMAND_DEVICE_REBOOTED = 4;
    public static final int COMMAND_RESET_REPLICATION_TIMERS = 5;
    private static final String TAG = "PRS";
    private SharedPreferences mPrefs;
    Class<T> clazz;
    protected boolean mBound;

    protected PeriodicReplicationService(Class<T> clazz) {
        this.clazz = clazz;
    }

    protected void upgradePreferences() {
        String alarmDueElapsed = "com.cloudant.sync.replication.PeriodicReplicationService.alarmDueElapsed";
        if (this.mPrefs.contains(alarmDueElapsed)) {
            String alarmDueClock = "com.cloudant.sync.replication.PeriodicReplicationService.alarmDueClock";
            String replicationsActive = "com.cloudant.sync.replication.PeriodicReplicationService.periodicReplicationsActive";
            long elapsed = this.mPrefs.getLong(alarmDueElapsed, 0L);
            long clock = this.mPrefs.getLong(alarmDueClock, 0L);
            boolean enabled = this.mPrefs.getBoolean(replicationsActive, false);
            SharedPreferences.Editor editor = this.mPrefs.edit();
            editor.putLong(this.constructKey(LAST_ALARM_ELAPSED_TIME_SUFFIX), elapsed - (long)this.getIntervalInSeconds() * 1000L);
            editor.putLong(this.constructKey(LAST_ALARM_CLOCK_TIME_SUFFIX), clock - (long)this.getIntervalInSeconds() * 1000L);
            editor.putBoolean(this.constructKey(PERIODIC_REPLICATION_ENABLED_SUFFIX), enabled);
            editor.remove(alarmDueElapsed);
            editor.remove(alarmDueClock);
            editor.remove(replicationsActive);
            editor.apply();
        }
    }

    @Override
    protected Handler getHandler(Looper looper) {
        return new ServiceHandler(looper);
    }

    @Override
    public void onCreate() {
        this.mPrefs = this.getSharedPreferences(PREFERENCES_FILE_NAME, 0);
        this.upgradePreferences();
        super.onCreate();
    }

    @Override
    public synchronized IBinder onBind(Intent intent) {
        this.mBound = true;
        if (this.isPeriodicReplicationEnabled()) {
            this.restartPeriodicReplications();
        } else if (this.startReplicationOnBind()) {
            this.startPeriodicReplication();
        }
        return super.onBind(intent);
    }

    @Override
    public synchronized boolean onUnbind(Intent intent) {
        super.onUnbind(intent);
        this.mBound = false;
        if (this.isPeriodicReplicationEnabled()) {
            this.restartPeriodicReplications();
        }
        return true;
    }

    @Override
    public synchronized void onRebind(Intent intent) {
        super.onRebind(intent);
        this.mBound = true;
        if (this.isPeriodicReplicationEnabled()) {
            this.restartPeriodicReplications();
        } else if (this.startReplicationOnBind()) {
            this.startPeriodicReplication();
        }
    }

    @Override
    protected void startReplications() {
        super.startReplications();
        this.setLastAlarmTime(0L);
        PeriodicReplicationService.setReplicationsPending((Context)this, ((Object)((Object)this)).getClass(), true);
    }

    public synchronized void startPeriodicReplication() {
        if (!this.isPeriodicReplicationEnabled()) {
            long initialTriggerTime;
            this.setPeriodicReplicationEnabled(true);
            AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
            Intent alarmIntent = new Intent((Context)this, this.clazz);
            alarmIntent.setAction("com.cloudant.sync.replication.PeriodicReplicationReceiver.Alarm");
            PendingIntent pendingAlarmIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)alarmIntent, (int)0);
            if (this.explicitlyStopped()) {
                initialTriggerTime = SystemClock.elapsedRealtime();
                this.setExplicitlyStopped(false);
            } else {
                initialTriggerTime = this.getNextAlarmDueElapsedTime();
            }
            alarmManager.setInexactRepeating(2, initialTriggerTime, (long)this.getIntervalInSeconds() * 1000L, pendingAlarmIntent);
        } else {
            Log.i((String)TAG, (String)"Attempted to start an already running alarm manager");
        }
    }

    public synchronized void stopPeriodicReplication() {
        if (this.isPeriodicReplicationEnabled()) {
            this.setPeriodicReplicationEnabled(false);
            AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
            Intent alarmIntent = new Intent((Context)this, this.clazz);
            alarmIntent.setAction("com.cloudant.sync.replication.PeriodicReplicationReceiver.Alarm");
            PendingIntent pendingAlarmIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)alarmIntent, (int)0);
            alarmManager.cancel(pendingAlarmIntent);
            this.stopReplications();
        } else {
            Log.i((String)TAG, (String)"Attempted to stop an already stopped alarm manager");
        }
    }

    protected final void restartPeriodicReplications() {
        this.stopPeriodicReplication();
        this.startPeriodicReplication();
    }

    private void setLastAlarmTime(long millisBeforeNow) {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putLong(this.constructKey(LAST_ALARM_ELAPSED_TIME_SUFFIX), SystemClock.elapsedRealtime() - millisBeforeNow);
        editor.putLong(this.constructKey(LAST_ALARM_CLOCK_TIME_SUFFIX), System.currentTimeMillis() - millisBeforeNow);
        editor.apply();
    }

    private long getNextAlarmDueElapsedTime() {
        return this.mPrefs.getLong(this.constructKey(LAST_ALARM_ELAPSED_TIME_SUFFIX), 0L) + (long)this.getIntervalInSeconds() * 1000L;
    }

    private long getNextAlarmDueClockTime() {
        return this.mPrefs.getLong(this.constructKey(LAST_ALARM_CLOCK_TIME_SUFFIX), 0L) + (long)this.getIntervalInSeconds() * 1000L;
    }

    private void setPeriodicReplicationEnabled(boolean running) {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putBoolean(this.constructKey(PERIODIC_REPLICATION_ENABLED_SUFFIX), running);
        editor.apply();
    }

    private boolean isPeriodicReplicationEnabled() {
        return this.mPrefs.getBoolean(this.constructKey(PERIODIC_REPLICATION_ENABLED_SUFFIX), false);
    }

    public static boolean isPeriodicReplicationEnabled(Context context, Class<? extends PeriodicReplicationService> prsClass) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCES_FILE_NAME, 0);
        return prefs.getBoolean(PeriodicReplicationService.constructKey(prsClass, PERIODIC_REPLICATION_ENABLED_SUFFIX), false);
    }

    private void setExplicitlyStopped(boolean explicitlyStopped) {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putBoolean(this.constructKey(EXPLICITLY_STOPPED_SUFFIX), explicitlyStopped);
        editor.apply();
    }

    private boolean explicitlyStopped() {
        return this.mPrefs.getBoolean(this.constructKey(EXPLICITLY_STOPPED_SUFFIX), true);
    }

    private void resetAlarmDueTimesOnReboot() {
        this.setPeriodicReplicationEnabled(false);
        long initialInterval = this.getNextAlarmDueClockTime() - System.currentTimeMillis();
        if (initialInterval < 0L) {
            this.setLastAlarmTime((long)this.getIntervalInSeconds() * 1000L);
        } else if (initialInterval > (long)this.getIntervalInSeconds() * 1000L) {
            this.setLastAlarmTime(0L);
        } else {
            this.setLastAlarmTime((long)this.getIntervalInSeconds() * 1000L - initialInterval);
        }
    }

    private int getIntervalInSeconds() {
        if (this.mBound) {
            return this.getBoundIntervalInSeconds();
        }
        return this.getUnboundIntervalInSeconds();
    }

    String constructKey(String suffix) {
        return PeriodicReplicationService.constructKey(((Object)((Object)this)).getClass(), suffix);
    }

    static String constructKey(Class<? extends PeriodicReplicationService> prsClass, String suffix) {
        return prsClass.getName() + suffix;
    }

    @Override
    public void allReplicationsCompleted() {
        super.allReplicationsCompleted();
        PeriodicReplicationService.setReplicationsPending((Context)this, ((Object)((Object)this)).getClass(), false);
    }

    public static void setReplicationsPending(Context context, Class<? extends PeriodicReplicationService> prsClass, boolean pending) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCES_FILE_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean(PeriodicReplicationService.constructKey(prsClass, REPLICATIONS_PENDING_SUFFIX), pending);
        editor.apply();
    }

    public static boolean replicationsPending(Context context, Class<? extends PeriodicReplicationService> prsClass) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCES_FILE_NAME, 0);
        return prefs.getBoolean(PeriodicReplicationService.constructKey(prsClass, REPLICATIONS_PENDING_SUFFIX), true);
    }

    protected abstract int getBoundIntervalInSeconds();

    protected abstract int getUnboundIntervalInSeconds();

    protected abstract boolean startReplicationOnBind();

    protected class ServiceHandler
    extends ReplicationService.ServiceHandler {
        public ServiceHandler(Looper looper) {
            super(PeriodicReplicationService.this, looper);
        }

        @Override
        public void handleMessage(Message msg) {
            Intent intent = (Intent)msg.getData().getParcelable("intent");
            switch (msg.arg2) {
                case 2: {
                    PeriodicReplicationService.this.startPeriodicReplication();
                    PeriodicReplicationService.this.releaseWakeLock(intent);
                    PeriodicReplicationService.this.stopSelf(msg.arg1);
                    break;
                }
                case 3: {
                    PeriodicReplicationService.this.stopPeriodicReplication();
                    PeriodicReplicationService.this.setExplicitlyStopped(true);
                    PeriodicReplicationService.this.releaseWakeLock(intent);
                    PeriodicReplicationService.this.stopSelf(msg.arg1);
                    break;
                }
                case 4: {
                    PeriodicReplicationService.this.resetAlarmDueTimesOnReboot();
                    PeriodicReplicationService.this.releaseWakeLock(intent);
                    PeriodicReplicationService.this.stopSelf(msg.arg1);
                    break;
                }
                case 5: {
                    PeriodicReplicationService.this.restartPeriodicReplications();
                    PeriodicReplicationService.this.releaseWakeLock(intent);
                    PeriodicReplicationService.this.stopSelf(msg.arg1);
                    break;
                }
            }
            super.handleMessage(msg);
        }
    }
}

