/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.interceptors;

import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class UserAgentInterceptor
implements HttpConnectionRequestInterceptor {
    private final String userAgent;

    public UserAgentInterceptor(ClassLoader loader, String filepath) {
        String prefix = UserAgentInterceptor.loadUA(loader, filepath);
        String runtimeVersion = System.getProperty("java.version", "Unknown");
        if (runtimeVersion.equals("0")) {
            runtimeVersion = "Unknown";
            try {
                Class<?> c = Class.forName("android.os.Build$VERSION");
                runtimeVersion = String.valueOf(c.getField("SDK_INT").getInt(null));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.userAgent = String.format("%s/%s/%s/%s/%s", prefix, runtimeVersion, System.getProperty("java.vendor"), System.getProperty("os.name"), System.getProperty("os.arch"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadUA(ClassLoader loader, String filename) {
        String ua = "cloudant-http";
        String version = "unknown";
        InputStream propStream = loader.getResourceAsStream(filename);
        Properties properties = new Properties();
        try {
            if (propStream != null) {
                try {
                    properties.load(propStream);
                }
                finally {
                    propStream.close();
                }
            }
            ua = properties.getProperty("user.agent.name", ua);
            version = properties.getProperty("user.agent.version", version);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return String.format(Locale.ENGLISH, "%s/%s", ua, version);
    }

    @Override
    public HttpConnectionInterceptorContext interceptRequest(HttpConnectionInterceptorContext context) {
        context.connection.getConnection().setRequestProperty("User-Agent", this.userAgent);
        return context;
    }

    public String getUserAgent() {
        return this.userAgent;
    }
}

