/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.interceptors;

import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import java.net.HttpURLConnection;
import java.util.concurrent.TimeUnit;

public class TimeoutCustomizationInterceptor
implements HttpConnectionRequestInterceptor {
    private final int connectTimeout;
    private final int readTimeout;

    public TimeoutCustomizationInterceptor(long connectTimeoutValue, TimeUnit connectTimeoutUnit, long readTimeoutValue, TimeUnit readTimeoutUnit) {
        this.connectTimeout = this.asIntMillis(connectTimeoutValue, connectTimeoutUnit);
        this.readTimeout = this.asIntMillis(readTimeoutValue, readTimeoutUnit);
    }

    @Override
    public HttpConnectionInterceptorContext interceptRequest(HttpConnectionInterceptorContext context) {
        HttpURLConnection connection = context.connection.getConnection();
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        return context;
    }

    private int asIntMillis(long timeout, TimeUnit timeoutUnit) {
        Long timeoutLongMillis = timeoutUnit.toMillis(timeout);
        int timeoutMillis = timeoutLongMillis < 0L ? 0 : (timeoutLongMillis > Integer.MAX_VALUE ? Integer.MAX_VALUE : timeoutLongMillis.intValue());
        return timeoutMillis;
    }
}

