/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.interceptors;

import com.cloudant.http.HttpConnection;
import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.internal.interceptors.CookieInterceptorBase;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class IamCookieInterceptor
extends CookieInterceptorBase {
    public static final String IAM_TOKEN_SERVER_URL_PROPERTY_KEY = "com.cloudant.client.iamserver";
    public final URL iamServerUrl;
    private final byte[] tokenRequestPayload;

    public IamCookieInterceptor(String apiKey, String baseUrl) {
        super(baseUrl, "/_iam_session", null);
        try {
            this.iamServerUrl = new URL(System.getProperty(IAM_TOKEN_SERVER_URL_PROPERTY_KEY, "https://iam.cloud.ibm.com/identity/token"));
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("IAM server property was not a valid URL", mue);
        }
        try {
            this.tokenRequestPayload = String.format(Locale.ENGLISH, "grant_type=urn:ibm:params:oauth:grant-type:apikey&response_type=cloud_iam&apikey=%s", apiKey).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getIamServerUrl() {
        return this.iamServerUrl;
    }

    @Override
    protected byte[] getSessionRequestPayload(HttpConnectionInterceptorContext context) {
        HttpConnection tokenConn = super.makeSessionRequest(this.iamServerUrl, this.tokenRequestPayload, "application/x-www-form-urlencoded", context);
        try {
            return tokenConn.responseAsBytes();
        }
        catch (IOException e) {
            throw this.wrapIOException("Error reading token response body from", tokenConn.getConnection(), e);
        }
    }
}

