/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.interceptors;

import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.internal.Utils;
import com.cloudant.http.internal.interceptors.CookieInterceptorBase;
import com.cloudant.http.internal.interceptors.HttpConnectionInterceptorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.logging.Level;

public class CookieInterceptor
extends CookieInterceptorBase {
    private final byte[] auth;

    public CookieInterceptor(String username, String password, String baseURL) {
        super(baseURL, "/_session", "application/x-www-form-urlencoded");
        try {
            this.auth = String.format("name=%s&password=%s", URLEncoder.encode(username, "UTF-8"), URLEncoder.encode(password, "UTF-8")).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected byte[] getSessionRequestPayload(HttpConnectionInterceptorContext context) {
        return this.auth;
    }

    @Override
    protected boolean shouldRenew(HttpURLConnection connection, int statusCode) {
        try {
            if (statusCode == 403) {
                InputStream errorStream = connection.getErrorStream();
                String errorString = null;
                if (errorStream != null) {
                    errorString = Utils.collectAndCloseStream(connection.getErrorStream());
                    logger.log(Level.FINE, String.format(Locale.ENGLISH, "Intercepted response %d %s", statusCode, errorString));
                }
                if (errorString != null && errorString.matches("(?siu).*\\\"error\\\"\\s*:\\s*\\\"credentials_expired\\\".*")) {
                    return true;
                }
                HttpConnectionInterceptorException toThrow = new HttpConnectionInterceptorException(errorString, null);
                toThrow.deserialize = errorString != null;
                throw toThrow;
            }
        }
        catch (IOException e) {
            throw this.wrapIOException("Failed to read HTTP reponse code or body from", connection, e);
        }
        return false;
    }
}

