/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                logger.log(Level.FINEST, "Unable to close resource.", ioe);
            }
        }
    }

    public static void consumeStream(InputStream is) {
        if (is != null) {
            try {
                long copied = IOUtils.copyLarge((InputStream)is, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                if (copied > 0L) {
                    logger.log(Level.WARNING, "Consumed unused HTTP response error stream.");
                }
            }
            catch (IOException ioe) {
                logger.log(Level.FINEST, "Unable to consume stream.", ioe);
            }
        }
    }

    public static void consumeAndCloseStream(InputStream is) {
        try {
            Utils.consumeStream(is);
        }
        finally {
            Utils.close(is);
        }
    }

    public static String collectAndCloseStream(InputStream is) throws IOException {
        if (is != null) {
            try {
                String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                return string;
            }
            finally {
                Utils.close(is);
            }
        }
        return null;
    }
}

