/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal;

import com.cloudant.http.HttpConnection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;

public class DefaultHttpUrlConnectionFactory
implements HttpConnection.HttpUrlConnectionFactory {
    private static final Logger logger = Logger.getLogger(DefaultHttpUrlConnectionFactory.class.getName());
    protected Proxy proxy = null;

    @Override
    public HttpURLConnection openConnection(URL url) throws IOException {
        if (this.proxy != null) {
            return (HttpURLConnection)url.openConnection(this.proxy);
        }
        return (HttpURLConnection)url.openConnection();
    }

    @Override
    public void setProxy(URL proxyUrl) {
        if (!"http".equals(proxyUrl.getProtocol())) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The proxy URL %s is invalid. Only HTTP type proxies are supported.", proxyUrl));
        }
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort()));
        logger.config(String.format("Configured HTTP proxy url %s", proxyUrl));
    }

    @Override
    public void setProxyAuthentication(PasswordAuthentication proxyAuthentication) {
    }

    @Override
    public void shutdown() {
    }
}

