/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.interceptors;

import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.internal.Base64OutputStreamFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicAuthInterceptor
implements HttpConnectionRequestInterceptor {
    protected final String authHeader;
    protected final String encodedAuth;

    public BasicAuthInterceptor(String userinfo) {
        this(userinfo, "Authorization");
    }

    protected BasicAuthInterceptor(String userinfo, String authHeader) {
        this.encodedAuth = this.encodedCreds(userinfo);
        this.authHeader = authHeader;
    }

    public static BasicAuthInterceptor createFromCredentials(String username, String password) {
        return new BasicAuthInterceptor(username + ":" + password);
    }

    @Override
    public HttpConnectionInterceptorContext interceptRequest(HttpConnectionInterceptorContext context) {
        context.connection.requestProperties.put(this.authHeader, String.format("Basic %s", this.encodedAuth));
        return context;
    }

    private String encodedCreds(String userInfo) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream bos = Base64OutputStreamFactory.get(baos);
            bos.write(userInfo.getBytes("UTF-8"));
            bos.flush();
            bos.close();
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            Logger.getLogger(BasicAuthInterceptor.class.getName()).log(Level.SEVERE, "IOExceptionduring credential encoding", e);
            return null;
        }
    }
}

