/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http;

import com.cloudant.http.HttpConnection;
import com.cloudant.http.HttpConnectionInterceptor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpConnectionInterceptorContext {
    public boolean replayRequest;
    public final HttpConnection connection;
    final Map<HttpConnectionInterceptor, Map<String, Object>> interceptorStates;

    public HttpConnectionInterceptorContext(HttpConnection connection) {
        this(connection, new ConcurrentHashMap<HttpConnectionInterceptor, Map<String, Object>>());
    }

    HttpConnectionInterceptorContext(HttpConnection connection, Map<HttpConnectionInterceptor, Map<String, Object>> interceptorStates) {
        this.replayRequest = false;
        this.connection = connection;
        this.interceptorStates = interceptorStates;
    }

    public HttpConnectionInterceptorContext(HttpConnectionInterceptorContext other) {
        this.replayRequest = other.replayRequest;
        this.connection = other.connection;
        this.interceptorStates = other.interceptorStates;
    }

    public <T> void setState(HttpConnectionInterceptor interceptor, String stateName, T stateObjectToStore) {
        Map<String, Object> state = this.interceptorStates.get(interceptor);
        if (state == null) {
            state = new ConcurrentHashMap<String, Object>();
            this.interceptorStates.put(interceptor, state);
        }
        state.put(stateName, stateObjectToStore);
    }

    public <T> T getState(HttpConnectionInterceptor interceptor, String stateName, Class<T> stateType) {
        Map<String, Object> state = this.interceptorStates.get(interceptor);
        if (state != null) {
            return stateType.cast(state.get(stateName));
        }
        return null;
    }
}

