/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.org.lightcouch;

import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.org.lightcouch.ChangesResult;
import com.cloudant.client.org.lightcouch.CouchDatabaseBase;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;

public class Changes {
    private BufferedReader reader;
    private ChangesResult.Row nextRow;
    private boolean stop;
    private CouchDatabaseBase dbc;
    private Gson gson;
    private DatabaseURIHelper databaseHelper;

    Changes(CouchDatabaseBase dbc) {
        this.dbc = dbc;
        this.gson = dbc.couchDbClient.getGson();
        this.databaseHelper = new DatabaseURIHelper(dbc.getDBUri());
    }

    public Changes continuousChanges() {
        URI uri = this.databaseHelper.changesUri("feed", "continuous");
        InputStream in = this.dbc.couchDbClient.get(uri);
        try {
            InputStreamReader is = new InputStreamReader(in, "UTF-8");
            this.setReader(new BufferedReader(is));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public boolean hasNext() {
        return this.readNextRow();
    }

    public ChangesResult.Row next() {
        return this.getNextRow();
    }

    public void stop() {
        this.stop = true;
    }

    public ChangesResult getChanges() {
        URI uri = this.databaseHelper.changesUri("feed", "normal");
        return this.dbc.couchDbClient.get(uri, ChangesResult.class);
    }

    public Changes since(String since) {
        this.databaseHelper.query("since", since);
        return this;
    }

    public Changes limit(int limit) {
        this.databaseHelper.query("limit", limit);
        return this;
    }

    public Changes heartBeat(long heartBeat) {
        this.databaseHelper.query("heartbeat", heartBeat);
        return this;
    }

    public Changes timeout(long timeout) {
        this.databaseHelper.query("timeout", timeout);
        return this;
    }

    public Changes filter(String filter) {
        this.databaseHelper.query("filter", filter);
        return this;
    }

    public Changes includeDocs(boolean includeDocs) {
        this.databaseHelper.query("include_docs", includeDocs);
        return this;
    }

    public Changes style(String style) {
        this.databaseHelper.query("style", style);
        return this;
    }

    private boolean readNextRow() {
        boolean hasNext = false;
        try {
            if (!this.stop) {
                String row;
                while ((row = this.getReader().readLine()) != null && row.isEmpty() || row == null || row.startsWith("{\"last_seq\":")) {
                }
                this.setNextRow((ChangesResult.Row)this.gson.fromJson(row, ChangesResult.Row.class));
                hasNext = true;
            }
        }
        catch (Exception e) {
            this.terminate();
            throw new CouchDbException("Error reading continuous stream.", e);
        }
        if (!hasNext) {
            this.terminate();
        }
        return hasNext;
    }

    private BufferedReader getReader() {
        return this.reader;
    }

    private void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    private ChangesResult.Row getNextRow() {
        return this.nextRow;
    }

    private void setNextRow(ChangesResult.Row nextRow) {
        this.nextRow = nextRow;
    }

    private void terminate() {
        CouchDbUtil.close(this.getReader());
    }
}

