/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.views.ViewRequest;
import com.cloudant.client.api.views.ViewResponse;
import com.cloudant.client.internal.views.PageMetadata;
import com.cloudant.client.internal.views.PaginationToken;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.cloudant.client.internal.views.ViewRequester;
import com.cloudant.client.internal.views.ViewResponseImpl;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;

class ViewRequestImpl<K, V>
implements ViewRequest<K, V> {
    private final ViewQueryParameters<K, V> viewQueryParameters;

    ViewRequestImpl(ViewQueryParameters<K, V> viewQueryParameters) {
        this.viewQueryParameters = viewQueryParameters;
    }

    @Override
    public ViewResponse<K, V> getResponse() throws IOException {
        JsonObject response = ViewRequester.getResponseAsJson(this.viewQueryParameters);
        return new ViewResponseImpl<K, V>(this.viewQueryParameters, response);
    }

    @Override
    public ViewResponse<K, V> getResponse(String paginationToken) throws IOException {
        if (paginationToken == null) {
            return this.getResponse();
        }
        PageMetadata<K, V> pageMetadata = PaginationToken.mergeTokenAndQueryParameters(paginationToken, this.viewQueryParameters);
        return new ViewResponseImpl<K, V>(this.viewQueryParameters, ViewRequester.getResponseAsJson(pageMetadata.pageRequestParameters), pageMetadata);
    }

    @Override
    public V getSingleValue() throws IOException {
        List<V> values = this.getResponse().getValues();
        if (values.size() > 0) {
            return values.get(0);
        }
        return null;
    }
}

