/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api;

import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.Database;
import com.cloudant.client.api.model.DesignDocument;
import com.cloudant.client.api.model.Response;
import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.client.org.lightcouch.NoDocumentException;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.cloudant.http.Http;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class DesignDocumentManager {
    private static final String DESIGN_PREFIX = "_design/";
    private final CloudantClient client;
    private final Database db;

    DesignDocumentManager(CloudantClient client, Database db) {
        this.client = client;
        this.db = db;
    }

    public Response put(DesignDocument document) {
        DesignDocument documentFromDb;
        CouchDbUtil.assertNotEmpty(document, "DesignDocument");
        DesignDocumentManager.ensureDesignPrefixObject(document);
        try {
            documentFromDb = this.get(document.getId());
        }
        catch (NoDocumentException e) {
            return this.db.save(document);
        }
        if (!document.equals(documentFromDb)) {
            document.setRevision(documentFromDb.getRevision());
            return this.db.update(document);
        }
        return null;
    }

    public void put(DesignDocument ... designDocs) {
        for (DesignDocument designDocument : designDocs) {
            this.put(designDocument);
        }
    }

    public DesignDocument get(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        return this.db.find(DesignDocument.class, DesignDocumentManager.ensureDesignPrefix(id));
    }

    public DesignDocument get(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(id, "rev");
        return this.db.find(DesignDocument.class, DesignDocumentManager.ensureDesignPrefix(id), rev);
    }

    public Response remove(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        id = DesignDocumentManager.ensureDesignPrefix(id);
        String revision = null;
        revision = this.client.executeRequest(Http.HEAD((URI)new DatabaseURIHelper(this.db.getDBUri()).documentUri(id))).getConnection().getHeaderField("ETag");
        if (revision != null) {
            revision = revision.substring(1, revision.length() - 1);
            return this.db.remove(id, revision);
        }
        throw new CouchDbException("No ETag header found for design document with id " + id);
    }

    public Response remove(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(id, "rev");
        return this.db.remove(DesignDocumentManager.ensureDesignPrefix(id), rev);
    }

    public Response remove(DesignDocument designDocument) {
        CouchDbUtil.assertNotEmpty(designDocument, "DesignDocument");
        DesignDocumentManager.ensureDesignPrefixObject(designDocument);
        return this.db.remove(designDocument);
    }

    public static List<DesignDocument> fromDirectory(File directory) throws FileNotFoundException {
        ArrayList<DesignDocument> designDocuments = new ArrayList<DesignDocument>();
        if (directory.isDirectory()) {
            Collection files = FileUtils.listFiles((File)directory, null, (boolean)true);
            for (File designDocFile : files) {
                designDocuments.add(DesignDocumentManager.fromFile(designDocFile));
            }
        } else {
            designDocuments.add(DesignDocumentManager.fromFile(directory));
        }
        return designDocuments;
    }

    public static DesignDocument fromFile(File file) throws FileNotFoundException {
        CouchDbUtil.assertNotEmpty(file, "Design js file");
        Gson gson = new Gson();
        try {
            DesignDocument designDocument = (DesignDocument)gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), DesignDocument.class);
            return designDocument;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void ensureDesignPrefixObject(DesignDocument ddoc) {
        ddoc.setId(DesignDocumentManager.ensureDesignPrefix(ddoc.getId()));
    }

    private static String ensureDesignPrefix(String id) {
        if (!id.startsWith(DESIGN_PREFIX)) {
            id = DESIGN_PREFIX + id;
        }
        return id;
    }
}

